/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.business.service.performctrl.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.conm.business.pojo.performctrl.ContractEntryInfo;
import kd.scmc.conm.business.pojo.performctrl.ContractInfo;
import kd.scmc.conm.business.pojo.performctrl.PerformBillEntryInfo;
import kd.scmc.conm.business.service.performctrl.validator.IPerformDataValidator;

public class PerformDataValidator
implements IPerformDataValidator<ContractInfo> {
    private static final Log logger = LogFactory.getLog(PerformDataValidator.class);
    private ContractInfo data;
    private Map<String, Object> validateContext = new HashMap<String, Object>();
    private List<OperateErrorInfo> errorInfos = new ArrayList<OperateErrorInfo>();

    @Override
    public List<OperateErrorInfo> execute(ContractInfo contractInfo, String operateKey, String checkType) {
        if (contractInfo == null || StringUtils.isEmpty((CharSequence)operateKey) || StringUtils.isEmpty((CharSequence)checkType)) {
            return this.errorInfos;
        }
        this.errorInfos.clear();
        this.data = contractInfo;
        LinkedHashSet<String> actions = new LinkedHashSet<String>();
        switch (checkType) {
            case "MON": {
                actions.add("amount");
                break;
            }
            case "NUM": {
                actions.add("qty");
                break;
            }
            case "PRI": {
                actions.add("price");
                break;
            }
            case "M&N": {
                actions.add("amount");
                actions.add("qty");
                break;
            }
            case "M&P": {
                actions.add("amount");
                actions.add("price");
                break;
            }
            case "M&N&P": {
                actions.add("amount");
                actions.add("qty");
                actions.add("price");
                break;
            }
            case "NAN": {
                return this.errorInfos;
            }
        }
        for (String action : actions) {
            if (action.equals("qty")) {
                this.qtyCheck();
                continue;
            }
            if (action.equals("amount")) {
                this.amountCheck();
                continue;
            }
            if (!action.equals("price")) continue;
            this.priceCheck();
        }
        return this.errorInfos;
    }

    @Override
    public List<OperateErrorInfo> qtyCheck() {
        ArrayList<OperateErrorInfo> result = new ArrayList<OperateErrorInfo>();
        Set errorQtyBillIds = (Set)this.validateContext.computeIfAbsent("failQtyBills", a -> new HashSet());
        String billno = this.data.getBillno();
        List<ContractEntryInfo> contractEntryInfo = this.data.getContractEntryInfo();
        for (ContractEntryInfo conEntry : contractEntryInfo) {
            int seq = conEntry.getSeq();
            BigDecimal baseQty = conEntry.getBaseQty();
            BigDecimal baseOrderQty = conEntry.getBaseOrderQty();
            List<PerformBillEntryInfo> performBillInfo = conEntry.getPerformBillInfo();
            performBillInfo.sort(Comparator.comparing(a -> a.getBaseQty().compareTo(BigDecimal.ZERO)).thenComparingLong(b -> b.getOrderId()));
            for (PerformBillEntryInfo entryInfo : performBillInfo) {
                Long orderId = entryInfo.getOrderId();
                Long orderEntryId = entryInfo.getOrderEntryId();
                BigDecimal entryInfoBaseQty = entryInfo.getBaseQty();
                int entryInfoSeq = entryInfo.getSeq();
                BigDecimal add = entryInfoBaseQty.add(baseOrderQty);
                if (add.compareTo(baseQty) > 0 || add.compareTo(BigDecimal.ZERO) < 0) {
                    errorQtyBillIds.add(orderId);
                    String message = ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$d\u884c\uff0c\u5408\u540c%2$s\u7684\u7269\u6599\u660e\u7ec6\u7b2c%3$d\u884c\uff0c\u5df2\u8ba2\u8d27\u6570\u91cf\u8d85\u989d \u3002", (String)"PerformDataValidator_1", (String)"scmc-conm-business", (Object[])new Object[0]);
                    String msg = String.format(message, entryInfoSeq, billno, seq);
                    this.addErrorMessage(orderId, orderEntryId, entryInfoSeq, msg, "qty");
                    continue;
                }
                baseOrderQty = add;
                conEntry.setBaseOrderQty(baseOrderQty);
            }
        }
        return result;
    }

    @Override
    public List<OperateErrorInfo> amountCheck() {
        ArrayList<OperateErrorInfo> result = new ArrayList<OperateErrorInfo>();
        HashMap errorAmountMap = (HashMap)this.validateContext.computeIfAbsent("failAmountBills", a -> new HashMap());
        Set errorAmountBillIds = errorAmountMap.computeIfAbsent(this.data.getContractId(), b -> new HashSet());
        String billno = this.data.getBillno();
        BigDecimal orderAllAmount = this.data.getOrderAllAmount();
        BigDecimal totalAmountAndTax = this.data.getTotalAllAmount();
        List<ContractEntryInfo> contractEntryInfo = this.data.getContractEntryInfo();
        List performBillEntryInfos = contractEntryInfo.stream().flatMap(a -> a.getPerformBillInfo().stream()).collect(Collectors.toList());
        performBillEntryInfos.sort(Comparator.comparing(a -> a.getAmountAndTax().compareTo(BigDecimal.ZERO)).thenComparingLong(b -> b.getOrderId()));
        for (PerformBillEntryInfo entryInfo : performBillEntryInfos) {
            Long orderId = entryInfo.getOrderId();
            Long orderEntryId = entryInfo.getOrderEntryId();
            BigDecimal amountAndTax = entryInfo.getAmountAndTax();
            BigDecimal add = amountAndTax.add(orderAllAmount);
            if (add.compareTo(totalAmountAndTax) > 0 || add.compareTo(BigDecimal.ZERO) < 0) {
                if (!errorAmountBillIds.add(orderId)) continue;
                String message = ResManager.loadKDString((String)"\u5408\u540c\u201c%s\u201d\u7684\u5df2\u8ba2\u8d27\u91d1\u989d\u5df2\u8d85\u989d\u3002", (String)"PerformDataValidator_3", (String)"scmc-conm-business", (Object[])new Object[0]);
                String msg = String.format(message, billno);
                this.addErrorMessage(orderId, orderEntryId, 0, msg, "amount");
                continue;
            }
            orderAllAmount = add;
            this.data.setOrderAllAmount(orderAllAmount);
        }
        return result;
    }

    @Override
    public List<OperateErrorInfo> priceCheck() {
        ArrayList<OperateErrorInfo> result = new ArrayList<OperateErrorInfo>();
        String billno = this.data.getBillno();
        List<ContractEntryInfo> contractEntryInfo = this.data.getContractEntryInfo();
        for (ContractEntryInfo entryInfo : contractEntryInfo) {
            BigDecimal priceAndTax = entryInfo.getPriceAndTax();
            int conSeq = entryInfo.getSeq();
            List<PerformBillEntryInfo> performBillInfo = entryInfo.getPerformBillInfo();
            for (PerformBillEntryInfo abstractEntryInfo : performBillInfo) {
                BigDecimal price = abstractEntryInfo.getPriceAndTax();
                Long orderId = abstractEntryInfo.getOrderId();
                Long orderEntryId = abstractEntryInfo.getOrderEntryId();
                int seq = abstractEntryInfo.getSeq();
                if (price.compareTo(priceAndTax) == 0) continue;
                String message = ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$d\u884c\u201c\u542b\u7a0e\u5355\u4ef7\u201d\uff0c\u4e0e\u5408\u540c\u201c%2$s\u201d\u7684\u7269\u6599\u660e\u7ec6\u7b2c%3$d\u884c\u7684\u201c\u542b\u7a0e\u5355\u4ef7\u201d\u4e0d\u7b26\u3002", (String)"PerformDataValidator_4", (String)"scmc-conm-business", (Object[])new Object[0]);
                String msg = String.format(message, seq, billno, conSeq);
                this.addErrorMessage(orderId, orderEntryId, seq, msg, "price");
            }
        }
        return result;
    }

    public void addErrorMessage(Long Id, Long entryId, int seq, String msg, String field) {
        OperateErrorInfo errorInfo = new OperateErrorInfo("", ErrorLevel.Error, (Object)Id, (Object)entryId);
        errorInfo.setMessage(msg);
        errorInfo.setRowIndex(seq);
        errorInfo.setFieldKey(field);
        if (this.errorInfos != null) {
            this.errorInfos.add(errorInfo);
        }
    }
}

