/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.business.service.writeback;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.conm.business.service.writeback.IExecutor;
import kd.scmc.conm.business.service.writeback.WriteLogService;
import kd.scmc.conm.business.service.writeback.pojo.TrackData;
import kd.scmc.conm.business.service.writeback.service.IWriteService;

public abstract class AbstractWriteServiceExecutor
implements IExecutor {
    private static WriteLogService log4Con = WriteLogService.getLog();
    private static int capacity = 100;
    private List<IWriteService> writers = new ArrayList<IWriteService>();

    public abstract List<IWriteService> register();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(List<Map<String, Object>> list) {
        log4Con.debug(SerializationUtils.toJsonString(list));
        try {
            List<IWriteService> register = this.register();
            if (register != null) {
                this.writers.addAll(register);
            }
            List<TrackData> trackNodes = this.search(list);
            Map<String, List<Map<Long, List<TrackData>>>> batch = this.doBatch(trackNodes);
            try (TXHandle tx = TX.required();){
                try {
                    for (Map.Entry<String, List<Map<Long, List<TrackData>>>> entry : batch.entrySet()) {
                        this.update(entry.getKey(), entry.getValue());
                    }
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw e;
                }
            }
        }
        finally {
            log4Con.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(String entity, List<Map<Long, List<TrackData>>> mapList) {
        log4Con.debug("update :entity=" + entity + ",mapList=" + SerializationUtils.toJsonString(mapList));
        for (Map<Long, List<TrackData>> batchData : mapList) {
            Set<Long> ids = batchData.keySet();
            if (ids.size() <= 0) continue;
            List<DLock> locks = this.lock(ids);
            try {
                DynamicObject[] billObj = BusinessDataServiceHelper.load((String)entity, (String)this.getSelectFields(), (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
                Map<Long, DynamicObject> curBatchBills = Arrays.stream(billObj).collect(Collectors.toMap(data -> data.getLong("id"), data -> data));
                for (Map.Entry<Long, DynamicObject> billEntry : curBatchBills.entrySet()) {
                    Long id = billEntry.getKey();
                    DynamicObject bill = billEntry.getValue();
                    List<TrackData> trackData = batchData.get(id);
                    if (bill == null || trackData == null || trackData.size() <= 0) continue;
                    for (IWriteService writer : this.writers) {
                        List<TrackData> args = trackData.stream().filter(data -> writer.match((Map)data.getData())).collect(Collectors.toList());
                        if (args.size() <= 0) continue;
                        log4Con.debug(writer.getClass().getSimpleName() + ":billNo:" + bill.getString("billno") + ", match :" + SerializationUtils.toJsonString(args));
                        writer.update(bill, args);
                    }
                }
                DynamicObject[] afterBills = curBatchBills.values().toArray(new DynamicObject[curBatchBills.size()]);
                SaveServiceHelper.update((DynamicObject[])afterBills);
            }
            finally {
                AbstractWriteServiceExecutor.unLock(locks);
            }
        }
    }

    private List<TrackData> search(List<Map<String, Object>> list) {
        log4Con.debug("before search :" + SerializationUtils.toJsonString(list));
        ArrayList<TrackData> trackNodes = new ArrayList<TrackData>();
        for (IWriteService writer : this.writers) {
            ArrayList<TrackData> nodes = new ArrayList<TrackData>();
            for (Map<String, Object> data : list) {
                TrackData node;
                if (!writer.match(data) || (node = writer.track(data)) == null || !node.isNotEmpty()) continue;
                Object nodeData = node.getData();
                if (nodeData == null) {
                    node.setData(data);
                }
                nodes.add(node);
            }
            if (nodes.size() <= 0) continue;
            trackNodes.addAll(this.track(nodes));
        }
        log4Con.debug("search :" + SerializationUtils.toJsonString(trackNodes));
        return trackNodes;
    }

    private String getSelectFields() {
        ArrayList<String> fields = new ArrayList<String>();
        for (IWriteService writer : this.writers) {
            writer.prepareProperty(fields);
        }
        StringJoiner joiner = new StringJoiner(",");
        List fieldsDistinct = fields.stream().distinct().collect(Collectors.toList());
        for (String field : fieldsDistinct) {
            joiner.add(field);
        }
        return joiner.toString();
    }

    private Map<String, List<Map<Long, List<TrackData>>>> doBatch(List<TrackData> trackNodes) {
        log4Con.debug("before doBatch :" + SerializationUtils.toJsonString(trackNodes));
        HashMap<String, List<Map<Long, List<TrackData>>>> resultMap = new HashMap<String, List<Map<Long, List<TrackData>>>>();
        Map<String, List<TrackData>> entityMap = trackNodes.stream().collect(Collectors.groupingBy(TrackData::getCurEntity));
        HashMap<String, Map<Long, List<TrackData>>> dataMap = new HashMap<String, Map<Long, List<TrackData>>>();
        for (Map.Entry<String, List<TrackData>> entry : entityMap.entrySet()) {
            String key = entry.getKey();
            List<TrackData> dataList = entry.getValue();
            Map<Long, List<TrackData>> batchNode = dataList.stream().filter(data -> data.getCurId() != null).collect(Collectors.groupingBy(TrackData::getCurId));
            dataMap.put(key, batchNode);
        }
        int allEntityNum = 0;
        int allBatchTime = 0;
        int allSize = 0;
        for (Map.Entry entryData : dataMap.entrySet()) {
            String entity = (String)entryData.getKey();
            Map batchNode = (Map)entryData.getValue();
            int size = batchNode.size();
            int batchTime = size % capacity == 0 ? size / capacity : size / capacity + 1;
            ArrayList batchData = new ArrayList(batchTime);
            Iterator iterator = batchNode.entrySet().iterator();
            for (int i = 0; i < batchTime; ++i) {
                HashMap trackMap = new HashMap();
                for (int j = 1; iterator.hasNext() && j <= capacity; ++j) {
                    Map.Entry entry = iterator.next();
                    trackMap.put(entry.getKey(), entry.getValue());
                }
                batchData.add(trackMap);
            }
            resultMap.put(entity, batchData);
            allSize += size;
            ++allEntityNum;
            allBatchTime += batchTime;
        }
        log4Con.debug("batch :[ allSize:" + allSize + ",entityNum:" + allEntityNum + ",batchTimes:" + allBatchTime + " ]");
        return resultMap;
    }

    public List<TrackData> track(List<TrackData> list) {
        ArrayList<TrackData> correctList = new ArrayList<TrackData>();
        if (list != null && list.size() > 0) {
            Map<String, List<TrackData>> srcEntityMap = list.stream().collect(Collectors.groupingBy(TrackData::getCurEntity));
            for (Map.Entry<String, List<TrackData>> node : srcEntityMap.entrySet()) {
                String curEntity = node.getKey();
                List<TrackData> curNodes = node.getValue();
                if (!StringUtils.isNotEmpty((String)curEntity)) continue;
                if ("sm_salorder".equals(curEntity) || "pm_purorderbill".equals(curEntity)) {
                    correctList.addAll(this.trackUp(curNodes, curEntity));
                    continue;
                }
                if (!"conm_purcontract".equals(curEntity) && !"conm_salcontract".equals(curEntity)) continue;
                correctList.addAll(curNodes);
            }
        }
        return correctList;
    }

    public List<TrackData> trackUp(List<TrackData> infos, String entity) {
        ArrayList<TrackData> upNodeInfos = new ArrayList<TrackData>();
        List orderBillInfo = infos.stream().filter(info -> entity.equalsIgnoreCase(info.getCurEntity())).collect(Collectors.toList());
        if (orderBillInfo.size() > 0) {
            Set entryIds = orderBillInfo.stream().filter(info -> info.getCurEntryId() != null && info.getCurEntryId() != 0L).map(TrackData::getCurEntryId).collect(Collectors.toSet());
            HashMap<Long, DynamicObject> orderEntryMap = new HashMap<Long, DynamicObject>();
            DynamicObjectCollection orderBillEntrys = QueryServiceHelper.query((String)entity, (String)"billentry.id,billentry.conbillentity,billentry.conbillid,billentry.conbillentryid,billentry.srcbillentity,billentry.srcbillid,billentry.srcbillentryid", (QFilter[])new QFilter[]{new QFilter("billentry.id", "in", entryIds)});
            for (DynamicObject entry : orderBillEntrys) {
                orderEntryMap.put(entry.getLong("billentry.id"), entry);
            }
            Set ids = orderBillInfo.stream().filter(info -> info.getCurId() != null && info.getCurId() != 0L).map(TrackData::getCurId).collect(Collectors.toSet());
            HashMap<Long, DynamicObject> orderFirstEntryMap = new HashMap<Long, DynamicObject>();
            DynamicObjectCollection orderFirstEntrys = QueryServiceHelper.query((String)entity, (String)"id,billentry.id,billentry.conbillentity,billentry.conbillid,billentry.conbillentryid,billentry.srcbillentity,billentry.srcbillid,billentry.srcbillentryid", (QFilter[])new QFilter[]{new QFilter("id", "in", ids), new QFilter("billentry.seq", "=", (Object)1)});
            for (DynamicObject firstEntry : orderFirstEntrys) {
                orderFirstEntryMap.put(firstEntry.getLong("id"), firstEntry);
            }
            for (TrackData orderInfo : orderBillInfo) {
                TrackData trackNode;
                Long orderEntryId = orderInfo.getCurEntryId();
                DynamicObject orderEntry = (DynamicObject)orderEntryMap.get(orderEntryId);
                if (orderEntry != null) {
                    TrackData trackNode2 = this.trackUp(orderInfo, orderEntry, true);
                    if (trackNode2 == null) continue;
                    upNodeInfos.add(orderInfo);
                    continue;
                }
                Long curId = orderInfo.getCurId();
                DynamicObject orderFirstEntry = (DynamicObject)orderFirstEntryMap.get(curId);
                if (orderFirstEntry == null || (trackNode = this.trackUp(orderInfo, orderFirstEntry, false)) == null) continue;
                upNodeInfos.add(orderInfo);
            }
        }
        return upNodeInfos;
    }

    private TrackData trackUp(TrackData orderInfo, DynamicObject entry, boolean isTrackRow) {
        String conbillentity = entry.getString("billentry.conbillentity");
        Long conbillid = entry.getLong("billentry.conbillid");
        Long conbillentryid = entry.getLong("billentry.conbillentryid");
        if (StringUtils.isNotEmpty((String)conbillentity) && conbillid != null && Long.compare(conbillid, 0L) != 0) {
            orderInfo.setCurEntity(conbillentity);
            orderInfo.setCurId(conbillid);
            if (isTrackRow) {
                orderInfo.setCurEntryId(conbillentryid);
            } else {
                orderInfo.setCurEntryId(null);
            }
            return orderInfo;
        }
        String srcbillentity = entry.getString("billentry.srcbillentity");
        Long srcbillid = entry.getLong("billentry.srcbillid");
        Long srcbillentryid = entry.getLong("billentry.srcbillentryid");
        if (StringUtils.isNotEmpty((String)srcbillentity) && ("conm_purcontract".equalsIgnoreCase(srcbillentity) || "conm_salcontract".equalsIgnoreCase(srcbillentity)) && srcbillid != null && Long.compare(srcbillid, 0L) != 0) {
            orderInfo.setCurEntity(srcbillentity);
            orderInfo.setCurId(srcbillid);
            if (isTrackRow) {
                orderInfo.setCurEntryId(srcbillentryid);
            } else {
                orderInfo.setCurEntryId(null);
            }
            return orderInfo;
        }
        return null;
    }

    public List<DLock> lock(Set<Long> ids) {
        Boolean tryLock;
        ArrayList<DLock> locks = new ArrayList<DLock>();
        if (ids != null && ids.size() > 0 && !(tryLock = this.createLock(ids, locks)).booleanValue()) {
            AbstractWriteServiceExecutor.unLock(locks);
            throw new KDBizException(ResManager.loadKDString((String)"\u5e76\u53d1\u51b2\u7a81\u3002\u53cd\u5199\u201c\u5408\u540c\u201d\u7533\u8bf7\u4e92\u65a5\u9501\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"AbstractWriteService_0", (String)"scmc-conm-business", (Object[])new Object[0]));
        }
        return locks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Boolean createLock(Set<Long> ids, List<DLock> locks) {
        boolean isSuccess = true;
        Iterator<Long> iterator = ids.iterator();
        while (iterator.hasNext()) {
            Long contId = iterator.next();
            DLock lock = DLock.createReentrant((String)String.format("scmc/conm/wb/%s", contId));
            Class<AbstractWriteServiceExecutor> clazz = AbstractWriteServiceExecutor.class;
            // MONITORENTER : kd.scmc.conm.business.service.writeback.AbstractWriteServiceExecutor.class
            if (!lock.tryLock(1000L)) {
                isSuccess = false;
                // MONITOREXIT : clazz
                return isSuccess;
            }
            locks.add(lock);
            // MONITOREXIT : clazz
        }
        return isSuccess;
    }

    public static void unLock(List<DLock> locks) {
        for (DLock item : locks) {
            item.unlock();
        }
    }
}

