/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.business.service.writeback;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msbd.business.service.TrackLogService;

public class WriteLogService {
    private static ThreadLocal<Map<String, List<String>>> context = new ThreadLocal();
    private Log logger = LogFactory.getLog(WriteLogService.class);
    private TrackLogService trackLogService = new TrackLogService(WriteLogService.class, "conm");
    private static String[] levels = new String[]{"DEBUG", "INFO", "WARN", "ERROR"};

    public static WriteLogService getLog() {
        return new WriteLogService();
    }

    public void debug(String log) {
        this.doLog(log, "DEBUG");
    }

    public void info(String log) {
        this.doLog(log, "INFO");
    }

    public void warn(String log) {
        this.doLog(log, "WARN");
    }

    public void error(String log) {
        this.doLog(log, "ERROR");
    }

    public void doLog(String log, String level) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-mm-dd HH:mm:ss SSS");
        String date = format.format(new Date());
        Map<String, List<String>> logMap = context.get();
        if (logMap == null) {
            logMap = new HashMap<String, List<String>>();
            context.set(logMap);
        }
        List logs = logMap.computeIfAbsent(level, a -> new ArrayList());
        logs.add("[" + level + "]" + date + ": " + log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Map<String, List<String>> logMap = context.get();
        if (logMap != null) {
            try {
                block15: for (String level : levels) {
                    List<String> logs = logMap.get(level);
                    if (logs == null || logs.size() <= 0) continue;
                    Collections.sort(logs);
                    String log = SerializationUtils.toJsonString(logs);
                    switch (level) {
                        case "DEBUG": {
                            this.logger.info(log);
                            continue block15;
                        }
                        case "INFO": {
                            this.trackLogService.info(log);
                            this.logger.info(log);
                            continue block15;
                        }
                        case "WARN": {
                            this.trackLogService.warn(log);
                            this.logger.warn(log);
                            continue block15;
                        }
                        case "ERROR": {
                            this.trackLogService.error(log);
                            this.logger.error(log);
                        }
                    }
                }
            }
            finally {
                context.remove();
            }
        }
    }
}

