/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.business.service.writeback.service.pur;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.scmc.conm.business.service.writeback.pojo.TrackData;
import kd.scmc.conm.business.service.writeback.service.pur.AbstractPurWriteService;

public class PurPayHeadWriteService
extends AbstractPurWriteService {
    @Override
    public boolean match(Map<String, Object> data) {
        String settleRelation = (String)data.get("settleRelation");
        String bizType = (String)data.get("bizType");
        String accessType = (String)data.get("accessType");
        if ("AP".equals(accessType) && "appaysettle".equals(settleRelation) && !"202".equals(bizType)) {
            return true;
        }
        if ("AP".equals(accessType) && "aprecsettle".equals(settleRelation) && !"103".equals(bizType)) {
            return true;
        }
        return "AP".equals(accessType) && ("aparsettle".equals(settleRelation) || "arapsettle".equals(settleRelation) || "paytrans".equals(settleRelation) || "liqsettle".equals(settleRelation));
    }

    @Override
    public void update(DynamicObject bill, List<TrackData> nodes) {
        DynamicObjectCollection billentry = bill.getDynamicObjectCollection("billentry");
        Map<Object, DynamicObject> entryMap = billentry.stream().collect(Collectors.toMap(DataEntityBase::getPkValue, v -> v));
        for (TrackData node : nodes) {
            Long settleOrgId;
            DynamicObject entry;
            Long curEntryId = node.getCurEntryId();
            Map leafData = (Map)node.getData();
            Long arSettleOrgID = (Long)leafData.get("settleOrgID");
            BigDecimal settleAmount = (BigDecimal)leafData.get("amount");
            String accessType = (String)leafData.get("accessType");
            BigDecimal paidallamount = bill.getBigDecimal("paidallamount");
            if (settleAmount == null) continue;
            BigDecimal amount = paidallamount.add(settleAmount);
            if ("PAY".equals(accessType)) {
                bill.set("paidallamount", (Object)amount);
                trackLog.info("paidallamount:{ billno:" + bill.getString("billno") + " ,oldValue:" + paidallamount.toPlainString() + ",newValue:" + amount.toPlainString() + "}");
                continue;
            }
            if (curEntryId == null || curEntryId == 0L || (entry = entryMap.get(curEntryId)) == null || arSettleOrgID.compareTo(settleOrgId = Long.valueOf(entry.getLong("entrysettleorg.id"))) != 0) continue;
            bill.set("paidallamount", (Object)amount);
            trackLog.info("paidallamount:{ billno:" + bill.getString("billno") + ",oldValue:" + paidallamount.toPlainString() + ",newValue:" + amount.toPlainString() + "}");
        }
    }
}

