/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.business.service.writeback.service.pur;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.util.StringUtils;
import kd.scmc.conm.business.service.writeback.pojo.TrackData;
import kd.scmc.conm.business.service.writeback.service.pur.AbstractPurWriteService;

public class PurPrePayHeadWriteService
extends AbstractPurWriteService {
    @Override
    public boolean match(Map<String, Object> data) {
        String settleRelation = (String)data.get("settleRelation");
        String bizType = (String)data.get("bizType");
        Long payMainBillID = (Long)data.get("payMainBillID");
        String payMainBillEntity = (String)data.get("payMainBillEntity");
        String srcBillEntity = (String)data.get("srcBillEntity");
        String mainBillEntity = (String)data.get("mainBillEntity");
        String accessType = (String)data.get("accessType");
        if ("AP".equals(accessType) && "appaysettle".equals(settleRelation) && "202".equals(bizType) && (payMainBillID == null || payMainBillID == 0L) && ("conm_purcontract".equals(mainBillEntity) || "pm_purorderbill".equals(mainBillEntity))) {
            return true;
        }
        if ("AP".equals(accessType) && "aprecsettle".equals(settleRelation) && "103".equals(bizType) && ("conm_purcontract".equals(mainBillEntity) || "pm_purorderbill".equals(mainBillEntity))) {
            return true;
        }
        if ("AP".equals(accessType) && "payrecsettle".equals(settleRelation) && "202".equals(bizType) && "pm_purorderbill".equals(payMainBillEntity)) {
            return true;
        }
        if ("AP".equals(accessType) && "payself".equals(settleRelation) && "202".equals(bizType) && "pm_purorderbill".equals(payMainBillEntity)) {
            return true;
        }
        return !(!"AP".equals(accessType) && !"PAY".equals(accessType) || !StringUtils.isEmpty((String)settleRelation) || !"conm_purcontract".equals(srcBillEntity) && !"pm_purorderbill".equals(srcBillEntity) || !"pm_purorderbill".equals(mainBillEntity));
    }

    @Override
    public void update(DynamicObject bill, List<TrackData> nodes) {
        for (TrackData node : nodes) {
            BigDecimal paidpreallamount = bill.getBigDecimal("paidpreallamount");
            BigDecimal paidallamount = bill.getBigDecimal("paidallamount");
            Map leafData = (Map)node.getData();
            Long settleOrg = this.getSettleOrgId(bill, node);
            Long settleOrgID = (Long)leafData.get("settleOrgID");
            BigDecimal settleAmount = (BigDecimal)leafData.get("amount");
            String accessType = (String)leafData.get("accessType");
            if (settleAmount == null || !"PAY".equals(accessType) && !this.directWb(leafData) && (settleOrgID == null || settleOrg == null || settleOrgID.compareTo(settleOrg) != 0)) continue;
            BigDecimal newPaidPreAllAmount = paidpreallamount.add(settleAmount);
            bill.set("paidpreallamount", (Object)newPaidPreAllAmount);
            trackLog.info("paidpreallamount:{ billno:" + bill.getString("billno") + ",oldValue:" + paidpreallamount.toPlainString() + ",newValue:" + newPaidPreAllAmount.toPlainString() + "}");
            BigDecimal newPaidAllAmount = paidallamount.add(settleAmount);
            bill.set("paidallamount", (Object)newPaidAllAmount);
            trackLog.info("paidallamount:{ billno:" + bill.getString("billno") + ",oldValue:" + paidallamount.toPlainString() + ",newValue:" + newPaidAllAmount.toPlainString() + "}");
        }
    }

    private Long getSettleOrgId(DynamicObject contract, TrackData node) {
        Long settleOrg = null;
        Long entryId = node.getCurEntryId();
        Map leafData = (Map)node.getData();
        DynamicObjectCollection billentry = contract.getDynamicObjectCollection("billentry");
        if (billentry.size() > 0) {
            Map<Object, DynamicObject> entryMap = billentry.stream().collect(Collectors.toMap(DataEntityBase::getPkValue, v -> v));
            String settleRelation = (String)leafData.get("settleRelation");
            DynamicObject entry = entryMap.get(entryId);
            if (entry != null) {
                settleOrg = entry.getLong("entrysettleorg.id");
            } else if ("payrecsettle".equals(settleRelation) || "payself".equals(settleRelation)) {
                settleOrg = ((DynamicObject)billentry.get(0)).getLong("entrysettleorg.id");
            }
        }
        return settleOrg;
    }

    public boolean directWb(Map<String, Object> data) {
        String settleRelation = (String)data.get("settleRelation");
        String srcBillEntity = (String)data.get("srcBillEntity");
        String mainBillEntity = (String)data.get("mainBillEntity");
        String accessType = (String)data.get("accessType");
        return "AP".equals(accessType) && StringUtils.isEmpty((String)settleRelation) && ("conm_purcontract".equals(srcBillEntity) || "pm_purorderbill".equals(srcBillEntity)) && "pm_purorderbill".equals(mainBillEntity);
    }
}

