/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.business.service.writeback.service.sal;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.scmc.conm.business.service.writeback.pojo.TrackData;
import kd.scmc.conm.business.service.writeback.service.sal.AbstractSalWriteService;

public class SalPreRecActualWriteService
extends AbstractSalWriteService {
    @Override
    public boolean match(Map<String, Object> data) {
        String bizType = (String)data.get("bizType");
        String recMainBillEntity = (String)data.get("recMainBillEntity");
        boolean confirmLogo = data.get("confirmLogo") != null ? (Boolean)data.get("confirmLogo") : false;
        Long recMainBillID = (Long)data.get("recMainBillID");
        String accessType = (String)data.get("accessType");
        return "REC".equals(accessType) && "101".equals(bizType) && "conm_salcontract".equals(recMainBillEntity) && !confirmLogo && recMainBillID != null && recMainBillID != 0L;
    }

    @Override
    public void update(DynamicObject bill, List<TrackData> nodes) {
        DynamicObjectCollection payEntry = bill.getDynamicObjectCollection("payentry");
        Map<Object, DynamicObject> entryMap = payEntry.stream().collect(Collectors.toMap(DataEntityBase::getPkValue, v -> v));
        for (TrackData node : nodes) {
            Long curEntryId = node.getCurEntryId();
            Map leafData = (Map)node.getData();
            BigDecimal receiptallamount = bill.getBigDecimal("receiptallamount");
            BigDecimal prereceiptallamount = bill.getBigDecimal("prereceiptallamount");
            BigDecimal settleAmount = (BigDecimal)leafData.get("amount");
            if (settleAmount == null) continue;
            BigDecimal newReceiptAllAmount = receiptallamount.add(settleAmount);
            BigDecimal newPreReceiptAllAmount = prereceiptallamount.add(settleAmount);
            DynamicObject entry = entryMap.get(curEntryId);
            if (curEntryId != null && curEntryId != 0L && entry != null) {
                BigDecimal paidamount = entry.getBigDecimal("paidamount");
                String accessType = (String)leafData.get("accessType");
                if (settleAmount == null || !"REC".equals(accessType)) continue;
                BigDecimal newPaidAmount = paidamount.add(settleAmount);
                entry.set("paidamount", (Object)newPaidAmount);
                trackLog.info("paidamount:{ billno:" + bill.getString("billno") + ",seq:" + entry.getString("seq") + ", oldValue:" + paidamount.toPlainString() + ",newValue:" + newPaidAmount.toPlainString() + "}");
                bill.set("receiptallamount", (Object)newReceiptAllAmount);
                trackLog.info("receiptallamount:{ billno:" + bill.getString("billno") + ", oldValue:" + receiptallamount.toPlainString() + ",newValue:" + newReceiptAllAmount.toPlainString() + "}");
                bill.set("prereceiptallamount", (Object)newPreReceiptAllAmount);
                trackLog.info("prereceiptallamount:{ billno:" + bill.getString("billno") + ", oldValue:" + prereceiptallamount.toPlainString() + ",newValue:" + newPreReceiptAllAmount.toPlainString() + "}");
                continue;
            }
            bill.set("receiptallamount", (Object)newReceiptAllAmount);
            trackLog.info("receiptallamount:{ billno:" + bill.getString("billno") + ", oldValue:" + receiptallamount.toPlainString() + ",newValue:" + newReceiptAllAmount.toPlainString() + "}");
            bill.set("prereceiptallamount", (Object)newPreReceiptAllAmount);
            trackLog.info("prereceiptallamount:{ billno:" + bill.getString("billno") + ", oldValue:" + prereceiptallamount.toPlainString() + ",newValue:" + newPreReceiptAllAmount.toPlainString() + "}");
        }
    }
}

