/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.business.service.writeback.service.sal;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.scmc.conm.business.service.writeback.pojo.TrackData;
import kd.scmc.conm.business.service.writeback.service.sal.AbstractSalWriteService;

public class SalPreRecHeadWriteService
extends AbstractSalWriteService {
    @Override
    public boolean match(Map<String, Object> data) {
        String settleRelation = (String)data.get("settleRelation");
        String arMainBillEntity = (String)data.get("arMainBillEntity");
        Long arMainBillID = (Long)data.get("arMainBillID");
        String bizType = (String)data.get("bizType");
        Long recMainBillID = (Long)data.get("recMainBillID");
        String recMainBillEntity = (String)data.get("recMainBillEntity");
        String accessType = (String)data.get("accessType");
        if ("AR".equals(accessType) && "recsettle".equals(settleRelation) && "101".equals(bizType) && (recMainBillID == null || recMainBillID == 0L) && ("conm_salcontract".equals(arMainBillEntity) || "sm_salorder".equals(arMainBillEntity)) && arMainBillID != null && arMainBillID != 0L) {
            return true;
        }
        if ("AR".equals(accessType) && "arpaysettle".equals(settleRelation) && "204".equals(bizType) && ("conm_salcontract".equals(arMainBillEntity) || "sm_salorder".equals(arMainBillEntity)) && arMainBillID != null && arMainBillID != 0L) {
            return true;
        }
        if ("AR".equals(accessType) && "recpaysettle".equals(settleRelation) && "101".equals(bizType) && "sm_salorder".equals(recMainBillEntity) && recMainBillID != null && recMainBillID != 0L) {
            return true;
        }
        if ("AR".equals(accessType) && "recself".equals(settleRelation) && "101".equals(bizType) && "sm_salorder".equals(arMainBillEntity) && arMainBillID != null && arMainBillID != 0L && (recMainBillID == null || recMainBillID == 0L)) {
            return true;
        }
        if ("AR".equals(accessType) && "recclearing".equals(settleRelation) && "101".equals(bizType) && "sm_salorder".equals(recMainBillEntity) && recMainBillID != null && recMainBillID != 0L) {
            return true;
        }
        return "REC".equals(accessType) && "101".equals(bizType) && "sm_salorder".equals(recMainBillEntity) && recMainBillID != null && recMainBillID != 0L;
    }

    @Override
    public void update(DynamicObject bill, List<TrackData> nodes) {
        for (TrackData node : nodes) {
            BigDecimal prereceiptallamount = bill.getBigDecimal("prereceiptallamount");
            BigDecimal receiptallamount = bill.getBigDecimal("receiptallamount");
            Map leafData = (Map)node.getData();
            Long settleOrg = this.getSettleOrgId(bill, node);
            Long settleOrgID = (Long)leafData.get("settleOrgID");
            BigDecimal settleAmount = (BigDecimal)leafData.get("amount");
            String accessType = (String)leafData.get("accessType");
            if (settleAmount == null || !"REC".equals(accessType) && (settleOrgID == null || settleOrg == null || settleOrgID.compareTo(settleOrg) != 0)) continue;
            BigDecimal newPreReceiptAllAmount = prereceiptallamount.add(settleAmount);
            bill.set("prereceiptallamount", (Object)newPreReceiptAllAmount);
            trackLog.info("prereceiptallamount:{ billno:" + bill.getString("billno") + ",oldValue:" + prereceiptallamount.toPlainString() + ",newValue:" + newPreReceiptAllAmount.toPlainString() + "}");
            BigDecimal newPaidAllAmount = receiptallamount.add(settleAmount);
            bill.set("receiptallamount", (Object)newPaidAllAmount);
            trackLog.info("receiptallamount:{ billno:" + bill.getString("billno") + ",oldValue:" + receiptallamount.toPlainString() + ",newValue:" + newPaidAllAmount.toPlainString() + "}");
        }
    }

    private Long getSettleOrgId(DynamicObject contract, TrackData node) {
        Long settleOrg = null;
        Long entryId = node.getCurEntryId();
        Map leafData = (Map)node.getData();
        DynamicObjectCollection billentry = contract.getDynamicObjectCollection("billentry");
        if (billentry.size() > 0) {
            Map<Object, DynamicObject> entryMap = billentry.stream().collect(Collectors.toMap(DataEntityBase::getPkValue, v -> v));
            String settleRelation = (String)leafData.get("settleRelation");
            DynamicObject entry = entryMap.get(entryId);
            if (entry != null) {
                settleOrg = entry.getLong("entrysettleorg.id");
            } else if (!"recsettle".equals(settleRelation) && !"arpaysettle".equals(settleRelation)) {
                settleOrg = ((DynamicObject)billentry.get(0)).getLong("entrysettleorg.id");
            }
        }
        return settleOrg;
    }
}

