/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.report;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.MapFunction;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.conm.report.functions.ConmAmountCalcFunction;
import kd.scmc.conm.report.functions.ConmExecuteCalcFunction;
import kd.scmc.conm.report.helper.PurContractRptHelper;
import kd.scmc.conm.report.helper.PushConditionRptHelper;

public abstract class AbstractConmRptQuery
extends AbstractReportListDataPlugin {
    private static final Log log = LogFactory.getLog(AbstractConmRptQuery.class);

    protected abstract String getConmEntity();

    protected abstract String getConmSelectField();

    protected abstract String getConmSelectWbField();

    protected abstract String getOrderEntity();

    protected abstract String getOrderSelectField();

    protected abstract String getOrderSelectWbField();

    protected abstract String getShowField();

    protected abstract String[] calcQtyFields();

    protected abstract String[] calcOriginQtyFields();

    protected abstract String[] calcAmountFields();

    protected abstract String[] calcCurAmountFields();

    public DataSet query(ReportQueryParam reportQueryParam, Object o) {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        List<QFilter> filters = PurContractRptHelper.getFilters(filterInfo);
        long startTime = System.currentTimeMillis();
        DataSet dataSetConm = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)this.getConmEntity(), (String)(this.getConmSelectField() + "," + this.getConmSelectWbField()), (QFilter[])filters.toArray(new QFilter[filters.size()]), (String)"biztime desc,billno desc");
        DataSet dataSetUnitImput = dataSetConm.copy().filter("baseqty = 0");
        DataSet muConv = PurContractRptHelper.getMUConv(dataSetUnitImput);
        dataSetConm = dataSetConm.join(muConv, JoinType.LEFT).on("id", "id").on("entryId", "entryId").select(dataSetConm.getRowMeta().getFieldNames(), new String[]{"numerator", "denominator"}).finish();
        QFilter billstatus = new QFilter("billstatus", "=", (Object)"C");
        QFilter isVirtualBill = new QFilter("isvirtualbill", "=", (Object)Boolean.FALSE);
        QFilter pushCondtionFilter = PushConditionRptHelper.pushConditon(dataSetConm, new String[]{"id", "entryId"}, new String[]{"billentry.conbillid", "billentry.conbillentryid"}, true, dataSet -> dataSet);
        DataSet dataSetOrder = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)this.getOrderEntity(), (String)(this.getOrderSelectField() + "," + this.getOrderSelectWbField()), (QFilter[])new QFilter[]{pushCondtionFilter, billstatus, isVirtualBill}, null);
        Map currencyMap = BusinessDataServiceHelper.loadFromCache((String)"bd_currency", (String)"id, priceprecision, amtprecision", (QFilter[])new QFilter[]{QFilter.of((String)"1=1", (Object[])new Object[0])});
        dataSetOrder = dataSetOrder.map((MapFunction)new ConmAmountCalcFunction(dataSetOrder.getRowMeta(), this.calcQtyFields(), this.calcAmountFields(), this.calcCurAmountFields(), currencyMap));
        dataSetOrder = dataSetConm.join(dataSetOrder, JoinType.LEFT).on("conmjoinorder", "orderjoinconm").select(dataSetConm.getRowMeta().getFieldNames(), dataSetOrder.getRowMeta().getFieldNames()).finish();
        dataSetOrder = dataSetOrder.map((MapFunction)new ConmExecuteCalcFunction(dataSetOrder.getRowMeta(), this.calcOriginQtyFields(), this.calcCurAmountFields(), this.calcQtyFields(), this.calcAmountFields(), currencyMap));
        GroupbyDataSet dataSetGroupOrder = dataSetOrder.groupBy(new String[]{"orderjoinconm"});
        for (String sumField : this.getOrderSumFields()) {
            dataSetGroupOrder = dataSetGroupOrder.sum(sumField);
        }
        DataSet dataSetSumOrder = dataSetGroupOrder.finish();
        DataSet dataSet2 = dataSetConm.join(dataSetSumOrder, JoinType.LEFT).on("conmjoinorder", "orderjoinconm").select(dataSetConm.getRowMeta().getFieldNames(), dataSetSumOrder.getRowMeta().getFieldNames()).finish();
        return dataSet2.select(this.getShowField());
    }

    protected String[] getConmGrpField() {
        List<String> grpFields = Arrays.asList("id", "entryid", "billno", "billname", "org", "type", "billstatus", "biztime", "operator", "changestatus", "freezestatus", "cancelstatus", "settlecurrency", "totalamount", "totaltaxamount", "totalallamount", "material", "materialname", "model", "unit", "baseunit", "baseqty", "qty", "price", "priceandtax", "amount");
        return grpFields.toArray(new String[0]);
    }

    private String[] getOrderSumFields() {
        String[] orderSumFields = new String[this.calcQtyFields().length + this.calcOriginQtyFields().length + this.calcAmountFields().length + this.calcCurAmountFields().length];
        System.arraycopy(this.calcQtyFields(), 0, orderSumFields, 0, this.calcQtyFields().length);
        System.arraycopy(this.calcOriginQtyFields(), 0, orderSumFields, this.calcQtyFields().length, this.calcOriginQtyFields().length);
        System.arraycopy(this.calcAmountFields(), 0, orderSumFields, this.calcQtyFields().length + this.calcOriginQtyFields().length, this.calcAmountFields().length);
        System.arraycopy(this.calcCurAmountFields(), 0, orderSumFields, this.calcQtyFields().length + this.calcOriginQtyFields().length + this.calcAmountFields().length, this.calcCurAmountFields().length);
        return orderSumFields;
    }
}

