/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.report;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.org.OrgViewServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.scmc.conm.report.helper.SalContractRptHelper;
import kd.scmc.conm.utils.CommonUtils;

public class SalContractRptPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener,
HyperLinkClickListener {
    private static final String SALCONTRACT_BIZTIME = "biztime";
    private static final String SALCONTRACT_CUSTOMER = "customer";
    private static final String SALCONTRACT_TYPE = "type";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getView().getControl("orgfield");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit type = (BasedataEdit)this.getView().getControl("typeid");
        type.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit supplier = (BasedataEdit)this.getView().getControl("customerfield");
        supplier.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit billnoid = (BasedataEdit)this.getView().getControl("billnoid");
        billnoid.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ReportList reportlistap = (ReportList)this.getView().getControl("reportlistap");
        reportlistap.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        String formId = this.getView().getFormShowParameter().getFormId();
        Long org = SalContractRptPlugin.getHasPermissionOrg(formId, OrgViewTypeEnum.IS_SALE.getViewType());
        this.getModel().setValue("orgfield", (Object)org);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Object startdate = this.getModel().getValue("startdate");
        Object enddate = this.getModel().getValue("enddate");
        if (startdate == null && enddate == null) {
            this.setdefaultDate();
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        DynamicObject org = queryParam.getFilter().getDynamicObject("orgfield");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SalContractRptPlugin_1", (String)"scmc-conm-report", (Object[])new Object[0]));
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String name = e.getProperty().getName();
        ListShowParameter formShowParameter = (ListShowParameter)e.getFormShowParameter();
        switch (name) {
            case "billnoid": {
                if (!Optional.ofNullable(this.getModel().getValue("orgfield")).isPresent()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SalContractRptPlugin_1", (String)"scmc-conm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                ArrayList qFilters = new ArrayList();
                Optional.ofNullable(this.getModel().getValue("startdate")).ifPresent(startDate -> qFilters.add(new QFilter(SALCONTRACT_BIZTIME, ">=", (Object)SalContractRptHelper.getStartOrEndDate((Date)startDate, false))));
                Optional.ofNullable(this.getModel().getValue("enddate")).ifPresent(endDate -> qFilters.add(new QFilter(SALCONTRACT_BIZTIME, "<=", (Object)SalContractRptHelper.getStartOrEndDate((Date)endDate, true))));
                Optional.ofNullable(this.getModel().getValue("typeid")).ifPresent(type -> qFilters.add(new QFilter(SALCONTRACT_TYPE, "=", ((DynamicObject)type).getPkValue())));
                Optional.ofNullable(this.getModel().getValue("customerfield")).ifPresent(customers -> {
                    Object[] customerIds = ((DynamicObjectCollection)customers).stream().map(customer -> customer.get(2)).toArray();
                    if (customerIds.length > 0) {
                        qFilters.add(new QFilter(SALCONTRACT_CUSTOMER, "in", (Object)customerIds));
                    }
                });
                if (!qFilters.isEmpty()) {
                    formShowParameter.getListFilterParameter().getQFilters().addAll(qFilters);
                }
            }
            case "customerfield": {
                if (this.getModel().getValue("orgfield") == null) {
                    formShowParameter.getListFilterParameter().getQFilters().add(QFilter.of((String)"1!=1", (Object[])new Object[0]));
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SalContractRptPlugin_1", (String)"scmc-conm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                }
                formShowParameter.setShowApproved(false);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        if (!CommonUtils.isRealChanged((ChangeData)e.getChangeSet()[0])) {
            return;
        }
        switch (propName = e.getProperty().getName()) {
            case "orgfield": {
                this.getModel().setValue("customerfield", null);
                this.getModel().setValue("billnoid", null);
                break;
            }
            case "typeid": {
                this.getModel().setValue("billnoid", null);
                break;
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        ReportList reportList = (ReportList)evt.getSource();
        int rowIndex = evt.getRowIndex();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(rowIndex);
        if ("billno".equals(evt.getFieldName())) {
            Object data = rowData.get("id");
            Long billid = Long.valueOf(data.toString());
            this.showOneBillInfo("conm_salcontract", billid);
        }
    }

    private void showOneBillInfo(String entityid, Long billTypeID) {
        BillShowParameter fsp = new BillShowParameter();
        fsp.setFormId(entityid);
        fsp.setStatus(OperationStatus.EDIT);
        fsp.setPkId((Object)billTypeID);
        fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)fsp);
    }

    public static Long getHasPermissionOrg(String entityName, String orgViewType) {
        List hasPermissionOrgs = OrgViewServiceHelper.getAllPermissionOrgs((String)entityName, (String)orgViewType);
        if (CommonUtils.isNull((Object)hasPermissionOrgs)) {
            return null;
        }
        long orgId = RequestContext.get().getOrgId();
        for (Map tempOrg : hasPermissionOrgs) {
            Long id = Long.valueOf((String)tempOrg.get("id"));
            if (!id.equals(orgId)) continue;
            return id;
        }
        return Long.valueOf((String)((Map)hasPermissionOrgs.get(0)).get("id"));
    }

    private void setdefaultDate() {
        IDataModel model = this.getModel();
        Calendar cal = Calendar.getInstance();
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        model.setValue("startdate", (Object)cal.getTime());
        model.setValue("enddate", (Object)cal.getTime());
    }
}

