/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.report.blockchain;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.scmc.conm.enums.BizValidStatusEnum;
import kd.scmc.conm.report.blockchain.helper.UpChainOverViewHelper;
import kd.scmc.conm.utils.CommonUtils;
import org.apache.commons.io.IOUtils;

public class DepositVerifyPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(DepositVerifyPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit numberText = (TextEdit)this.getView().getControl("billno");
        numberText.addClickListener((ClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String newValue = (String)this.getModel().getValue("radiogroup");
        if ("A".equals(newValue)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"attachmentpanelap"});
            this.clearAttachFile();
        } else if ("B".equals(newValue)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"attachmentpanelap"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        List signattachment;
        super.beforeDoOperation(args);
        String radiogroup = (String)this.getModel().getValue("radiogroup");
        if (StringUtils.isEmpty((CharSequence)radiogroup)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u9a8c\u7c7b\u578b\u3002", (String)"DepositVerifyPlugin_2", (String)"scmc-conm-report", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        String billno = (String)this.getModel().getValue("billno");
        if (StringUtils.isEmpty((CharSequence)billno)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u7f16\u53f7\u3002", (String)"DepositVerifyPlugin_8", (String)"scmc-conm-report", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if ("B".equals(radiogroup) && ((signattachment = ((AttachmentPanel)this.getView().getControl("attachmentpanelap")).getAttachmentData()) == null || signattachment.size() == 0)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u6587\u4ef6\u3002", (String)"DepositVerifyPlugin_9", (String)"scmc-conm-report", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operateKey = evt.getOperateKey();
        if (operateKey.equals("verify")) {
            String bizobj = (String)this.getModel().getValue("bizobj");
            String billno = (String)this.getModel().getValue("billno");
            QFilter bizobjno = new QFilter("bizobjno", "=", (Object)bizobj);
            QFilter bizbillno = new QFilter("bizbillno", "in", (Object)billno.split(";")[0]);
            QFilter status = new QFilter("status", "=", (Object)"A");
            DynamicObject[] bea_stc_log = BusinessDataServiceHelper.load((String)"bea_stc_log", (String)"no,mappingno,createtime,entryentity.name,entryentity.value_tag", (QFilter[])bizobjno.and(bizbillno).and(status).toArray());
            DynamicObject log = this.sortLog(bea_stc_log);
            if (log == null) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6838\u9a8c\u7ed3\u679c", (String)"DepositVerifyPlugin_6", (String)"scmc-conm-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5f53\u524d\u6838\u9a8c\u7684\u5355\u636e\u65e0\u4e0a\u94fe\u8bb0\u5f55\u3002", (String)"DepositVerifyPlugin_0", (String)"scmc-conm-report", (Object[])new Object[0]), MessageTypes.Default);
                return;
            }
            String radiogroup = (String)this.getModel().getValue("radiogroup");
            if ("A".equals(radiogroup)) {
                this.checkBill(log);
            } else if ("B".equals(radiogroup)) {
                this.checkFile(log);
            }
        }
    }

    private DynamicObject sortLog(DynamicObject[] bea_stc_log) {
        long time = 0L;
        DynamicObject result = null;
        for (DynamicObject object : bea_stc_log) {
            Date createtime = object.getDate("createtime");
            if (createtime.getTime() <= time) continue;
            result = object;
        }
        return result;
    }

    private void checkFile(DynamicObject log) {
        logger.info("\u6838\u9a8c\u5b58\u8bc1\u7f16\u53f7\uff1a" + log.getString("no"));
        String mappingno = log.getString("mappingno");
        DynamicObject mapping = BusinessDataServiceHelper.loadSingle((String)"bea_mapping", (String)"mapping_entry.datatype_name,mapping_entry.bizname", (QFilter[])new QFilter("number", "in", (Object)mappingno).toArray());
        if (mapping != null) {
            String fileField = "";
            DynamicObjectCollection mapping_entry = mapping.getDynamicObjectCollection("mapping_entry");
            for (DynamicObject entry : mapping_entry) {
                String datatype_name = entry.getString("datatype_name");
                String bizname = entry.getString("bizname");
                if (!"signattachment".equals(bizname)) continue;
                fileField = datatype_name;
            }
            if (StringUtils.isEmpty((CharSequence)fileField)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6838\u9a8c\u7ed3\u679c", (String)"DepositVerifyPlugin_6", (String)"scmc-conm-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5b58\u8bc1\u5b9e\u4f53\u672a\u914d\u7f6e\u7b7e\u7ae0\u9644\u4ef6\u5b57\u6bb5\u3002", (String)"DepositVerifyPlugin_5", (String)"scmc-conm-report", (Object[])new Object[0]), MessageTypes.Default);
                return;
            }
            DynamicObjectCollection entryentity = log.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryentity) {
                String name = entry.getString("name");
                String hashValue = entry.getString("value_tag");
                if (!fileField.equals(name)) continue;
                List signattachment = ((AttachmentPanel)this.getView().getControl("attachmentpanelap")).getAttachmentData();
                if (signattachment == null || signattachment.size() == 0) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u6838\u9a8c\u7ed3\u679c", (String)"DepositVerifyPlugin_6", (String)"scmc-conm-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u6587\u4ef6\u3002", (String)"DepositVerifyPlugin_9", (String)"scmc-conm-report", (Object[])new Object[0]), MessageTypes.Business);
                    return;
                }
                try {
                    TempFileCache tempFile = CacheFactory.getCommonCacheFactory().getTempFileCache();
                    InputStream inputStream = tempFile.getInputStream((String)((Map)signattachment.get(0)).get("url"));
                    byte[] byteArray = IOUtils.toByteArray((InputStream)inputStream);
                    String hashCode = CommonUtils.sha256Base16((byte[])byteArray);
                    if (hashValue.contains(hashCode)) {
                        this.getView().showMessage(ResManager.loadKDString((String)"\u6838\u9a8c\u7ed3\u679c", (String)"DepositVerifyPlugin_6", (String)"scmc-conm-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6838\u9a8c\u6210\u529f\u3002", (String)"DepositVerifyPlugin_1", (String)"scmc-conm-report", (Object[])new Object[0]), MessageTypes.Default);
                    } else {
                        this.getView().showMessage(ResManager.loadKDString((String)"\u6838\u9a8c\u7ed3\u679c", (String)"DepositVerifyPlugin_6", (String)"scmc-conm-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u4e00\u81f4\uff0c\u6838\u9a8c\u5931\u8d25\u3002", (String)"DepositVerifyPlugin_10", (String)"scmc-conm-report", (Object[])new Object[0]), MessageTypes.Default);
                    }
                }
                catch (IOException e) {
                    logger.error(e.getMessage());
                }
                return;
            }
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6838\u9a8c\u7ed3\u679c", (String)"DepositVerifyPlugin_6", (String)"scmc-conm-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e1a\u52a1\u5173\u8054\u7f3a\u5931\u3002", (String)"DepositVerifyPlugin_7", (String)"scmc-conm-report", (Object[])new Object[0]), MessageTypes.Default);
        }
    }

    private void checkBill(DynamicObject log) {
        try {
            String no = log.getString("no");
            logger.info("\u6838\u9a8c\u5b58\u8bc1\u7f16\u53f7\uff1a" + no);
            Object o = DispatchServiceHelper.invokeBizService((String)"bsc", (String)"bea", (String)"StcLogService", (String)"checkStcLog", (Object[])new Object[]{no});
            JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)o));
            Boolean result = jsonObject.getBoolean("result");
            if (result.booleanValue()) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6838\u9a8c\u7ed3\u679c", (String)"DepositVerifyPlugin_6", (String)"scmc-conm-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6838\u9a8c\u6210\u529f\u3002", (String)"DepositVerifyPlugin_1", (String)"scmc-conm-report", (Object[])new Object[0]), MessageTypes.Default);
            } else {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6838\u9a8c\u7ed3\u679c", (String)"DepositVerifyPlugin_6", (String)"scmc-conm-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u4e00\u81f4\uff0c\u6838\u9a8c\u5931\u8d25\u3002", (String)"DepositVerifyPlugin_10", (String)"scmc-conm-report", (Object[])new Object[0]), MessageTypes.Default);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6838\u9a8c\u5f02\u5e38\u3002", (String)"DepositVerifyPlugin_3", (String)"scmc-conm-report", (Object[])new Object[0]));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        boolean realChanged;
        String name = e.getProperty().getName();
        if ("radiogroup".equals(name)) {
            String newValue = (String)e.getChangeSet()[0].getNewValue();
            if ("A".equals(newValue)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"attachmentpanelap"});
                this.clearAttachFile();
            } else if ("B".equals(newValue)) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"attachmentpanelap"});
            }
            this.getView().updateView("attachmentpanelap");
        } else if ("bizobj".equals(name) && (realChanged = CommonUtils.isRealChanged((ChangeData)e.getChangeSet()[0]))) {
            this.getModel().setValue("billno", null);
            this.clearAttachFile();
        }
    }

    private void clearAttachFile() {
        AttachmentPanel attach = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
        List attachmentData = attach.getAttachmentData();
        for (Map attachmentDatum : attachmentData) {
            attach.remove(attachmentDatum);
        }
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String fieldKey = source.getKey();
        if ("billno".equals(fieldKey)) {
            String bizobj = this.getModel().getDataEntity().getString("bizobj");
            if (StringUtils.isEmpty((CharSequence)bizobj)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u5bf9\u8c61\u3002", (String)"DepositVerifyPlugin_4", (String)"scmc-conm-report", (Object[])new Object[0]));
                return;
            }
            QFilter validstatus = new QFilter("validstatus", "=", (Object)BizValidStatusEnum.VALID.getValue());
            Set<Long> orgs = UpChainOverViewHelper.getHasPermissionOrgs(this.getView().getFormShowParameter().getFormId(), OrgViewTypeEnum.IS_PURCHASE.getViewType());
            QFilter org = new QFilter("org", "in", orgs);
            ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)bizobj, (boolean)false, (int)0);
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "billno"));
            List filters = listShowParameter.getListFilterParameter().getQFilters();
            filters.add(validstatus);
            filters.add(org);
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String bizobj = (String)this.getModel().getValue("bizobj");
        if ("billno".equals(e.getActionId()) && StringUtils.isNotEmpty((CharSequence)bizobj)) {
            StringBuffer str = new StringBuffer();
            if (e.getReturnData() != null && e.getReturnData() instanceof ListSelectedRowCollection) {
                ListSelectedRowCollection col = (ListSelectedRowCollection)e.getReturnData();
                HashSet<Long> ids = new HashSet<Long>();
                for (ListSelectedRow row : col) {
                    ids.add((Long)row.getPrimaryKeyValue());
                }
                Map fromCache = BusinessDataServiceHelper.loadFromCache((Object[])ids.toArray(), (String)bizobj);
                Object[] objects = fromCache.values().toArray();
                for (int i = 0; i < objects.length; ++i) {
                    DynamicObject value = (DynamicObject)objects[i];
                    str.append(value.getString("billno"));
                    if (i + 1 >= objects.length) continue;
                    str.append(';');
                }
                this.getModel().setValue("billno", (Object)str);
            }
        }
    }
}

