/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.report.blockchain;

import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.org.OrgViewServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.scmc.conm.report.blockchain.helper.UpChainOverViewHelper;
import kd.scmc.conm.utils.CommonUtils;

public class PerformTrackRptPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener,
BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportlistap = (ReportList)this.getView().getControl("reportlistap");
        reportlistap.addHyperClickListener((HyperLinkClickListener)this);
        MulBasedataEdit bills = (MulBasedataEdit)this.getView().getControl("bills");
        bills.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getModel().setValue("starttime", (Object)PerformTrackRptPlugin.getStartTime());
        this.getModel().setValue("endtime", (Object)PerformTrackRptPlugin.getEndTime());
        String formId = this.getView().getFormShowParameter().getFormId();
        Long org = PerformTrackRptPlugin.getHasPermissionOrg(formId, OrgViewTypeEnum.IS_PURCHASE.getViewType());
        this.getModel().setValue("org", (Object)org);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        ReportList reportList = (ReportList)evt.getSource();
        int rowIndex = evt.getRowIndex();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(rowIndex);
        if ("bizbillno".equals(evt.getFieldName())) {
            String billno = (String)rowData.get("bizbillno");
            this.showOneBillInfo(billno);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (!CommonUtils.isRealChanged((ChangeData)e.getChangeSet()[0])) {
            return;
        }
        String propName = e.getProperty().getName();
        if ("org".equals(propName)) {
            this.getModel().setValue("bills", null);
            this.getView().updateView("bills");
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        Date starttime = filter.getDate("starttime");
        Date endtime = filter.getDate("endtime");
        String hstatus = filter.getString("hstatus");
        DynamicObject org = filter.getDynamicObject("org");
        if (starttime == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e0a\u94fe\u65e5\u671f\u3002", (String)"PerformTrackRptPlugin_0", (String)"scmc-conm-report", (Object[])new Object[0]));
            return false;
        }
        if (endtime == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e0a\u94fe\u65e5\u671f\u3002", (String)"PerformTrackRptPlugin_0", (String)"scmc-conm-report", (Object[])new Object[0]));
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)hstatus)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e0a\u94fe\u72b6\u6001\u3002", (String)"PerformTrackRptPlugin_2", (String)"scmc-conm-report", (Object[])new Object[0]));
            return false;
        }
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"PerformTrackRptPlugin_3", (String)"scmc-conm-report", (Object[])new Object[0]));
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String name = e.getProperty().getName();
        ListShowParameter formShowParameter = (ListShowParameter)e.getFormShowParameter();
        String formId = this.getView().getFormShowParameter().getFormId();
        ListFilterParameter listFilterParameter = formShowParameter.getListFilterParameter();
        switch (name) {
            case "org": {
                listFilterParameter.getQFilters().add(new QFilter("id", "in", UpChainOverViewHelper.getHasPermissionOrgs(formId, OrgViewTypeEnum.IS_PURCHASE.getViewType())));
                break;
            }
            case "bills": {
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                if (org == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"PurSynthesisReportPlugin_0", (String)"scmc-conm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                listFilterParameter.getQFilters().add(new QFilter("org", "=", org.getPkValue()).and(new QFilter("validstatus", "!=", (Object)"")));
            }
        }
    }

    private void showOneBillInfo(String billno) {
        ReportShowParameter fsp = new ReportShowParameter();
        fsp.setFormId("conm_upchaindetail");
        ReportQueryParam queryParam = new ReportQueryParam();
        FilterInfo info = new FilterInfo();
        info.addFilterItem("hbillno", (Object)billno);
        queryParam.setFilter(info);
        fsp.setQueryParam(queryParam);
        fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)fsp);
    }

    private static Date getStartTime() {
        Calendar todayStart = Calendar.getInstance();
        todayStart.set(6, 1);
        todayStart.set(11, 0);
        todayStart.set(12, 0);
        todayStart.set(13, 0);
        todayStart.set(14, 0);
        return todayStart.getTime();
    }

    private static Date getEndTime() {
        Calendar todayEnd = Calendar.getInstance();
        todayEnd.set(11, 23);
        todayEnd.set(12, 59);
        todayEnd.set(13, 59);
        todayEnd.set(14, 999);
        return todayEnd.getTime();
    }

    public static Long getHasPermissionOrg(String entityName, String orgViewType) {
        List hasPermissionOrgs = OrgViewServiceHelper.getAllPermissionOrgs((String)entityName, (String)orgViewType);
        if (CommonUtils.isNull((Object)hasPermissionOrgs)) {
            return null;
        }
        long orgId = RequestContext.get().getOrgId();
        for (Map tempOrg : hasPermissionOrgs) {
            Long id = Long.valueOf((String)tempOrg.get("id"));
            if (!id.equals(orgId)) continue;
            return id;
        }
        return Long.valueOf((String)((Map)hasPermissionOrgs.get(0)).get("id"));
    }
}

