/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.report.blockchain;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class PerformTrackRptQuery
extends AbstractReportListDataPlugin {
    public DataSet query(ReportQueryParam reportQueryParam, Object o) {
        FilterInfo filter = reportQueryParam.getFilter();
        Date starttime = filter.getDate("starttime");
        Date endtime = filter.getDate("endtime");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(endtime);
        calendar.add(5, 1);
        endtime = calendar.getTime();
        DynamicObject org = filter.getDynamicObject("org");
        QFilter time = new QFilter("createtime", "<=", (Object)endtime).and(new QFilter("createtime", ">=", (Object)starttime));
        String status = filter.getString("hstatus");
        if (StringUtils.isNotEmpty((CharSequence)status) && !status.equals("C")) {
            QFilter statusFilter = new QFilter("status", "=", (Object)status);
            time.and(statusFilter);
        }
        QFilter bizobjno = new QFilter("bizobjno", "=", (Object)"conm_purcontract");
        DynamicObjectCollection bills = filter.getDynamicObjectCollection("bills");
        if (bills != null && bills.size() > 0) {
            HashSet<String> billNos = new HashSet<String>();
            for (Object billno : bills) {
                billNos.add(billno.getString("number"));
            }
            bizobjno.and(new QFilter("bizbillno", "in", billNos));
        }
        DataSet stcLog = QueryServiceHelper.queryDataSet((String)"algokey", (String)"bea_stc_log", (String)"no,bizbillno,createtime,taskname,retrytimes,status ,bizobjno", (QFilter[])time.and(bizobjno).toArray(), null);
        HashMap<String, Set> map = new HashMap<String, Set>();
        for (Row log : stcLog.copy()) {
            String datatypeno = log.getString("bizobjno");
            String bizbillno = log.getString("bizbillno");
            Set set = map.computeIfAbsent(datatypeno, a -> new HashSet());
            set.add(bizbillno);
        }
        RowMeta rowMeta = new RowMeta(new String[]{"billno", "cid", "entityType"}, new DataType[]{DataType.StringType, DataType.LongType, DataType.StringType});
        ArrayList emptyList = new ArrayList();
        DataSet tempDataSet = Algo.create((String)"PerformTrackQuery").createDataSet(emptyList.iterator(), rowMeta);
        for (Map.Entry entry : map.entrySet()) {
            String entity = (String)entry.getKey();
            Set billNos = (Set)entry.getValue();
            QFilter billno = new QFilter("billno", "in", (Object)billNos);
            QFilter orgFilter = new QFilter("org", "=", org.getPkValue());
            DataSet contracts = QueryServiceHelper.queryDataSet((String)"filterOrg", (String)entity, (String)("billno,id as cid,'" + entity + "' as entityType"), (QFilter[])orgFilter.and(billno).toArray(), null);
            tempDataSet = tempDataSet.union(contracts);
        }
        DataSet finish = stcLog.join(tempDataSet, JoinType.INNER).on("bizbillno", "billno").on("bizobjno", "entityType").select(new String[]{"no", "bizbillno", "createtime", "taskname", "retrytimes", "status", "bizobjno"}, new String[]{"cid"}).finish().orderBy(new String[]{"createtime desc"});
        return finish;
    }
}

