/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.report.blockchain;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.conm.report.blockchain.helper.BlockChainRptHelper;

public class UpChainDetailRptPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        FilterInfo filter = queryParam.getFilter();
        String hbillno = filter.getString("hbillno");
        this.setContractInfo(hbillno);
        this.setUpChainTimesChart(hbillno);
        HashMap<String, Object> map = new HashMap<String, Object>();
        DynamicObject settlecurrency = this.getModel().getDataEntity().getDynamicObject("settlecurrency");
        int precision = 4;
        if (settlecurrency != null) {
            precision = settlecurrency.getInt("amtprecision");
        }
        this.setAmountChart(hbillno, precision);
        if (settlecurrency != null) {
            map.put("settlecurrency", settlecurrency.getPkValue());
        }
        queryParam.setCustomParam(map);
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        String hbillno = filter.getString("hbillno");
        if (StringUtils.isEmpty((CharSequence)hbillno)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5408\u540c\u7f16\u53f7\u4e3a\u7a7a\uff0c\u67e5\u8be2\u5931\u8d25\u3002", (String)"UpChainDetailRptPlugin_0", (String)"scmc-conm-report", (Object[])new Object[0]));
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    private void setAmountChart(String hbillno, int precision) {
        HistogramChart amountHistogramChart = (HistogramChart)this.getControl("histogramchartap1");
        amountHistogramChart.setName(null);
        BarSeries barSeries = amountHistogramChart.createBarSeries("");
        amountHistogramChart.createXAxis("", new String[]{ResManager.loadKDString((String)"\u5408\u540c\u91d1\u989d", (String)"UpChainDetailRptPlugin_1", (String)"scmc-conm-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8ba2\u5355\u91d1\u989d", (String)"UpChainDetailRptPlugin_2", (String)"scmc-conm-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5e94\u4ed8\u91d1\u989d", (String)"UpChainDetailRptPlugin_3", (String)"scmc-conm-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4ed8\u6b3e\u91d1\u989d", (String)"UpChainDetailRptPlugin_4", (String)"scmc-conm-report", (Object[])new Object[0])});
        String sign = this.getModel().getDataEntity().getDynamicObject("settlecurrency").getString("sign");
        amountHistogramChart.createYAxis("  " + String.format(ResManager.loadKDString((String)"\u91d1\u989d(%1$d)", (String)"UpChainDetailRptPlugin_5", (String)"scmc-conm-report", (Object[])new Object[0]), sign));
        BigDecimal conmAmount = this.getConmAmount(hbillno).setScale(precision, RoundingMode.HALF_UP);
        BigDecimal orderAmount = this.getOrderAmount(hbillno).setScale(precision, RoundingMode.HALF_UP);
        BigDecimal apAmount = this.getApAmount(hbillno).setScale(precision, RoundingMode.HALF_UP);
        BigDecimal casAmount = this.getCasAmount(hbillno).setScale(precision, RoundingMode.HALF_UP);
        barSeries.setData(new Number[]{conmAmount, orderAmount, apAmount, casAmount});
        barSeries.setBarWidth("50px");
        amountHistogramChart.refresh();
    }

    private BigDecimal getOrderAmount(String hbillno) {
        BigDecimal result = BigDecimal.ZERO;
        Field[] entryFields = new Field[]{new Field("billentry[ ].amountandtax", "amountandtax", (DataType)DataType.BigDecimalType, true), new Field("billentry[ ].conbillnumber", "conbillnumber", (DataType)DataType.StringType, true)};
        Field[] headFields = new Field[]{new Field("billstatus", "billstatus", (DataType)DataType.StringType, true)};
        DataSet orderBill = BlockChainRptHelper.queryLog("pm_purorderbill", hbillno, "billentry.conbillnumber", "billno", headFields, entryFields);
        if (orderBill.copy().isEmpty()) {
            return BigDecimal.ZERO;
        }
        DataSet finish = orderBill.filter("conbillnumber = '" + hbillno + "'").filter("status = 'A'");
        DataSet copy = finish.copy().groupBy(new String[]{"bizbillno"}).max("createtime").finish().distinct();
        finish = finish.join(copy, JoinType.INNER).on("bizbillno", "bizbillno").on("createtime", "createtime").select(finish.getRowMeta().getFieldNames(), new String[0]).finish();
        while (finish.hasNext()) {
            Row row = finish.next();
            String billstatus = row.getString("billstatus");
            if (!"C".equals(billstatus)) continue;
            result = result.add(row.getBigDecimal("amountandtax"));
        }
        return result;
    }

    private BigDecimal getApAmount(String hbillno) {
        BigDecimal result = BigDecimal.ZERO;
        Field[] entryFields = new Field[2];
        Field[] headFields = new Field[1];
        entryFields[0] = new Field("detailentry[ ].e_pricetaxtotal", "amountandtax", (DataType)DataType.BigDecimalType, true);
        entryFields[1] = new Field("detailentry[ ].e_contract", "e_contract", (DataType)DataType.StringType, true);
        headFields[0] = new Field("billstatus", "billstatus", (DataType)DataType.StringType, true);
        DataSet apBill = BlockChainRptHelper.queryLog("ap_finapbill", hbillno, "detailentry.e_contract", "billno", headFields, entryFields);
        if (apBill.copy().isEmpty()) {
            return BigDecimal.ZERO;
        }
        DataSet finish = apBill.filter("e_contract = '" + hbillno + "'").filter("status = 'A'");
        DataSet copy = finish.copy().groupBy(new String[]{"bizbillno"}).max("createtime").finish().distinct();
        finish = finish.join(copy, JoinType.INNER).on("bizbillno", "bizbillno").on("createtime", "createtime").select(finish.getRowMeta().getFieldNames(), new String[0]).finish();
        while (finish.hasNext()) {
            Row row = finish.next();
            String billstatus = row.getString("billstatus");
            if (!"C".equals(billstatus)) continue;
            result = result.add(row.getBigDecimal("amountandtax"));
        }
        return result;
    }

    private BigDecimal getCasAmount(String hbillno) {
        BigDecimal result = BigDecimal.ZERO;
        Field[] headFields = new Field[1];
        Field[] entryFields = new Field[]{new Field("entry[ ].e_actamt", "amountandtax", (DataType)DataType.BigDecimalType, true), new Field("entry[ ].contractnumber", "contractnumber", (DataType)DataType.StringType, true)};
        headFields[0] = new Field("billstatus", "billstatus", (DataType)DataType.StringType, true);
        DataSet casBill = BlockChainRptHelper.queryLog("cas_paybill", hbillno, "entry.contractnumber", "billno", headFields, entryFields);
        if (casBill.copy().isEmpty()) {
            return BigDecimal.ZERO;
        }
        DataSet finish = casBill.filter("contractnumber = '" + hbillno + "'").filter("status = 'A'");
        DataSet copy = finish.copy().groupBy(new String[]{"bizbillno"}).max("createtime").finish().distinct();
        finish = finish.join(copy, JoinType.INNER).on("bizbillno", "bizbillno").on("createtime", "createtime").select(finish.getRowMeta().getFieldNames(), new String[0]).finish();
        while (finish.hasNext()) {
            Row row = finish.next();
            String billstatus = row.getString("billstatus");
            if (!"D".equals(billstatus)) continue;
            result = result.add(row.getBigDecimal("amountandtax"));
        }
        return result;
    }

    public BigDecimal getConmAmount(String hbillno) {
        BigDecimal amount = BigDecimal.ZERO;
        QFilter poFilter = new QFilter("mapping_entry.bizname", "in", (Object)new String[]{"totalallamount", "validstatus"});
        poFilter.and(new QFilter("bizmodel.number", "=", (Object)"conm_purcontract"));
        DataSet po_bea_mapping = QueryServiceHelper.queryDataSet((String)"aaa", (String)"bea_mapping", (String)"number,mapping_entry.bizname bizname,mapping_entry.datatype_name mname", (QFilter[])poFilter.toArray(), null);
        QFilter qFilter = new QFilter("bizobjno", "=", (Object)"conm_purcontract");
        qFilter.and(new QFilter("bizbillno", "=", (Object)hbillno));
        DataSet logs = QueryServiceHelper.queryDataSet((String)"query-xbill-log", (String)"bea_stc_log", (String)"no,bizbillno,bizobjno,retrytimes,status,createtime,taskname,mappingno,entryentity.name as name,entryentity.type as type ,entryentity.value_tag as value", (QFilter[])qFilter.toArray(), null);
        DataSet dataSet = logs.join(po_bea_mapping, JoinType.INNER).on("mappingno", "number").on("name", "mname").select(logs.getRowMeta().getFieldNames(), new String[]{"bizname"}).finish();
        if (dataSet.isEmpty()) {
            return amount;
        }
        DataSet conmBill = BlockChainRptHelper.parseChainLog(dataSet.copy(), new Field[]{new Field("totalallamount", "amountandtax", (DataType)DataType.BigDecimalType, true), new Field("validstatus", (DataType)DataType.StringType)}, null);
        if ((conmBill = conmBill.filter("validstatus = 'B'").filter("status = 'A'").groupBy(new String[]{"no", "bizbillno", "validstatus", "createtime"}).sum("amountandtax").finish()).copy().isEmpty()) {
            return BigDecimal.ZERO;
        }
        Long time = 0L;
        while (conmBill.hasNext()) {
            Row row = conmBill.next();
            Date createtime = row.getDate("createtime");
            if (createtime.getTime() <= time) continue;
            amount = row.getBigDecimal("amountandtax");
        }
        return amount;
    }

    private void setUpChainTimesChart(String hbillno) {
        int casTimes;
        int apTimes;
        int orderTimes;
        int maxTimes = 1;
        QFilter bizbillno = new QFilter("billno", "=", (Object)hbillno);
        QFilter validStatus = new QFilter("validstatus", "=", (Object)"B");
        int xconmTimes = QueryServiceHelper.queryDataSet((String)"queryXConmTimes", (String)"conm_xpurcontract", (String)"changebillno", (QFilter[])bizbillno.and(validStatus).toArray(), null).groupBy(new String[]{"changebillno"}).finish().count("changebillno", true);
        if (xconmTimes > maxTimes) {
            maxTimes = xconmTimes;
        }
        if ((orderTimes = this.getUpChainTimes("pm_purorderbill", "billentry.conbillnumber", hbillno)) > maxTimes) {
            maxTimes = orderTimes;
        }
        if ((apTimes = this.getUpChainTimes("ap_finapbill", "detailentry.e_contract", hbillno)) > maxTimes) {
            maxTimes = apTimes;
        }
        if ((casTimes = this.getUpChainTimes("cas_paybill", "entry.contractnumber", hbillno)) > maxTimes) {
            maxTimes = casTimes;
        }
        HistogramChart amountHistogramChart = (HistogramChart)this.getControl("histogramchartap");
        amountHistogramChart.setName(null);
        BarSeries barSeries = amountHistogramChart.createBarSeries("");
        amountHistogramChart.createXAxis("", new String[]{ResManager.loadKDString((String)"\u5408\u540c\u53d8\u66f4", (String)"UpChainDetailRptPlugin_6", (String)"scmc-conm-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u91c7\u8d2d\u8ba2\u5355", (String)"UpChainDetailRptPlugin_7", (String)"scmc-conm-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u4ed8", (String)"UpChainDetailRptPlugin_8", (String)"scmc-conm-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355", (String)"UpChainDetailRptPlugin_9", (String)"scmc-conm-report", (Object[])new Object[0])});
        Axis yAxis = amountHistogramChart.createYAxis("                 " + ResManager.loadKDString((String)"\u4e0a\u94fe\u6b21\u6570(\u6b21)", (String)"UpChainDetailRptPlugin_10", (String)"scmc-conm-report", (Object[])new Object[0]));
        double floor = Math.floor((double)maxTimes / 3.6);
        yAxis.setInterval((Number)(floor > 0.0 ? floor : 1.0));
        barSeries.setData(new Number[]{xconmTimes, orderTimes, apTimes, casTimes});
        barSeries.setBarWidth("50px");
        amountHistogramChart.refresh();
    }

    private int getUpChainTimes(String entity, String conmNoField, String hbillno) {
        QFilter casConmBillNo = new QFilter(conmNoField, "=", (Object)hbillno);
        DataSet casBill = QueryServiceHelper.queryDataSet((String)"queryXConmTimes", (String)entity, (String)"billno", (QFilter[])casConmBillNo.toArray(), null);
        DataSet casBillNo = casBill.groupBy(new String[]{"billno"}).finish();
        QFilter status = new QFilter("status", "=", (Object)"A");
        DataSet casBills_log = QueryServiceHelper.queryDataSet((String)"query-bill-log", (String)"bea_stc_log", (String)"no,bizbillno", (QFilter[])new QFilter("bizobjno", "=", (Object)entity).and(status).toArray(), null);
        int times = casBills_log.join(casBillNo, JoinType.INNER).on("bizbillno", "billno").select(new String[]{"no"}).finish().count("no", true);
        return times;
    }

    private void setContractInfo(String hbillno) {
        QFilter billno = new QFilter("billno", "=", (Object)hbillno);
        DynamicObject one = BusinessDataServiceHelper.loadSingleFromCache((String)"conm_purcontract", (String)"billno,billname,settlecurrency,totalallamount,paidallamount,orderallamount", (QFilter[])new QFilter[]{billno});
        this.getModel().setValue("billno", (Object)one.getString("billno"));
        this.getModel().setValue("billname", (Object)one.getString("billname"));
        this.getModel().setValue("htotalallamount", (Object)one.getBigDecimal("totalallamount"));
        this.getModel().setValue("settlecurrency", (Object)one.getLong("settlecurrency.id"));
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
    }
}

