/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.report.functions;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Map;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.util.StringUtils;
import kd.scmc.conm.business.helper.AmountHelper;

public class ConmAmountCalcFunction
extends MapFunction {
    private RowMeta currentRowMeta;
    private String[] calcQtyFields;
    private String[] calcAmountFields;
    private String[] calcCurAmountFields;
    private Map<Object, DynamicObject> currencyMap;

    public ConmAmountCalcFunction(RowMeta rowMeta, String[] calcQtyFields, String[] calcAmountFields, String[] calcCurAmountFields, Map<Object, DynamicObject> currencyMap) {
        super.setSourceRowMeta(rowMeta);
        this.calcQtyFields = calcQtyFields;
        this.calcAmountFields = calcAmountFields;
        this.calcCurAmountFields = calcCurAmountFields;
        this.currencyMap = currencyMap;
    }

    public Object[] map(Row row) {
        String exchangetype = row.getString("orderexchangetype");
        BigDecimal exchangerate = row.getBigDecimal("orderexchangerate");
        int insertIndex = this.getSourceRowMeta().getFieldCount();
        Object[] qtyResult = RowUtil.toArray((Row)row);
        Object[] qtyResultTo = new Object[this.getResultRowMeta().getFieldCount()];
        System.arraycopy(qtyResult, 0, qtyResultTo, 0, qtyResult.length);
        if (this.calcQtyFields != null && this.calcAmountFields != null && this.calcCurAmountFields != null && this.calcQtyFields.length > 0 && this.calcAmountFields.length > 0 && this.calcCurAmountFields.length > 0 && this.calcQtyFields.length == this.calcAmountFields.length && this.calcQtyFields.length == this.calcCurAmountFields.length) {
            BigDecimal price = row.getBigDecimal("orderprice");
            BigDecimal priceAndTax = row.getBigDecimal("orderpriceandtax");
            Long orderCurrency = row.getLong("ordercurrency");
            Long ordersettlecurrency = row.getLong("ordersettlecurrency");
            boolean isTax = row.getBoolean("orderistax");
            BigDecimal taxRate = row.getBigDecimal("ordertaxrate");
            String discountType = row.getString("orderdiscountType");
            BigDecimal discountRate = row.getBigDecimal("orderdiscountrate");
            int settlePrecision = ordersettlecurrency != null && !ordersettlecurrency.equals(Long.valueOf("0")) && this.currencyMap.get(ordersettlecurrency) != null ? this.currencyMap.get(ordersettlecurrency).getInt("amtprecision") : 10;
            int curPrecision = orderCurrency != null && !orderCurrency.equals(Long.valueOf("0")) && this.currencyMap.get(orderCurrency) != null ? this.currencyMap.get(orderCurrency).getInt("amtprecision") : 10;
            for (int i = 0; i < this.calcQtyFields.length; ++i) {
                BigDecimal qty = row.getBigDecimal(this.calcQtyFields[i]);
                if (qty != null && qty.compareTo(BigDecimal.ZERO) != 0) {
                    BigDecimal[] calcResult = this.calc(price, priceAndTax, isTax, taxRate, discountType, discountRate, settlePrecision, curPrecision, qty, exchangetype, exchangerate);
                    qtyResultTo[insertIndex + i] = calcResult[0];
                    qtyResultTo[insertIndex + i + this.calcQtyFields.length] = calcResult[1];
                    continue;
                }
                qtyResultTo[insertIndex + i] = null;
                qtyResultTo[insertIndex + i + this.calcQtyFields.length] = null;
            }
        }
        return qtyResultTo;
    }

    private BigDecimal[] calc(BigDecimal price, BigDecimal priceAndTax, boolean isTax, BigDecimal taxRate, String discountType, BigDecimal discountRate, int settlePrecision, int curPrecision, BigDecimal qty, String exchangetype, BigDecimal exchangerate) {
        BigDecimal amountAndTaxCalc = BigDecimal.ZERO;
        BigDecimal curAmountAndTaxCalc = BigDecimal.ZERO;
        taxRate = taxRate != null ? taxRate.divide(new BigDecimal("100")).setScale(10, 4) : BigDecimal.ZERO;
        if (discountRate == null || StringUtils.isEmpty((String)discountType) || discountType.equals("NULL") || discountRate.compareTo(BigDecimal.ZERO) == 0) {
            if (isTax && priceAndTax != null && priceAndTax.compareTo(BigDecimal.ZERO) != 0) {
                amountAndTaxCalc = qty.multiply(priceAndTax).setScale(settlePrecision, RoundingMode.HALF_UP);
                curAmountAndTaxCalc = AmountHelper.getCurAmountByRate((BigDecimal)amountAndTaxCalc, (BigDecimal)exchangerate, (int)curPrecision, (String)exchangetype);
            } else if (price != null && price.compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal amount = qty.multiply(price).setScale(settlePrecision, RoundingMode.HALF_UP);
                BigDecimal taxAmount = amount.multiply(taxRate).setScale(settlePrecision, RoundingMode.HALF_UP);
                amountAndTaxCalc = amount.add(taxAmount).setScale(settlePrecision, RoundingMode.HALF_UP);
                curAmountAndTaxCalc = AmountHelper.getCurAmountByRate((BigDecimal)amount, (BigDecimal)exchangerate, (int)curPrecision, (String)exchangetype).add(AmountHelper.getCurAmountByRate((BigDecimal)taxAmount, (BigDecimal)exchangerate, (int)curPrecision, (String)exchangetype));
            }
        } else if (isTax && priceAndTax != null && priceAndTax.compareTo(BigDecimal.ZERO) != 0) {
            if ("A".equals(discountType)) {
                discountRate = discountRate.divide(new BigDecimal("100")).setScale(10, 4);
                BigDecimal discountAmount = qty.multiply(priceAndTax).multiply(discountRate).setScale(settlePrecision, RoundingMode.HALF_UP);
                amountAndTaxCalc = BigDecimal.ONE.compareTo(discountRate) == 0 ? qty.multiply(priceAndTax).setScale(settlePrecision, RoundingMode.HALF_UP).subtract(discountAmount) : qty.multiply(priceAndTax).subtract(discountAmount).setScale(settlePrecision, RoundingMode.HALF_UP);
            } else if ("B".equals(discountType) || "C".equals(discountType)) {
                BigDecimal discountAmount = qty.multiply(discountRate).setScale(settlePrecision, RoundingMode.HALF_UP);
                amountAndTaxCalc = priceAndTax.compareTo(discountRate) == 0 ? qty.multiply(priceAndTax).setScale(settlePrecision, RoundingMode.HALF_UP).subtract(discountAmount) : qty.multiply(priceAndTax).subtract(discountAmount).setScale(settlePrecision, RoundingMode.HALF_UP);
            }
            curAmountAndTaxCalc = AmountHelper.getCurAmountByRate((BigDecimal)amountAndTaxCalc, (BigDecimal)exchangerate, (int)curPrecision, (String)exchangetype);
        } else if (price != null && price.compareTo(BigDecimal.ZERO) != 0) {
            if ("A".equals(discountType)) {
                discountRate = discountRate.divide(new BigDecimal("100"), 10, 4);
                BigDecimal amount = qty.multiply(price).setScale(settlePrecision, RoundingMode.HALF_UP).multiply(BigDecimal.ONE.subtract(discountRate)).setScale(settlePrecision, RoundingMode.HALF_UP);
                BigDecimal taxAmount = amount.multiply(taxRate).setScale(settlePrecision, RoundingMode.HALF_UP);
                amountAndTaxCalc = amount.add(taxAmount).setScale(settlePrecision, RoundingMode.HALF_UP);
                curAmountAndTaxCalc = AmountHelper.getCurAmountByRate((BigDecimal)amount, (BigDecimal)exchangerate, (int)curPrecision, (String)exchangetype).add(AmountHelper.getCurAmountByRate((BigDecimal)taxAmount, (BigDecimal)exchangerate, (int)curPrecision, (String)exchangetype));
            } else if ("B".equals(discountType) || "C".equals(discountType)) {
                BigDecimal amount = qty.multiply(price.subtract(discountRate)).setScale(settlePrecision, RoundingMode.HALF_UP);
                BigDecimal taxAmount = amount.multiply(taxRate).setScale(settlePrecision, RoundingMode.HALF_UP);
                amountAndTaxCalc = amount.add(taxAmount).setScale(settlePrecision, RoundingMode.HALF_UP);
                curAmountAndTaxCalc = AmountHelper.getCurAmountByRate((BigDecimal)amount, (BigDecimal)exchangerate, (int)curPrecision, (String)exchangetype).add(AmountHelper.getCurAmountByRate((BigDecimal)taxAmount, (BigDecimal)exchangerate, (int)curPrecision, (String)exchangetype));
            }
        }
        return new BigDecimal[]{amountAndTaxCalc, curAmountAndTaxCalc};
    }

    public RowMeta getResultRowMeta() {
        if (this.currentRowMeta == null) {
            if (this.calcAmountFields != null && this.calcCurAmountFields != null) {
                RowMeta sourceRowMeta = this.getSourceRowMeta();
                ArrayList<Field> fields = new ArrayList<Field>(sourceRowMeta.getFieldCount() + this.calcAmountFields.length + this.calcCurAmountFields.length);
                for (Field field : sourceRowMeta.getFields()) {
                    fields.add(field);
                }
                for (String string : this.calcAmountFields) {
                    fields.add(new Field(string, (DataType)DataType.BigDecimalType, false));
                }
                for (String string : this.calcCurAmountFields) {
                    fields.add(new Field(string, (DataType)DataType.BigDecimalType, false));
                }
                this.currentRowMeta = new RowMeta(fields.toArray(new Field[0]));
            } else {
                this.currentRowMeta = this.getSourceRowMeta();
            }
        }
        return this.currentRowMeta;
    }
}

