/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.report.functions;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.algo.Collector;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowUtil;
import kd.bos.util.StringUtils;

public class MergeProcessFunction
extends ReduceGroupFunctionWithCollector {
    private String mainKeyField;
    private String[] otherKeyFields;
    private String conmKey = "";
    private Set<String> keySnapshot = new HashSet<String>();
    private Map<String, Row> rowMap = new HashMap<String, Row>();

    public MergeProcessFunction(RowMeta rowMeta, String mainKeyField, String[] otherKeyFields) {
        this.mainKeyField = mainKeyField;
        this.otherKeyFields = otherKeyFields;
        super.setSourceRowMeta(rowMeta);
    }

    public void reduce(Iterator<Row> iter, Collector collector) {
        while (iter.hasNext()) {
            String mainKey;
            Row row = iter.next();
            String conmKey_row = row.getString(this.mainKeyField);
            if (!this.conmKey.equals(conmKey_row)) {
                this.rowMap.forEach((k, v) -> collector.collect(RowUtil.toArray((Row)v)));
                this.rowMap.clear();
                this.conmKey = conmKey_row;
                this.keySnapshot.clear();
                mainKey = this.generateMainKey(row, conmKey_row);
                this.keySnapshot.add(mainKey);
                this.rowMap.put(mainKey, row);
                continue;
            }
            mainKey = this.generateMainKey(row, conmKey_row);
            boolean isRemove = this.keySnapshot.removeIf(e -> {
                if (mainKey.indexOf((String)e) >= 0) {
                    this.rowMap.remove(e);
                    return true;
                }
                return false;
            });
            if (isRemove) {
                this.keySnapshot.add(mainKey);
                this.rowMap.put(mainKey, row);
                continue;
            }
            AtomicBoolean override = new AtomicBoolean(false);
            this.keySnapshot.forEach(e -> {
                if (e.indexOf(mainKey) >= 0) {
                    override.set(true);
                }
            });
            if (override.get()) continue;
            this.keySnapshot.add(mainKey);
            this.rowMap.put(mainKey, row);
        }
        this.rowMap.forEach((k, v) -> collector.collect(RowUtil.toArray((Row)v)));
        this.keySnapshot.clear();
        this.rowMap.clear();
    }

    public RowMeta getResultRowMeta() {
        return this.getSourceRowMeta();
    }

    private String generateMainKey(Row row, String conmKey_row) {
        StringBuilder mainKeyBuilder = new StringBuilder(conmKey_row);
        for (String keyField : this.otherKeyFields) {
            String key_row = row.getString(keyField);
            mainKeyBuilder.append(StringUtils.isNotEmpty((String)key_row) ? key_row : "");
        }
        return mainKeyBuilder.toString();
    }
}

