/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.webapi;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class InvProductInBatchApiService
implements IBillWebApiPlugin {
    private Map<String, String> BASEDATA_MAP_FIELDS = new HashMap<String, String>(16);
    private Set<String> DATE_FIELDS = new HashSet<String>(4);
    private SimpleDateFormat SDF_TIME = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");

    public ApiResult doCustomService(Map<String, Object> params) {
        String billformId = (String)params.get("billid");
        if (billformId == null) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u8bf7\u586b\u5199billid\u53c2\u6570\u3002", (String)"InvProductInBatchApiService_0", (String)"scmc-im-webapi", (Object[])new Object[0]), (String)"030");
        }
        HashMap<String, String> allBillErrorMap = new HashMap<String, String>(8);
        HashSet<String> billnos = new HashSet<String>();
        OperationResult auditResult = null;
        List<DynamicObject> bills = this.buildBillModel(billformId, allBillErrorMap, params, billnos);
        OperationResult saveResult = this.save(billformId, allBillErrorMap, bills);
        List saveSuccessPkIds = saveResult.getSuccessPkIds();
        if (!saveSuccessPkIds.isEmpty()) {
            OperationResult submitResult = this.submit(billformId, saveSuccessPkIds, allBillErrorMap);
            List submitSuccessPkIds = submitResult.getSuccessPkIds();
            if (!submitResult.getSuccessPkIds().isEmpty()) {
                auditResult = this.audit(billformId, submitSuccessPkIds, allBillErrorMap);
            }
        }
        ApiResult finallyApiResult = this.buildApiResult(allBillErrorMap, billnos, auditResult);
        return finallyApiResult;
    }

    private List<DynamicObject> buildBillModel(String billformId, Map<String, String> allBillErrorMap, Map<String, Object> params, Set<String> billnos) {
        DynamicObject[] dys;
        ArrayList datastrArray = (ArrayList)params.get("datastr");
        ArrayList<DynamicObject> bills = new ArrayList<DynamicObject>(5);
        for (Object datastr : datastrArray) {
            LinkedHashMap dataStrLinkHashMap = (LinkedHashMap)datastr;
            StringBuilder sbPerBillErrorInfo = new StringBuilder();
            DynamicObject dynamicObject = this.createDynamicObject(dataStrLinkHashMap, sbPerBillErrorInfo, billformId);
            String billno = dynamicObject.getString("billno");
            billnos.add(billno);
            if (!sbPerBillErrorInfo.toString().isEmpty()) {
                allBillErrorMap.put(billno, sbPerBillErrorInfo.toString());
            }
            bills.add(dynamicObject);
        }
        for (DynamicObject dy : dys = BusinessDataServiceHelper.load((String)billformId, (String)"billno,id", (QFilter[])new QFilter("billno", "in", billnos).toArray())) {
            allBillErrorMap.put(dy.getString("billno"), ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728", (String)"InvProductInBatchApiService_1", (String)"scmc-im-webapi", (Object[])new Object[0]));
        }
        this.excludeNotMeetBill(allBillErrorMap, bills);
        return bills;
    }

    private ApiResult buildApiResult(Map<String, String> allBillErrorMap, Set<String> billnos, OperationResult auditResult) {
        ApiResult finallyApiResult = new ApiResult();
        if (allBillErrorMap.isEmpty()) {
            HashMap<String, String> returnData = new HashMap<String, String>(billnos.size());
            Iterator<String> iterator = billnos.iterator();
            while (iterator.hasNext()) {
                returnData.put(iterator.next(), "true");
            }
            finallyApiResult.setData(returnData);
            finallyApiResult.setErrorCode("success");
        } else {
            Map<String, String> returnData = allBillErrorMap;
            if (auditResult != null && auditResult.getSuccessPkIds().size() > 0) {
                List successPkIds = auditResult.getSuccessPkIds();
                Map billNos = auditResult.getBillNos();
                for (Object successPkId : successPkIds) {
                    String billNo = (String)billNos.get(successPkId);
                    if (StringUtils.isEmpty((CharSequence)billNo)) {
                        billNo = (String)billNos.get(successPkId.toString());
                    }
                    returnData.put(billNo, "true");
                }
            }
            finallyApiResult.setData(returnData);
            finallyApiResult.setSuccess(false);
            finallyApiResult.setErrorCode("fail");
        }
        return finallyApiResult;
    }

    private OperationResult audit(String billformId, List<Object> billIds, Map<String, String> allBillErrorMap) {
        OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)billformId, (Object[])billIds.toArray(), (OperateOption)this.getOperateOption());
        List<Object> errorIds = this.convertOperaionResultToMap(billformId, auditResult, allBillErrorMap, billIds);
        if (!errorIds.isEmpty()) {
            OperationServiceHelper.executeOperate((String)"unsubmit", (String)billformId, (Object[])errorIds.toArray(), (OperateOption)this.getOperateOption());
            OperationServiceHelper.executeOperate((String)"delete", (String)billformId, (Object[])errorIds.toArray(), (OperateOption)this.getOperateOption());
        }
        return auditResult;
    }

    private OperationResult submit(String billformId, List<Object> billIds, Map<String, String> allBillErrorMap) {
        OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)billformId, (Object[])billIds.toArray(), (OperateOption)this.getOperateOption());
        List<Object> errorIds = this.convertOperaionResultToMap(billformId, submitResult, allBillErrorMap, billIds);
        if (!errorIds.isEmpty()) {
            OperationServiceHelper.executeOperate((String)"delete", (String)billformId, (Object[])errorIds.toArray(), (OperateOption)this.getOperateOption());
        }
        return submitResult;
    }

    private OperationResult save(String billformId, Map<String, String> allBillErrorMap, List<DynamicObject> alldynamicObjectData) {
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)billformId, (DynamicObject[])alldynamicObjectData.toArray(new DynamicObject[alldynamicObjectData.size()]), (OperateOption)this.getOperateOption());
        this.convertOperaionResultToMap(billformId, saveResult, allBillErrorMap, null);
        return saveResult;
    }

    private OperateOption getOperateOption() {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ignoreinteraction", String.valueOf(true));
        return option;
    }

    private List<DynamicObject> excludeNotMeetBill(Map<String, String> allBillErrorMap, List<DynamicObject> alldynamicObjectData) {
        ArrayList<DynamicObject> excludeBill = new ArrayList<DynamicObject>(5);
        if (!allBillErrorMap.isEmpty()) {
            Iterator<DynamicObject> iterator = alldynamicObjectData.iterator();
            while (iterator.hasNext()) {
                DynamicObject dynamicObject = iterator.next();
                if (allBillErrorMap.get(dynamicObject.getString("billno")) == null) continue;
                excludeBill.add(dynamicObject);
                iterator.remove();
            }
        }
        return excludeBill;
    }

    private List<Object> convertOperaionResultToMap(String billformId, OperationResult operationResult, Map<String, String> allBillErrorMap, List<Object> billIds) {
        List successPkIds = operationResult.getSuccessPkIds();
        ArrayList<Object> errorIds = new ArrayList<Object>();
        if (billIds != null && billIds.size() != successPkIds.size()) {
            for (Object billId : billIds) {
                if (successPkIds.contains(billId)) continue;
                errorIds.add(billId);
            }
        }
        ArrayList errorMsgIds = new ArrayList(errorIds);
        HashSet<String> billnos = new HashSet<String>(3);
        List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
        for (IOperateInfo errorInfo : allErrorOrValidateInfo) {
            String errorMessage = errorInfo.getMessage();
            String[] strings = errorMessage.split(":");
            String billNo = strings[0];
            String msg = strings[1];
            if (billnos.contains(billNo)) {
                allBillErrorMap.put(billNo, msg + allBillErrorMap.get(billNo));
            } else {
                allBillErrorMap.put(billNo, msg);
            }
            billnos.add(billNo);
            Object pkValue = errorInfo.getPkValue();
            if (errorIds == null || !errorIds.contains(pkValue)) continue;
            errorMsgIds.remove(pkValue);
        }
        if (errorMsgIds != null && !errorMsgIds.isEmpty()) {
            QFilter q = new QFilter("id", "in", errorMsgIds);
            DynamicObjectCollection bills = QueryServiceHelper.query((String)billformId, (String)"id,billno", (QFilter[])q.toArray());
            String message = operationResult.getMessage();
            for (DynamicObject bill : bills) {
                String billNo = bill.getString("billno");
                if (allBillErrorMap.get(billNo) != null) {
                    allBillErrorMap.put(billNo, message + allBillErrorMap.get(billNo));
                    continue;
                }
                allBillErrorMap.put(billNo, message);
            }
        }
        return errorIds;
    }

    private DynamicObject createDynamicObject(LinkedHashMap<String, Object> dataStrLinkHashMap, StringBuilder sbPerBillErrorInfo, String billformId) {
        DynamicObject dysObj = BusinessDataServiceHelper.newDynamicObject((String)billformId);
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)billformId);
        Map allFiledsInfo = dataEntityType.getAllFields();
        for (Map.Entry entry : allFiledsInfo.entrySet()) {
            if (entry.getValue() instanceof BasedataProp) {
                BasedataProp basedataProp = (BasedataProp)entry.getValue();
                String entityId = basedataProp.getBaseEntityId();
                this.BASEDATA_MAP_FIELDS.put((String)entry.getKey(), entityId);
                continue;
            }
            if (!(entry.getValue() instanceof DateTimeProp)) continue;
            this.DATE_FIELDS.add((String)entry.getKey());
        }
        Set allFiledsSet = allFiledsInfo.keySet();
        for (Map.Entry<String, Object> entry : dataStrLinkHashMap.entrySet()) {
            Object value = entry.getValue();
            String key = entry.getKey();
            if (!allFiledsSet.contains(key) && !(value instanceof ArrayList)) continue;
            this.setValue(key, value, dysObj, sbPerBillErrorInfo);
            if (!(value instanceof ArrayList)) continue;
            DynamicObjectCollection billentryCollection = (DynamicObjectCollection)dysObj.get(key);
            for (Object rowData : (ArrayList)value) {
                DynamicObject dysRowData = billentryCollection.addNew();
                LinkedHashMap row = (LinkedHashMap)rowData;
                for (Map.Entry tmp : row.entrySet()) {
                    String rowKey = (String)tmp.getKey();
                    if (!allFiledsSet.contains(rowKey)) continue;
                    this.setValue(rowKey, tmp.getValue(), dysRowData, sbPerBillErrorInfo);
                }
            }
        }
        return dysObj;
    }

    private void setValue(String key, Object value, DynamicObject dys, StringBuilder sbPerBillErrorInfo) {
        if (this.DATE_FIELDS.contains(key)) {
            try {
                if (value instanceof Date) {
                    dys.set(key, value);
                } else if (value instanceof String) {
                    int value_length = ((String)value).length();
                    if (value_length == 10) {
                        value = value + " 00:00:00";
                        dys.set(key, (Object)this.SDF_TIME.parse((String)value));
                    } else {
                        dys.set(key, (Object)this.SDF_TIME.parse((String)value));
                    }
                }
            }
            catch (ParseException e) {
                sbPerBillErrorInfo.append(String.format(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u201c%s\u201d\u53c2\u6570\u65e5\u671f\u683c\u5f0f\u6709\u8bef\u3002", (String)"InvReserveCreateApiService_0", (String)"scmc-im-webapi", (Object[])new Object[0]), key));
            }
        }
        if (!this.DATE_FIELDS.contains(key) && (value instanceof String || value instanceof BigDecimal || value instanceof Integer || value instanceof Long)) {
            dys.set(key, value);
        }
        if (value instanceof LinkedHashMap) {
            this.setBaseDateValue(key, value, dys, sbPerBillErrorInfo);
        }
    }

    private void setBaseDateValue(String key, Object value, DynamicObject dysObj, StringBuilder sbPerBillErrorInfo) {
        String BASEDATA_MAP_FIELDS_value = this.BASEDATA_MAP_FIELDS.get(key);
        if (BASEDATA_MAP_FIELDS_value != null) {
            Object number_value = ((LinkedHashMap)value).get("number");
            if (number_value == null) {
                return;
            }
            DynamicObject tmp = null;
            tmp = "bd_operator".equals(BASEDATA_MAP_FIELDS_value) ? BusinessDataServiceHelper.loadSingleFromCache((String)BASEDATA_MAP_FIELDS_value, (String)"id,operatorname", (QFilter[])new QFilter("operatorname", "=", number_value).toArray()) : ("bd_materialinventoryinfo".equals(BASEDATA_MAP_FIELDS_value) ? BusinessDataServiceHelper.loadSingleFromCache((String)BASEDATA_MAP_FIELDS_value, (String)"id,masterid.number,enableserial", (QFilter[])new QFilter("masterid.number", "=", number_value).toArray()) : BusinessDataServiceHelper.loadSingleFromCache((String)BASEDATA_MAP_FIELDS_value, (String)"id,number", (QFilter[])new QFilter("number", "=", number_value).toArray()));
            if (tmp == null) {
                sbPerBillErrorInfo.append(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7684\u7f16\u7801\u201c%2$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"InvReserveCreateApiService_1", (String)"scmc-im-webapi", (Object[])new Object[0]), key, value));
                return;
            }
            dysObj.set(key, (Object)tmp);
        }
    }
}

