/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.algox.age;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.DecimalReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.TextReportColumn;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.bplat.scmc.report.util.ReportUtil;
import kd.scmc.im.report.algox.age.AgeRptParam;
import kd.scmc.im.report.algox.age.AgeRptUtil;
import kd.scmc.im.report.algox.age.trans.CalAgeQty;
import kd.scmc.im.report.algox.age.trans.CalDetailAge;
import kd.scmc.im.report.algox.age.trans.RmCols;
import kd.scmc.im.report.algox.age.trans.SetAgeCols;
import kd.scmc.im.report.algox.util.RptHandle;
import kd.scmc.im.report.algox.util.RptUtil;
import kd.scmc.im.report.algox.util.trans.AddMaterialGroup;
import kd.scmc.im.report.algox.util.trans.ZeroQtyFilterTransform;

public final class AgeRptHandle
implements IReportDataHandle {
    private AgeRptParam rptParam;
    private RptHandle rptHandle;

    public void setupCtx(ReportDataCtx ctx) {
        this.rptParam = (AgeRptParam)ctx.getParam(AgeRptParam.class.getName());
        ctx.setFixedFs(this.getFixedFilter());
        this.setCountQtyCols(ctx);
        this.getRptHandle().setImHeadFilter(ctx, this.rptParam);
    }

    private void setCountQtyCols(ReportDataCtx ctx) {
        HashSet<String> sumQtyCols = new HashSet<String>(AgeRptUtil.buildQtyCols(ctx.getShowQtyCols(), this.rptParam.getAgeSegment()));
        ctx.setSumQtyCols4Count(sumQtyCols);
    }

    private RptHandle getRptHandle() {
        return this.rptHandle == null ? (this.rptHandle = new RptHandle().setRptParam(this.rptParam)) : this.rptHandle;
    }

    private List<QFilter> getFixedFilter() {
        ArrayList<QFilter> fs = new ArrayList<QFilter>();
        fs.add(RptUtil.buildStatusFs("status", false));
        fs.add(new QFilter("isupdatebal", "=", (Object)"0").and("isvirtualbill", "=", (Object)"0"));
        if (this.rptParam.isUseClosingDate()) {
            fs.add(RptUtil.buildBizTimeFs("biztime", this.rptParam.getBillFromDate(), this.rptParam.getToDate()));
        } else {
            fs.add(new QFilter("biztime", ">=", (Object)this.rptParam.getBillFromDate()));
        }
        this.getRptHandle().appendCommonFs(fs);
        return fs;
    }

    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        String srcEntity = null;
        RptHandle handle = this.getRptHandle();
        for (SrcBlockConf blockConf : blockCollector) {
            srcEntity = blockConf.getSrcEntity();
            if ("im_inv_periodbalance".equals(srcEntity)) {
                this.handleInitQtyBlock(blockConf);
            }
            handle.handleInitBill(blockConf, false);
            handle.handleMaterialFs(blockConf);
            handle.handleNoUpdateCols(blockConf);
        }
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new SetAgeCols(ctx));
    }

    public void transFormAfterGroup(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new CalAgeQty(ctx));
        transCollector.add(new ZeroQtyFilterTransform(ctx));
        AddMaterialGroup addMaterialGroup = new AddMaterialGroup(ctx, this.rptParam);
        addMaterialGroup.setRepoMaterialCol("materialgroup");
        addMaterialGroup.setRepoMaterialCol("material");
        transCollector.add(addMaterialGroup);
        if (!this.rptParam.isShowAgeGroup()) {
            transCollector.add(new CalDetailAge(ctx));
        }
    }

    public void transFormAfterAddSumRow(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new RmCols(ctx));
    }

    private void handleInitQtyBlock(SrcBlockConf blockConf) {
        int period = this.rptParam.isUseClosingDate() ? RptUtil.getPeriod(this.rptParam.getBillFromDate(), -1) : 999900;
        this.getRptHandle().handlePerBalFs(blockConf, period);
    }

    private void appendAgeQtyCols(List<AbstractReportColumn> showCols, ReportColumn qtyCol, int[] ageSegment, boolean summary) {
        showCols.add((AbstractReportColumn)qtyCol);
        if (!this.rptParam.isShowAgeGroup()) {
            return;
        }
        String qtyColName = qtyCol.getCaption().getLocaleValue();
        String unitCol = qtyCol.getMeasureUnitField();
        String qtyColKey = qtyCol.getFieldKey();
        String fieldKey = null;
        boolean zeroShow = qtyCol.isZeroShow();
        boolean scaleZero = qtyCol.isNoDisplayScaleZero();
        LocaleString colName = null;
        DecimalReportColumn tempQtyCol = null;
        for (int i = 0; i < ageSegment.length; ++i) {
            fieldKey = AgeRptUtil.getQtyInCol(qtyColKey, ageSegment[i]);
            colName = i == ageSegment.length - 1 ? new LocaleString(qtyColName + "(" + AgeRptUtil.buildAgeLastName(ageSegment[i]) + ")") : new LocaleString(qtyColName + "(" + AgeRptUtil.buildAgeName(ageSegment[i], ageSegment[i + 1]) + ")");
            tempQtyCol = ReportUtil.buildQtyCol((String)fieldKey, (LocaleString)colName, (String)unitCol, (boolean)summary);
            tempQtyCol.setZeroShow(zeroShow);
            tempQtyCol.setNoDisplayScaleZero(scaleZero);
            showCols.add((AbstractReportColumn)tempQtyCol);
        }
    }

    public void handleBigtableCols(Set<String> repoColFilter, ReportDataCtx ctx) {
        repoColFilter.add("biztime");
        repoColFilter.add("datatype");
        repoColFilter.add("noupdateinvfields");
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> columns, ReportDataCtx ctx) {
        Set showQtyCols = ctx.getShowQtyCols();
        int[] ageSegment = this.rptParam.getAgeSegment();
        ArrayList<AbstractReportColumn> showCols = new ArrayList<AbstractReportColumn>(columns.size() + showQtyCols.size() * ageSegment.length);
        ReportColumn reportCol = null;
        String field = null;
        boolean summary = false;
        for (AbstractReportColumn col : columns) {
            reportCol = (ReportColumn)col;
            field = reportCol.getFieldKey();
            if (showQtyCols.contains(field)) {
                if (col instanceof DecimalReportColumn) {
                    summary = ((DecimalReportColumn)col).getSummary() == 1;
                }
                this.appendAgeQtyCols(showCols, reportCol, ageSegment, summary);
                continue;
            }
            showCols.add(col);
        }
        if (!this.rptParam.isShowAgeGroup()) {
            TextReportColumn column = new TextReportColumn();
            column.setCaption(new LocaleString(ResManager.loadKDString((String)"\u8d26\u9f84\u5929\u6570", (String)"AgeRptHandle_1", (String)"scmc-im-report", (Object[])new Object[0])));
            column.setFieldKey("detailage");
            column.setFieldType("text");
            showCols.add((AbstractReportColumn)column);
        }
        for (AbstractReportColumn column : showCols) {
            ((ReportColumn)column).setZeroShow(true);
        }
        return showCols;
    }
}

