/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.algox.age.func;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.resource.ResManager;
import kd.bplat.scmc.report.util.TransformUtil;
import kd.scmc.im.report.algox.age.AgeRptUtil;
import kd.scmc.im.report.algox.age.SplitParam;

public class SplitRowFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 2271289537550473206L;
    private RowMeta rowMeta;
    private Map<String, Integer> index;
    private int[] ageSegment;
    private Set<String> qtyCols;

    public SplitRowFunction(RowMeta rowMeta, SplitParam param) {
        this.rowMeta = rowMeta;
        this.qtyCols = param.getQtyCols();
        this.ageSegment = param.getAgeSegment();
        List<String> allCols = AgeRptUtil.buildQtyCols(this.qtyCols, this.ageSegment);
        allCols.add("detailage");
        this.index = TransformUtil.buildIndexs((RowMeta)rowMeta, allCols);
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        for (RowX rowX : iterable) {
            for (int i = 0; i < this.ageSegment.length; ++i) {
                RowX copy = rowX.copy();
                boolean flag = false;
                for (String qtyCol : this.qtyCols) {
                    String segmentQtyCol = qtyCol + "_in" + "_" + i;
                    BigDecimal segmentQty = rowX.getBigDecimal(this.index.get(segmentQtyCol).intValue());
                    if (BigDecimal.ZERO.compareTo(segmentQty) >= 0) continue;
                    Integer qtyColIndex = this.index.get(qtyCol);
                    copy.set(qtyColIndex.intValue(), (Object)segmentQty);
                    flag = true;
                }
                if (!flag) continue;
                if (i == this.ageSegment.length - 1) {
                    copy.set(this.index.get("detailage").intValue(), (Object)ResManager.loadKDString((String)"{0}\u5929\u53ca\u4ee5\u4e0a", (String)"SplitRowFunction_1", (String)"scmc-im-report", (Object[])new Object[]{i}));
                } else {
                    copy.set(this.index.get("detailage").intValue(), (Object)ResManager.loadKDString((String)"{0}\u5929", (String)"SplitRowFunction_2", (String)"scmc-im-report", (Object[])new Object[]{i}));
                }
                collector.collect(copy);
            }
        }
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

