/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.algox.age.trans;

import java.math.BigDecimal;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.datatype.DateType;
import kd.bos.algox.DataSetX;
import kd.bos.algox.MapFunction;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.scmc.im.report.algox.age.AgeRptParam;
import kd.scmc.im.report.algox.age.AgeRptUtil;
import kd.scmc.im.report.algox.age.func.MoveAgeColMapFunc;

public class SetAgeCols
implements IDataXTransform {
    private ReportDataCtx ctx;

    public SetAgeCols(ReportDataCtx ctx) {
        this.ctx = ctx;
    }

    public DataSetX doTransform(DataSetX srcData) {
        srcData = this.fillAgeCols(srcData);
        srcData = srcData.map((MapFunction)new MoveAgeColMapFunc(this.ctx, srcData.getRowMeta()));
        return srcData;
    }

    private DataSetX fillAgeCols(DataSetX srcData) {
        AgeRptParam param = (AgeRptParam)this.ctx.getParam(AgeRptParam.class.getName());
        int[] ageSegment = param.getAgeSegment();
        Set showQtyCols = this.ctx.getShowQtyCols();
        List<String> ageQtyCols = AgeRptUtil.buildAgeQtyCols(showQtyCols, ageSegment);
        Field[] fs = new Field[ageQtyCols.size()];
        Object[] vals = new Object[ageQtyCols.size()];
        int i = 0;
        for (String ageQtyCol : ageQtyCols) {
            fs[i] = new Field(ageQtyCol, (DataType)DateType.BigDecimalType);
            vals[i] = BigDecimal.ZERO;
            ++i;
        }
        return srcData.addFields(fs, vals);
    }
}

