/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.algox.detail;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.DecimalReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.conf.BigTableColConf;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.bplat.scmc.report.util.ReportUtil;
import kd.scmc.im.report.algox.detail.DetailRptParam;
import kd.scmc.im.report.algox.detail.trans.QtyTransform;
import kd.scmc.im.report.algox.sum.trans.FilterQty;
import kd.scmc.im.report.algox.util.RptHandle;
import kd.scmc.im.report.algox.util.RptUtil;
import kd.scmc.im.report.algox.util.trans.AddMaterialGroup;
import kd.scmc.im.report.algox.util.trans.QtyHeadFilterTransform;

public final class DetailRptHandle
implements IReportDataHandle {
    private DetailRptParam reportParam;
    private RptHandle rptHandle;

    public void setupCtx(ReportDataCtx ctx) {
        this.reportParam = (DetailRptParam)ctx.getParam(DetailRptParam.class.getName());
        this.getRptHandle().addNecessaryCol(ctx);
        this.addNecessaryCol(ctx);
        this.setFixedFs(ctx);
        this.appendId2BigTb(ctx);
        ctx.setUseDefGroup(false);
        this.getRptHandle().setImHeadFilter(ctx, this.reportParam);
    }

    private void addNecessaryCol(ReportDataCtx ctx) {
        Set showKeyCols = ctx.getShowKeyCols();
        Set showQtyCols = ctx.getShowQtyCols();
        Map controlPropMap = ctx.getReportConf().getControlPropMap();
        String unitCol = null;
        for (String qtyCol : showQtyCols) {
            unitCol = (String)controlPropMap.get(qtyCol);
            if (unitCol == null) continue;
            showKeyCols.add(unitCol);
        }
        showKeyCols.add("auditdate");
        showKeyCols.add("material");
    }

    private void appendId2BigTb(ReportDataCtx ctx) {
        List bigtb = ctx.getReportConf().getBigTableColConf();
        BigTableColConf conf = new BigTableColConf();
        conf.setCol("billid");
        conf.setCalType("C");
        conf.setDataType((DataType)DataType.LongType);
        bigtb.add(conf);
    }

    private void setFixedFs(ReportDataCtx ctx) {
        ArrayList<QFilter> fixedFs = ctx.getFixedFs();
        if (fixedFs == null) {
            fixedFs = new ArrayList<QFilter>();
            ctx.setFixedFs(fixedFs);
        }
        fixedFs.addAll(this.getFixedFilter());
    }

    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        String srcEntity = null;
        RptHandle handle = this.getRptHandle();
        for (SrcBlockConf blockConf : blockCollector) {
            srcEntity = blockConf.getSrcEntity();
            if ("im_inv_periodbalance".equals(srcEntity)) {
                this.handleInitQtyBlock(blockConf);
            }
            handle.handleInitBill(blockConf, this.reportParam.isIncludeUnUpdateBal());
            handle.handleMaterialFs(blockConf);
            this.appendIdMap2Block(blockConf);
            handle.handleNoUpdateCols(blockConf);
        }
    }

    private void appendIdMap2Block(SrcBlockConf blockConf) {
        Map colMap = blockConf.getRepoColSrcColMap();
        colMap.put("billid", "id");
        colMap = blockConf.getRepoColFullSrcColMap();
        colMap.put("billid", "id");
    }

    public void handleBigtableCols(Set<String> repoColFilter, ReportDataCtx ctx) {
        repoColFilter.add("perioddate");
        repoColFilter.add("datatype");
        repoColFilter.add("billid");
    }

    private void handleInitQtyBlock(SrcBlockConf blockConf) {
        if (this.reportParam.isShowInitAndBalQty()) {
            int period = RptUtil.getPeriod(this.reportParam.getBillFromDate(), -1);
            this.getRptHandle().handlePerBalFs(blockConf, period);
        } else {
            blockConf.setEnbale(false);
        }
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new QtyTransform(ctx));
    }

    public void transFormAfterGroup(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        Collection<String> qtyFilters = this.reportParam.getQtyFilters();
        if (!qtyFilters.isEmpty()) {
            transCollector.add(new FilterQty(ctx));
        }
        AddMaterialGroup addMaterialGroup = new AddMaterialGroup(ctx, this.reportParam);
        addMaterialGroup.setRepoMaterialCol("materialgroup");
        addMaterialGroup.setRepoMaterialCol("material");
        transCollector.add(addMaterialGroup);
    }

    public void transformResult(List<IDataTransform> transCollector, ReportDataCtx ctx) {
        DetailRptParam param = (DetailRptParam)ctx.getParam(DetailRptParam.class.getName());
        List<QFilter> headFilters = param.getHeadFilters();
        transCollector.add(new QtyHeadFilterTransform(headFilters));
    }

    private RptHandle getRptHandle() {
        return this.rptHandle == null ? (this.rptHandle = new RptHandle().setRptParam(this.reportParam)) : this.rptHandle;
    }

    private List<QFilter> getFixedFilter() {
        ArrayList<QFilter> fs = new ArrayList<QFilter>();
        fs.add(RptUtil.buildStatusFs("status", this.reportParam.isIncludeSubmitStatus()));
        fs.add(RptUtil.buildBizTimeFs("perioddate", this.reportParam.isShowInitAndBalQty() ? this.reportParam.getBillFromDate() : this.reportParam.getFromDate(), this.reportParam.getToDate()));
        if (!this.reportParam.isIncludeUnUpdateBal()) {
            fs.add(new QFilter("isupdatebal", "=", (Object)"0").and("isvirtualbill", "=", (Object)"0"));
        }
        this.getRptHandle().appendCommonFs(fs);
        return fs;
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> columns, ReportDataCtx ctx) {
        Set showQtyCols = ctx.getShowQtyCols();
        ArrayList<AbstractReportColumn> showCols = new ArrayList<AbstractReportColumn>(columns.size() + showQtyCols.size() * 3);
        ReportColumn reportCol = null;
        boolean showInitAndBal = this.reportParam.isShowInitAndBalQty();
        boolean showInQty = this.reportParam.isShowInQty();
        boolean showOutQty = this.reportParam.isShowOutQty();
        String field = null;
        String qtyColName = null;
        DecimalReportColumn tempQtyCol = null;
        boolean zeroShow = false;
        boolean scaleZero = false;
        boolean summary = false;
        for (AbstractReportColumn col : columns) {
            reportCol = (ReportColumn)col;
            field = reportCol.getFieldKey();
            zeroShow = reportCol.isZeroShow();
            scaleZero = reportCol.isNoDisplayScaleZero();
            if (showQtyCols.contains(field)) {
                if (col instanceof DecimalReportColumn) {
                    summary = ((DecimalReportColumn)col).getSummary() == 1;
                }
                qtyColName = col.getCaption().getLocaleValue();
                String unitCol = reportCol.getMeasureUnitField();
                if (showInQty) {
                    tempQtyCol = ReportUtil.buildQtyCol((String)(field + "_in"), (LocaleString)new LocaleString(String.format(ResManager.loadKDString((String)"%1$s\uff08\u6536\u5165\uff09", (String)"DetailRptHandle_0", (String)"scmc-im-report", (Object[])new Object[0]), qtyColName)), (String)unitCol, (boolean)summary);
                    tempQtyCol.setZeroShow(zeroShow);
                    tempQtyCol.setNoDisplayScaleZero(scaleZero);
                    showCols.add((AbstractReportColumn)tempQtyCol);
                }
                if (showOutQty) {
                    tempQtyCol = ReportUtil.buildQtyCol((String)(field + "_out"), (LocaleString)new LocaleString(String.format(ResManager.loadKDString((String)"%1$s\uff08\u53d1\u51fa\uff09", (String)"DetailRptHandle_1", (String)"scmc-im-report", (Object[])new Object[0]), qtyColName)), (String)unitCol, (boolean)summary);
                    tempQtyCol.setZeroShow(zeroShow);
                    tempQtyCol.setNoDisplayScaleZero(scaleZero);
                    showCols.add((AbstractReportColumn)tempQtyCol);
                }
                if (showInitAndBal) {
                    tempQtyCol = ReportUtil.buildQtyCol((String)(field + "_bal"), (LocaleString)new LocaleString(String.format(ResManager.loadKDString((String)"%1$s\uff08\u7ed3\u4f59\uff09", (String)"DetailRptHandle_2", (String)"scmc-im-report", (Object[])new Object[0]), qtyColName)), (String)unitCol, (boolean)summary);
                    tempQtyCol.setZeroShow(zeroShow);
                    tempQtyCol.setNoDisplayScaleZero(scaleZero);
                    showCols.add((AbstractReportColumn)tempQtyCol);
                }
            } else {
                showCols.add(col);
            }
            if (!"billno".equals(field)) continue;
            reportCol.setHyperlink(true);
        }
        return showCols;
    }
}

