/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.algox.detail.func;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowUtil;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.util.RowXIterator;
import kd.bplat.scmc.report.util.TransformUtil;
import kd.scmc.im.report.algox.detail.DetailRptParam;
import kd.scmc.im.report.algox.util.RptUtil;

public class AddBalRowGroupReduceFunc
extends GroupReduceFunction {
    private static final long serialVersionUID = -7345383644177343003L;
    private RowMeta rowMeta;
    private Map<String, Integer> idxs;
    private Date fromDate;
    private Set<String> qtyCols;
    private String[] groupCols;
    private boolean showInitAndBalQty;

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public AddBalRowGroupReduceFunc(ReportDataCtx ctx, RowMeta rowMeta, String[] groupCols) {
        this.rowMeta = rowMeta;
        this.qtyCols = ctx.getShowQtyCols();
        this.groupCols = groupCols;
        DetailRptParam rptParam = (DetailRptParam)ctx.getParam(DetailRptParam.class.getName());
        this.fromDate = rptParam.getFromDate();
        this.showInitAndBalQty = rptParam.isShowInitAndBalQty();
        this.buildIndexs();
    }

    private void buildIndexs() {
        int numColCount = this.qtyCols.size();
        ArrayList<String> cols = new ArrayList<String>(numColCount * 3 + 4);
        cols.add("perioddate");
        cols.add("datatype");
        cols.add("linetype");
        for (String groupCol : this.groupCols) {
            cols.add(groupCol);
        }
        ArrayList<Object> suffixs = new ArrayList<Object>(4);
        suffixs.add("");
        suffixs.add("_in");
        suffixs.add("_out");
        if (this.showInitAndBalQty) {
            suffixs.add("_bal");
        }
        RptUtil.appendSuffixs(cols, this.qtyCols, suffixs);
        this.idxs = TransformUtil.buildIndexs((RowMeta)this.rowMeta, cols);
    }

    public void reduce(Iterable<RowX> it, Collector cl) {
        DataSet dataSet = Algo.create((String)"BalQtyGroupReduceFunc").createDataSet((Iterator)new RowXIterator(it), this.rowMeta);
        dataSet = dataSet.orderBy(new String[]{"perioddate asc", "auditdate asc", "datatype asc"});
        if (this.showInitAndBalQty) {
            this.buildBalCol(dataSet, cl);
        } else {
            for (Row row : dataSet) {
                cl.collect(new RowX(RowUtil.toArray((Row)row)));
            }
        }
    }

    private void buildBalCol(DataSet dataSet, Collector cl) {
        RowX initQtyRow = null;
        RowX balQtyRow = null;
        RowX data = null;
        for (Row row : dataSet) {
            data = new RowX(RowUtil.toArray((Row)row));
            if (initQtyRow == null) {
                initQtyRow = this.buildInitQtyRow(data);
            }
            if (data.getDate(this.idxs.get("perioddate").intValue()).before(this.fromDate)) {
                this.calInitQty(initQtyRow, data);
                continue;
            }
            if (balQtyRow == null) {
                balQtyRow = this.buildBalQtyRow(initQtyRow);
                cl.collect(initQtyRow);
            }
            this.calBalQty(balQtyRow, data);
            cl.collect(data);
        }
        if (initQtyRow == null) {
            return;
        }
        if (balQtyRow == null) {
            balQtyRow = this.buildBalQtyRow(initQtyRow);
            cl.collect(initQtyRow);
        }
        cl.collect(balQtyRow);
    }

    private RowX buildBalQtyRow(RowX initQtyRow) {
        RowX balQtyRow = initQtyRow.copy();
        balQtyRow.set(this.idxs.get("linetype").intValue(), (Object)"2");
        return balQtyRow;
    }

    private RowX buildInitQtyRow(RowX data) {
        RowX initQtyRow = new RowX(new Object[data.size()]);
        int idx = -1;
        for (String groupCol : this.groupCols) {
            idx = this.idxs.get(groupCol);
            initQtyRow.set(idx, data.get(idx));
        }
        initQtyRow.set(this.idxs.get("linetype").intValue(), (Object)"1");
        for (String qty : this.qtyCols) {
            initQtyRow.set(this.idxs.get(qty).intValue(), (Object)BigDecimal.ZERO);
            initQtyRow.set(this.idxs.get(qty + "_in").intValue(), (Object)BigDecimal.ZERO);
            initQtyRow.set(this.idxs.get(qty + "_out").intValue(), (Object)BigDecimal.ZERO);
            initQtyRow.set(this.idxs.get(qty + "_bal").intValue(), (Object)BigDecimal.ZERO);
        }
        return initQtyRow;
    }

    private void calBalQty(RowX balQtyRow, RowX data) {
        this.calInitQty(balQtyRow, data);
        int balQtyIdx = -1;
        for (String qty : this.qtyCols) {
            balQtyIdx = this.idxs.get(qty + "_bal");
            data.set(balQtyIdx, balQtyRow.get(balQtyIdx));
        }
    }

    private void calInitQty(RowX initQtyRow, RowX data) {
        int balQtyIdx = -1;
        int qtyIdx = -1;
        int typeIdx = -1;
        for (String qty : this.qtyCols) {
            qtyIdx = this.idxs.get(qty);
            balQtyIdx = this.idxs.get(qty + "_bal");
            typeIdx = this.idxs.get("datatype");
            if ("1".equals(data.getString(typeIdx))) {
                initQtyRow.set(balQtyIdx, (Object)initQtyRow.getBigDecimal(balQtyIdx).subtract(data.getBigDecimal(qtyIdx)));
                continue;
            }
            initQtyRow.set(balQtyIdx, (Object)initQtyRow.getBigDecimal(balQtyIdx).add(data.getBigDecimal(qtyIdx)));
        }
    }
}

