/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.algox.detail.trans;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.MapFunction;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.scmc.im.report.algox.detail.DetailRptParam;
import kd.scmc.im.report.algox.detail.func.AddBalRowGroupReduceFunc;
import kd.scmc.im.report.algox.detail.func.MoveQtyMapFunc;

public class QtyTransform
implements IDataXTransform {
    private ReportDataCtx ctx;
    private Set<String> showQtyCols;
    private boolean showInitAndBalQty;

    public QtyTransform(ReportDataCtx ctx) {
        this.ctx = ctx;
        this.showQtyCols = ctx.getShowQtyCols();
        DetailRptParam rptParam = (DetailRptParam)ctx.getParam(DetailRptParam.class.getName());
        this.showInitAndBalQty = rptParam.isShowInitAndBalQty();
    }

    public DataSetX doTransform(DataSetX srcData) {
        srcData = this.fillingQtyCols(srcData);
        srcData = srcData.map((MapFunction)new MoveQtyMapFunc(this.ctx, srcData.getRowMeta()));
        String[] groupCols = this.buildGroupCols();
        srcData = srcData.groupBy(groupCols).reduceGroup((GroupReduceFunction)new AddBalRowGroupReduceFunc(this.ctx, srcData.getRowMeta(), groupCols));
        srcData = this.removeCols(srcData);
        return srcData;
    }

    private String[] buildGroupCols() {
        Map controlPropMap = this.ctx.getReportConf().getControlPropMap();
        HashSet<Object> groupCols = new HashSet<Object>(8);
        for (String qtyCol : this.showQtyCols) {
            groupCols.add(controlPropMap.get(qtyCol));
        }
        groupCols.add("material");
        return groupCols.toArray(new String[0]);
    }

    private DataSetX removeCols(DataSetX srcData) {
        ArrayList<String> cols = new ArrayList<String>();
        cols.add("datatype");
        cols.add("perioddate");
        return srcData.removeFields(cols.toArray(new String[0]));
    }

    private DataSetX fillingQtyCols(DataSetX srcData) {
        int size = this.showQtyCols.size() + 1;
        ArrayList<Field> fields = new ArrayList<Field>(size);
        ArrayList<Object> vals = new ArrayList<Object>(size);
        for (String qtyCol : this.showQtyCols) {
            fields.add(new Field(qtyCol + "_in", (DataType)DataType.BigDecimalType));
            vals.add(BigDecimal.ZERO);
            fields.add(new Field(qtyCol + "_out", (DataType)DataType.BigDecimalType));
            vals.add(BigDecimal.ZERO);
            if (!this.showInitAndBalQty) continue;
            fields.add(new Field(qtyCol + "_bal", (DataType)DataType.BigDecimalType));
            vals.add(BigDecimal.ZERO);
        }
        fields.add(new Field("linetype", (DataType)DataType.StringType));
        vals.add("0");
        return srcData.addFields(fields.toArray(new Field[0]), vals.toArray());
    }
}

