/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.algox.dull;

import com.alibaba.fastjson.JSON;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bplat.scmc.report.core.ReportDataHandle;
import kd.scmc.im.business.helper.AuxptyFilterHelper;
import kd.scmc.im.report.algox.dull.DullRptParam;
import kd.scmc.im.report.algox.util.RptForm;
import kd.scmc.im.report.algox.util.RptUtil;
import kd.scmc.im.utils.F7Utils;
import kd.scmc.im.utils.FormUtils;

public final class DullRptForm
extends AbstractReportFormPlugin
implements BeforeF7SelectListener,
BeforeFilterF7SelectListener {
    private RptForm localRptForm;
    private static final String[] IN_BILL = new String[]{"im_productinbill", "im_purinbill", "im_ospurinbill", "im_otherinbill", "im_transinbill", "im_transdirbill"};
    private static final String[] OUT_BILL = new String[]{"im_saloutbill", "im_materialreqoutbill", "im_osmaterialreqoutbill", "im_otheroutbill", "im_transoutbill", "im_transdirbill"};
    private static final String ID = "id";
    private static final String CACHE_BILL_IDS = "cache_billids";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.getRptForm().register((Object)this);
        FormUtils.addF7Listener((BeforeF7SelectListener)this, (String[])new String[]{"inbillinvscheme", "outbillinvscheme", "inbilltype", "outbilltype"});
    }

    private RptForm getRptForm() {
        if (this.localRptForm == null) {
            this.localRptForm = new RptForm(this.getView());
        }
        return this.localRptForm;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getRptForm().initPage(this.getRemoveFilterGridCols());
        this.intBillRange();
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        AuxptyFilterHelper.setAuxEntryEnable((IDataModel)this.getModel(), (IFormView)this.getView());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getRptForm().changeContainLowerGrp();
    }

    private void intBillRange() {
        this.rebuildBillEntry("inentryentity", "inbilltype", IN_BILL);
        this.rebuildBillEntry("outentryentity", "outbilltype", OUT_BILL);
    }

    private void rebuildBillEntry(String entry, String billCol, String[] bills) {
        IDataModel model = this.getModel();
        model.deleteEntryData(entry);
        int[] idxs = model.batchCreateNewEntryRow(entry, bills.length);
        for (int i = 0; i < idxs.length; ++i) {
            model.setValue(billCol, (Object)bills[i], idxs[i]);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        this.getRptForm().propertyChanged(e);
        String name = e.getProperty().getName();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        switch (name) {
            case "inbilltype": {
                this.billTypeChanged(rowIndex, "inbillinvscheme");
                break;
            }
            case "outbilltype": {
                this.billTypeChanged(rowIndex, "outbillinvscheme");
                break;
            }
        }
    }

    private void billTypeChanged(int rowIndex, String invSchemeCol) {
        this.getModel().setValue(invSchemeCol, null, rowIndex);
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        IReportView view = this.getView();
        if (RptUtil.isNull(view, "invorg") || RptUtil.isNull(view, "groupstandard")) {
            return false;
        }
        if (!this.getRptForm().checkDataCtrl()) {
            return false;
        }
        ReportQueryParam param = this.getQueryParam();
        DullRptParam reportParam = this.buildReportParms();
        param.getCustomParam().put(DullRptParam.class.getName(), reportParam);
        return true;
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        List<Long> warehouseIds = this.getRptForm().warehouseBeforeQuery(queryParam, this.getModel(), "im_dull_rpt");
        DullRptParam rptParam = (DullRptParam)queryParam.getCustomParam().get(DullRptParam.class.getName());
        rptParam.setWareHouseIds(warehouseIds);
    }

    private DullRptParam buildReportParms() {
        DullRptParam param = new DullRptParam();
        this.getRptForm().buildRptParam(param);
        DynamicObject data = this.getModel().getDataEntity();
        param.setClosingDate(data.getDate("closingdate"), data.getInt("dulldays"));
        param.setDullType(data.getString("dulltype"));
        HashMap<String, Set<Object>> billSchemes = new HashMap<String, Set<Object>>(16);
        this.appendBillSchemes(billSchemes, "inentryentity", "inbilltype", "inbillinvscheme");
        this.appendBillSchemes(billSchemes, "outentryentity", "outbilltype", "outbillinvscheme");
        param.setBillInvScheme(billSchemes);
        return param;
    }

    private void appendBillSchemes(Map<String, Set<Object>> billSchemes, String entry, String typeCol, String schemeCol) {
        DynamicObjectCollection rows = this.getModel().getEntryEntity(entry);
        DynamicObject bill = null;
        String billtype = null;
        Set<Object> schemes = null;
        for (DynamicObject row : rows) {
            bill = row.getDynamicObject(typeCol);
            if (bill == null) continue;
            billtype = bill.getString(ID);
            schemes = billSchemes.get(billtype);
            if (schemes == null) {
                schemes = new HashSet<Object>(8);
                billSchemes.put(billtype, schemes);
            }
            schemes.addAll(RptUtil.getBaseDataIds(row.getDynamicObjectCollection(schemeCol)));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent f7) {
        String name;
        this.getRptForm().beforeF7Select(f7);
        switch (name = f7.getProperty().getName()) {
            case "inbilltype": {
                this.selectInBillType(f7);
                break;
            }
            case "outbilltype": {
                this.selectOutBillType(f7);
                break;
            }
            case "inbillinvscheme": {
                this.selectInBillInvScheme(f7);
                break;
            }
            case "outbillinvscheme": {
                this.selectOutBillInvScheme(f7);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent f7) {
        this.getRptForm().beforeF7Select(f7, this.getModel());
    }

    private String getAndCheckBillType(int idx, String billTypeCol) {
        DynamicObject bill = (DynamicObject)this.getModel().getValue(billTypeCol, idx);
        if (bill == null) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u5355\u636e\u7c7b\u578b\u201d\u3002", (String)"DullRptForm_0", (String)"scmc-im-report", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
            return null;
        }
        return bill.getString(ID);
    }

    private void selectInBillInvScheme(BeforeF7SelectEvent f7) {
        String billId = this.getAndCheckBillType(f7.getRow(), "inbilltype");
        if (billId != null) {
            F7Utils.addF7Filter((BeforeF7SelectEvent)f7, (QFilter)new QFilter("billform", "=", (Object)billId));
            F7Utils.useNotTreeList((BeforeF7SelectEvent)f7);
        } else {
            f7.setCancel(true);
        }
    }

    private void selectOutBillInvScheme(BeforeF7SelectEvent f7) {
        String billId = this.getAndCheckBillType(f7.getRow(), "outbilltype");
        if (billId != null) {
            F7Utils.addF7Filter((BeforeF7SelectEvent)f7, (QFilter)new QFilter("billform", "=", (Object)billId));
            F7Utils.useNotTreeList((BeforeF7SelectEvent)f7);
        } else {
            f7.setCancel(true);
        }
    }

    private void selectOutBillType(BeforeF7SelectEvent f7) {
        F7Utils.addF7Filter((BeforeF7SelectEvent)f7, (QFilter)new QFilter(ID, "in", (Object)this.getBillRange()));
        F7Utils.useNotTreeList((BeforeF7SelectEvent)f7);
    }

    private void selectInBillType(BeforeF7SelectEvent f7) {
        F7Utils.addF7Filter((BeforeF7SelectEvent)f7, (QFilter)new QFilter(ID, "in", (Object)this.getBillRange()));
        F7Utils.useNotTreeList((BeforeF7SelectEvent)f7);
    }

    private String[] getBillRange() {
        String billIdStr = this.getPageCache().get(CACHE_BILL_IDS);
        String[] ids = null;
        if (billIdStr == null) {
            HashSet<String> bills = new HashSet<String>(16);
            DynamicObject conf = ReportDataHandle.loadConfModel((String)this.getModel().getDataEntityType().getName());
            DynamicObjectCollection datas = conf.getDynamicObjectCollection("srcentry");
            DynamicObject bill = null;
            for (DynamicObject data : datas) {
                bill = data.getDynamicObject("srcentity");
                if (bill == null) continue;
                bills.add(bill.getString(ID));
            }
            bills.remove("im_inv_periodbalance");
            ids = bills.toArray(new String[0]);
            billIdStr = JSON.toJSONString((Object)ids);
            this.getPageCache().put(CACHE_BILL_IDS, billIdStr);
        } else {
            ids = (String[])JSON.parseObject((String)billIdStr, String[].class);
        }
        return ids;
    }

    private Set<String> getRemoveFilterGridCols() {
        HashSet<String> removedPros = new HashSet<String>();
        removedPros.add("datatype");
        removedPros.add("biztime");
        removedPros.add("materialmasterid");
        return removedPros;
    }

    public void loadOtherEntryFilter(DynamicObject scheme) {
        super.loadOtherEntryFilter(scheme);
        this.getRptForm().loadOtherEntryFilter(scheme);
        this.loadBillEntry(scheme, "inentryentity", "inbilltype", "inbillinvscheme");
        this.loadBillEntry(scheme, "outentryentity", "outbilltype", "outbillinvscheme");
    }

    private void loadBillEntry(DynamicObject scheme, String entry, String billTypeCol, String invSchemeCol) {
        DynamicObjectCollection rows = scheme.getDynamicObjectCollection(entry);
        IDataModel model = this.getModel();
        model.deleteEntryData(entry);
        if (rows.isEmpty()) {
            return;
        }
        int[] idxs = model.batchCreateNewEntryRow(entry, rows.size());
        int i = 0;
        int rowIdx = 0;
        for (DynamicObject row : rows) {
            rowIdx = idxs[i++];
            model.setValue(billTypeCol, row.get(billTypeCol), rowIdx);
            model.setValue(invSchemeCol, row.get(invSchemeCol), rowIdx);
        }
    }

    public void setOtherEntryFilter(FilterInfo filterInfo) {
        this.getRptForm().saveEntryFilter("auxentry", "inentryentity", "outentryentity");
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        this.getRptForm().closedCallBack(evt);
    }

    public void click(EventObject evt) {
        this.getRptForm().click(evt, (IFormPlugin)this);
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        String entryName = e.getEntryProp().getName();
        IDataModel dataModel = this.getModel();
        DynamicObjectCollection inEntryEntity = dataModel.getEntryEntity("inentryentity");
        DynamicObjectCollection outEntryEntity = dataModel.getEntryEntity("outentryentity");
        int selectRows = e.getRowIndexs().length;
        if ("inentryentity".equals(entryName)) {
            this.checkDeleteBillRangeEntryRow(inEntryEntity, selectRows);
        } else if ("outentryentity".equals(entryName)) {
            this.checkDeleteBillRangeEntryRow(outEntryEntity, selectRows);
        }
    }

    private void checkDeleteBillRangeEntryRow(DynamicObjectCollection entryEntity, int selectRows) {
        if (entryEntity.size() == selectRows) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u8303\u56f4\u5355\u636e\u4f53\u884c\u6570\u4e0d\u80fd\u5c0f\u4e8e1\uff0c\u4e0d\u80fd\u6267\u884c\u8be5\u5220\u9664\u64cd\u4f5c\u3002", (String)"DullRptForm_1", (String)"scmc-im-report", (Object[])new Object[0]));
        }
    }
}

