/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.algox.dull;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.scmc.im.report.algox.dull.DullRptParam;
import kd.scmc.im.report.algox.dull.trans.DullHandle;
import kd.scmc.im.report.algox.dull.trans.FilterDull;
import kd.scmc.im.report.algox.util.RptHandle;
import kd.scmc.im.report.algox.util.RptUtil;
import kd.scmc.im.report.algox.util.trans.AddMaterialGroup;
import kd.scmc.im.report.algox.util.trans.ZeroQtyFilterTransform;

public final class DullRptHandle
implements IReportDataHandle {
    private DullRptParam rptParam;
    private RptHandle rptHandle;

    public void setupCtx(ReportDataCtx ctx) {
        this.rptParam = (DullRptParam)ctx.getParam(DullRptParam.class.getName());
        this.getRptHandle().addNecessaryCol(ctx);
        ctx.setFixedFs(this.getFixedFilter());
        this.getRptHandle().setImHeadFilter(ctx, this.rptParam);
    }

    private RptHandle getRptHandle() {
        return this.rptHandle == null ? (this.rptHandle = new RptHandle().setRptParam(this.rptParam)) : this.rptHandle;
    }

    private List<QFilter> getFixedFilter() {
        ArrayList<QFilter> fs = new ArrayList<QFilter>();
        fs.add(RptUtil.buildStatusFs("status", false));
        fs.add(RptUtil.buildBizTimeFs("biztime", this.rptParam.getBillFromDate(), this.rptParam.getToDate()));
        fs.add(new QFilter("isupdatebal", "=", (Object)"0").and("isvirtualbill", "=", (Object)"0"));
        this.getRptHandle().appendCommonFs(fs);
        this.buildBlockAdvanceFs(fs);
        return fs;
    }

    private void buildBlockAdvanceFs(List<QFilter> fs) {
        if ("2".equals(this.rptParam.getDullType()) && !this.rptParam.isUseClosingDate()) {
            fs.add(new QFilter("datatype", "in", (Object)new String[]{"1", "2"}));
        }
    }

    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        String srcEntity = null;
        RptHandle handle = this.getRptHandle();
        for (SrcBlockConf blockConf : blockCollector) {
            srcEntity = blockConf.getSrcEntity();
            if ("im_inv_periodbalance".equals(srcEntity)) {
                this.handleInitQtyBlock(blockConf);
            }
            handle.handleInitBill(blockConf, false);
            handle.handleMaterialFs(blockConf);
            handle.handleNoUpdateCols(blockConf);
        }
    }

    private void handleInitQtyBlock(SrcBlockConf blockConf) {
        int period = this.rptParam.isUseClosingDate() ? RptUtil.getPeriod(this.rptParam.getBillFromDate(), -1) : 999900;
        this.getRptHandle().handlePerBalFs(blockConf, period);
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new DullHandle(ctx));
    }

    public void beforeGroupData(ReportDataCtx ctx) {
        Collection qtyCols = ctx.getGroupPlan().getQtyCols();
        qtyCols.add("dull_flag_in");
        qtyCols.add("dull_flag_out");
    }

    public void transFormAfterGroup(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new FilterDull(ctx));
        transCollector.add(new ZeroQtyFilterTransform(ctx));
        AddMaterialGroup addMaterialGroup = new AddMaterialGroup(ctx, this.rptParam);
        addMaterialGroup.setRepoMaterialCol("materialgroup");
        addMaterialGroup.setRepoMaterialCol("material");
        transCollector.add(addMaterialGroup);
    }

    public void handleBigtableCols(Set<String> repoColFilter, ReportDataCtx ctx) {
        repoColFilter.add("biztime");
        repoColFilter.add("datatype");
        repoColFilter.add("invscheme");
        repoColFilter.add("block_entity");
        repoColFilter.add("noupdateinvfields");
    }
}

