/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.algox.shelflife;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IFormView;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.PermissionService;
import kd.bos.report.IReportView;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bplat.scmc.report.conf.BigTableColConf;
import kd.bplat.scmc.report.conf.ReportConf;
import kd.bplat.scmc.report.core.ReportDataHandle;
import kd.bplat.scmc.report.util.ReportUtil;
import kd.scmc.im.business.helper.AuxptyFilterHelper;
import kd.scmc.im.business.helper.datactrl.InvBizDataCtrlHelper;
import kd.scmc.im.report.algox.shelflife.ShelfLifeRptParam;
import kd.scmc.im.report.algox.util.RptForm;
import kd.scmc.im.report.algox.util.RptUtil;
import kd.scmc.im.utils.F7Utils;
import kd.scmc.im.utils.FormUtils;
import org.apache.commons.lang3.StringUtils;

public final class ShelfLifeRptForm
extends AbstractReportFormPlugin
implements BeforeF7SelectListener,
BeforeFilterF7SelectListener {
    private static final String MATERIAL_INV_INFO_FROM_COL = "materialinvinfofrom";
    private static final String MATERIAL_INV_INFO_TO_COL = "materialinvinfoto";
    private static final Log log = LogFactory.getLog(ShelfLifeRptForm.class);
    private RptForm localRptForm;
    private ReportConf confCache;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.getRptForm().register((Object)this);
        FormUtils.addF7Listener((BeforeF7SelectListener)this, (String[])new String[]{MATERIAL_INV_INFO_FROM_COL, MATERIAL_INV_INFO_TO_COL});
    }

    private RptForm getRptForm() {
        if (this.localRptForm == null) {
            this.localRptForm = new RptForm(this.getView());
        }
        return this.localRptForm;
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        IReportView view = this.getView();
        if (RptUtil.isNull(view, "invorg") || RptUtil.isNull(view, "groupstandard")) {
            return false;
        }
        if (!this.checkSelectDate()) {
            return false;
        }
        if (!this.getRptForm().checkDataCtrl()) {
            return false;
        }
        ReportQueryParam param = this.getQueryParam();
        ShelfLifeRptParam reportParam = this.buildReportParms();
        param.getCustomParam().put(ShelfLifeRptParam.class.getName(), reportParam);
        return true;
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        List<Long> warehouseIds = this.getRptForm().warehouseBeforeQuery(queryParam, this.getModel(), "im_shelf_life_rpt");
        ShelfLifeRptParam rptParam = (ShelfLifeRptParam)queryParam.getCustomParam().get(ShelfLifeRptParam.class.getName());
        rptParam.setWareHouseIds(warehouseIds);
    }

    private ReportConf getReportConf() {
        if (this.confCache == null) {
            this.confCache = ReportDataHandle.loadReportConf((String)this.getReoprtEntity());
        }
        return this.confCache;
    }

    protected String getReoprtEntity() {
        return this.getModel().getDataEntityType().getName();
    }

    private boolean checkSelectDate() {
        Set showKeyCols = ReportUtil.parseCombColVal((IDataModel)this.getModel(), (String)"showkeycols");
        if (!showKeyCols.contains("producedate")) {
            this.showMustSelectMsg("producedate");
            return false;
        }
        if (!showKeyCols.contains("expirydate")) {
            this.showMustSelectMsg("expirydate");
            return false;
        }
        return true;
    }

    private void showMustSelectMsg(String col) {
        ReportConf conf = this.getReportConf();
        List btCols = conf.getBigTableColConf();
        String colName = col;
        for (BigTableColConf btCol : btCols) {
            if (!btCol.getCol().equals(col)) continue;
            colName = btCol.getColName();
            break;
        }
        String colDisplayName = FormUtils.getColDisplayName((IDataModel)this.getModel(), (String)"showkeycols");
        String msg = ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u201c%1\u201d\u4e2d\u5fc5\u987b\u9009\u4e2d\u201c%2\u201d", (String)"ShelfLifeRptForm_0", (String)"scmc-im-report", (Object[])new Object[0]), (String)"ShelfLifeRptForm_0", (String)"scmc-im-report", (Object[])new Object[]{colDisplayName, colName});
        this.getView().showTipNotification(msg);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getRptForm().initPage(this.getRemoveFilterGridCols());
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        AuxptyFilterHelper.setAuxEntryEnable((IDataModel)this.getModel(), (IFormView)this.getView());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getRptForm().changeContainLowerGrp();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        this.getRptForm().propertyChanged(e);
        String name = e.getProperty().getName();
        if (name.equals(MATERIAL_INV_INFO_FROM_COL)) {
            this.changedMaterialInvInfoFrom(e);
        } else if (name.equals(MATERIAL_INV_INFO_TO_COL)) {
            this.changedMaterialInvInfoTo(e);
        } else if (name.equals("invorg")) {
            this.clearVal(MATERIAL_INV_INFO_FROM_COL, MATERIAL_INV_INFO_TO_COL);
        } else if (name.equals("groupstandard")) {
            this.clearVal(MATERIAL_INV_INFO_FROM_COL, MATERIAL_INV_INFO_TO_COL);
        } else if (name.equals("groupfrom")) {
            this.clearVal(MATERIAL_INV_INFO_FROM_COL, MATERIAL_INV_INFO_TO_COL);
        } else if (name.equals("groupto")) {
            this.clearVal(MATERIAL_INV_INFO_FROM_COL, MATERIAL_INV_INFO_TO_COL);
        }
    }

    private void clearVal(String ... fields) {
        for (String field : fields) {
            this.getModel().setValue(field, null);
        }
    }

    private void changedMaterialInvInfoFrom(PropertyChangedArgs e) {
        ChangeData[] datas = e.getChangeSet();
        DynamicObjectCollection materialInvInfoList = (DynamicObjectCollection)datas[0].getNewValue();
        this.getRptForm().changedFromTo(e, MATERIAL_INV_INFO_TO_COL);
        IReportView view = this.getView();
        if (materialInvInfoList == null || materialInvInfoList.isEmpty()) {
            view.getModel().setValue("materialfrom", null);
        } else {
            DynamicObjectCollection materialFromList = new DynamicObjectCollection();
            for (DynamicObject invInfo : materialInvInfoList) {
                materialFromList.add((Object)invInfo.getDynamicObject("fbasedataid").getDynamicObject("masterid"));
            }
            view.getModel().setValue("materialfrom", (Object)materialFromList);
        }
    }

    private void changedMaterialInvInfoTo(PropertyChangedArgs e) {
        ChangeData[] datas = e.getChangeSet();
        DynamicObject materialInvInfo = (DynamicObject)datas[0].getNewValue();
        IReportView view = this.getView();
        if (materialInvInfo == null) {
            view.getModel().setValue("materialto", null);
        } else {
            view.getModel().setValue("materialto", (Object)materialInvInfo.getDynamicObject("masterid"));
        }
    }

    private ShelfLifeRptParam buildReportParms() {
        ShelfLifeRptParam param = new ShelfLifeRptParam();
        this.getRptForm().buildRptParam(param);
        IDataModel model = this.getModel();
        param.setShelfLifeRange(new Integer[]{(Integer)model.getValue("shelflifedaysfrom"), (Integer)model.getValue("shelflifedaysto")});
        param.setExpiryRange(new Integer[]{(Integer)model.getValue("expirydaysfrom"), (Integer)model.getValue("expirydaysto")});
        param.setExpireDisplay(ReportUtil.parseCombColVal((IDataModel)model, (String)"expiredisplay"));
        DynamicObject data = model.getDataEntity();
        Date prodateFrom = data.getDate("prodatefrom");
        Date prodateTo = data.getDate("prodateto");
        param.setProdateFrom(prodateFrom == null ? null : RptUtil.getShortDate(prodateFrom));
        param.setProdateTo(prodateFrom == null ? null : RptUtil.getShortDate(prodateTo));
        return param;
    }

    public void beforeF7Select(BeforeF7SelectEvent f7) {
        this.getRptForm().beforeF7Select(f7);
        String name = f7.getProperty().getName();
        if (name.equals(MATERIAL_INV_INFO_FROM_COL)) {
            this.selectMaterialInvInfoFrom(f7);
        } else if (name.equals(MATERIAL_INV_INFO_TO_COL)) {
            this.selectMaterialInvInfoTo(f7);
        }
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent f7) {
        this.getRptForm().beforeF7Select(f7, this.getModel());
    }

    public void selectMaterialInvInfoFrom(BeforeF7SelectEvent f7) {
        this.getRptForm().selectMaterial(f7);
        List materialFilters = F7Utils.getFilter((BeforeF7SelectEvent)f7).getQFilters();
        for (QFilter materialFilter : materialFilters) {
            this.transMaterialFs2InvInfoFs(materialFilter);
            List materialNestFilters = materialFilter.getNests(true);
            for (QFilter.QFilterNest materialNestFilter : materialNestFilters) {
                this.transMaterialFs2InvInfoFs(materialNestFilter.getFilter());
            }
        }
        QFilter materialMasterIdFilter = this.getMaterialMasterIdFilter();
        log.info("[ShelfLifeRptForm.selectMaterialInvInfoFrom] materialMasterIdFilter : " + materialMasterIdFilter);
        if (materialMasterIdFilter != null) {
            materialFilters.add(materialMasterIdFilter);
        }
    }

    private QFilter getMaterialMasterIdFilter() {
        Set<Long> bizFilterData;
        DynamicObjectCollection colsEntry;
        boolean hasPlatFilter;
        MainEntityType dataEntityType = this.getView().getModel().getDataEntityType();
        DynamicObject dynamicObject = ReportDataHandle.loadConfModel((String)dataEntityType.getName());
        if (dynamicObject == null) {
            return null;
        }
        Object dataSegOrg = this.getView().getModel().getDataEntity().get(dynamicObject.getString("datasegorg"));
        ArrayList<Long> orgs = new ArrayList<Long>();
        if (dataSegOrg instanceof DynamicObject) {
            orgs.add(((DynamicObject)dataSegOrg).getLong("fbasedataid_id"));
        } else if (dataSegOrg instanceof DynamicObjectCollection) {
            orgs.add(((DynamicObject)((DynamicObjectCollection)dataSegOrg).get(0)).getLong("fbasedataid_id"));
        }
        HashSet<Long> materialMasterIds = new HashSet<Long>(64);
        Set<Long> platFilterData = this.getPlatFilterData(dataEntityType, orgs);
        boolean bl = hasPlatFilter = platFilterData != null;
        if (hasPlatFilter && platFilterData.isEmpty()) {
            return new QFilter("1", "!=", (Object)1);
        }
        if (hasPlatFilter) {
            materialMasterIds.addAll(platFilterData);
        }
        if ((colsEntry = dynamicObject.getDynamicObjectCollection("colsentry")) == null) {
            return materialMasterIds.isEmpty() ? null : new QFilter("masterid", "in", materialMasterIds);
        }
        List confEntryList = colsEntry.stream().filter(item -> StringUtils.isNotEmpty((CharSequence)item.getString("datasegtype"))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(confEntryList)) {
            return materialMasterIds.isEmpty() ? null : new QFilter("masterid", "in", materialMasterIds);
        }
        DynamicObject targetConfRow = null;
        for (DynamicObject confEntry : confEntryList) {
            if (!"material".equals(confEntry.getString("repo_col"))) continue;
            targetConfRow = confEntry;
            break;
        }
        if (targetConfRow == null) {
            return materialMasterIds.isEmpty() ? null : new QFilter("masterid", "in", materialMasterIds);
        }
        String dataSegType = targetConfRow.getString("datasegtype");
        if ("B".equals(dataSegType) && CollectionUtils.isNotEmpty(bizFilterData = this.getBizFilterData(targetConfRow, orgs))) {
            if (hasPlatFilter) {
                materialMasterIds.retainAll(bizFilterData);
            } else {
                materialMasterIds.addAll(bizFilterData);
            }
        }
        log.info("[ShelfLifeRptForm.getMaterialMasterIdFilter] materialMasterIds:" + materialMasterIds);
        return materialMasterIds.isEmpty() ? null : new QFilter("masterid", "in", materialMasterIds);
    }

    private Set<Long> getBizFilterData(DynamicObject targetConfRow, List<Long> orgs) {
        DynamicObject dataCtrlStrategy = targetConfRow.getDynamicObject("datactrlstrategy");
        if (dataCtrlStrategy == null) {
            return Collections.emptySet();
        }
        Long strategyId = dataCtrlStrategy.getLong("id");
        log.info("[ShelfLifeRptForm.getMaterialMasterIdFilter] call getDataByUser param:strategyId:" + strategyId + ",orgs:" + orgs);
        Set dataByUser = InvBizDataCtrlHelper.buildF7Helper().getDataByUser(orgs, strategyId);
        log.info("[ShelfLifeRptForm.getMaterialMasterIdFilter] call getDataByUser result:" + dataByUser);
        return dataByUser;
    }

    private Set<Long> getPlatFilterData(MainEntityType dataEntityType, List<Long> orgs) {
        HashSet<Long> materialMasterIds = new HashSet<Long>(64);
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        log.info("[ShelfLifeRptForm.getMaterialMasterIdFilter] call getDataRuleWithoutDim param:refEntityId:bd_material,orgs:" + orgs);
        QFilter dataRuleWithoutDim = permissionService.getDataRuleWithoutDim(RequestContext.getOrCreate().getCurrUserId(), dataEntityType.getAppId(), "bd_material", "47150e89000000ac", orgs);
        log.info("[ShelfLifeRptForm.getMaterialMasterIdFilter] call getDataRuleWithoutDim result:" + dataRuleWithoutDim);
        if (dataRuleWithoutDim == null) {
            return null;
        }
        try (DataSet materialData = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_material", (String)"id", (QFilter[])dataRuleWithoutDim.toArray(), null);){
            if (!materialData.isEmpty()) {
                materialData.forEach(data -> materialMasterIds.add(data.getLong("id")));
            }
        }
        log.info("[ShelfLifeRptForm.getMaterialMasterIdFilter] materialMasterIds : " + materialMasterIds);
        return materialMasterIds;
    }

    private void transMaterialFs2InvInfoFs(QFilter filter) {
        String key = filter.getProperty();
        if ("id".equals(key)) {
            filter.__setProperty("masterid");
        } else if ("group".equals(key)) {
            filter.__setProperty("masterid.group");
        } else if ("group.number".equals(key)) {
            filter.__setProperty("masterid.group.number");
        } else if ("group.id".equals(key)) {
            filter.__setProperty("masterid.group.id");
        }
    }

    public void selectMaterialInvInfoTo(BeforeF7SelectEvent f7) {
        this.selectMaterialInvInfoFrom(f7);
        this.appendFromNoFs(f7, MATERIAL_INV_INFO_FROM_COL);
    }

    private void appendFromNoFs(BeforeF7SelectEvent f7, String fromCol) {
        DynamicObject data = this.getView().getModel().getDataEntity();
        DynamicObjectCollection fromDatas = data.getDynamicObjectCollection(fromCol);
        if (fromDatas.size() == 1) {
            String no = ((DynamicObject)fromDatas.get(0)).getDynamicObject("fbasedataid").getDynamicObject("masterid").getString("number");
            F7Utils.addF7Filter((BeforeF7SelectEvent)f7, (QFilter)new QFilter("masterid.number", ">=", (Object)no));
        } else if (fromDatas.size() > 1) {
            F7Utils.addF7Filter((BeforeF7SelectEvent)f7, (QFilter)new QFilter("1", "=", (Object)2));
        }
    }

    private Set<String> getRemoveFilterGridCols() {
        HashSet<String> removedPros = new HashSet<String>();
        removedPros.add("producedate");
        removedPros.add("expirydays");
        removedPros.add("shelflifedays");
        removedPros.add("iswarn");
        return removedPros;
    }

    public void loadOtherEntryFilter(DynamicObject scheme) {
        super.loadOtherEntryFilter(scheme);
        this.getRptForm().loadOtherEntryFilter(scheme);
    }

    public void setOtherEntryFilter(FilterInfo filterInfo) {
        this.getRptForm().saveEntryFilter("auxentry");
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        this.getRptForm().closedCallBack(evt);
    }

    public void click(EventObject evt) {
        this.getRptForm().click(evt, (IFormPlugin)this);
    }
}

