/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.algox.shelflife;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.entity.balance.BizDataType;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.scmc.im.report.algox.shelflife.ShelfLifeRptParam;
import kd.scmc.im.report.algox.shelflife.trans.CalShelfLifeCols;
import kd.scmc.im.report.algox.util.RptHandle;
import kd.scmc.im.report.algox.util.trans.AddMaterialGroup;

public final class ShelfLifeRptHandle
implements IReportDataHandle {
    private ShelfLifeRptParam rptParam;
    private RptHandle rptHandle;

    public void setupCtx(ReportDataCtx ctx) {
        this.rptParam = (ShelfLifeRptParam)ctx.getParam(ShelfLifeRptParam.class.getName());
        this.getRptHandle().addNecessaryCol(ctx);
        ctx.setFixedFs(this.getFixedFilter(ctx));
        this.getRptHandle().setImHeadFilter(ctx, this.rptParam);
    }

    private RptHandle getRptHandle() {
        return this.rptHandle == null ? (this.rptHandle = new RptHandle().setRptParam(this.rptParam)) : this.rptHandle;
    }

    private List<QFilter> getFixedFilter(ReportDataCtx ctx) {
        ArrayList<QFilter> fs = new ArrayList<QFilter>();
        Date prodateFrom = this.rptParam.getProdateFrom();
        Date prodateTo = this.rptParam.getProdateTo();
        if (prodateFrom == null && prodateTo == null) {
            fs.add(QFilter.isNotNull((String)"producedate"));
        } else if (prodateFrom == null) {
            fs.add(new QFilter("producedate", "<=", (Object)prodateTo));
        } else if (prodateTo == null) {
            fs.add(new QFilter("producedate", ">=", (Object)prodateFrom));
        } else {
            fs.add(new QFilter("producedate", "<=", (Object)prodateTo).and("producedate", ">=", (Object)prodateFrom));
        }
        fs.add(QFilter.isNotNull((String)"expirydate"));
        Set qtyCols = ctx.getShowQtyCols();
        QFilter qtyFs = null;
        for (String qtyCol : qtyCols) {
            qtyFs = qtyFs == null ? new QFilter(qtyCol, ">", (Object)0) : qtyFs.or(qtyCol, ">", (Object)0);
        }
        if (qtyFs != null) {
            fs.add(qtyFs);
        }
        this.getRptHandle().appendCommonFs(fs);
        return fs;
    }

    public void beforeGroupData(ReportDataCtx ctx) {
        List srcBlockConf = ctx.getReportConf().getSrcBlockConf();
        if (srcBlockConf.size() == 1 && "im_inv_realbalance".equals(((SrcBlockConf)srcBlockConf.get(0)).getSrcEntity())) {
            Map repoColSrcColMap = ((SrcBlockConf)srcBlockConf.get(0)).getRepoColSrcColMap();
            Set showKeyCols = ctx.getShowKeyCols();
            HashSet<String> balCols = new HashSet<String>();
            for (String keyCol : showKeyCols) {
                String balCol = (String)repoColSrcColMap.get(keyCol);
                if (balCol == null) continue;
                balCols.add(balCol);
            }
            BalanceTB tb = BalanceTB.getBalanceTB((String)"im_inv_realbalance");
            if (balCols.containsAll(tb.getColsByDataType(new BizDataType[]{BizDataType.DIM}))) {
                ctx.setGroupPlans(null);
            }
        }
    }

    public void transFormAfterGroup(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        AddMaterialGroup addMaterialGroup = new AddMaterialGroup(ctx, this.rptParam);
        addMaterialGroup.setRepoMaterialCol("materialgroup");
        addMaterialGroup.setRepoMaterialCol("material");
        transCollector.add(addMaterialGroup);
        transCollector.add(new CalShelfLifeCols(ctx));
    }
}

