/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.algox.shelflife.func;

import java.util.Calendar;
import java.util.Date;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.scmc.im.report.algox.util.RptUtil;

public class CalShelfLifeDaysMapFunc
extends MapFunction {
    private static final long serialVersionUID = -4710823669021765102L;
    private RowMeta rowMeta;
    private int[] indexs;
    private Date now;
    private Date tommorrow;
    private boolean handleIsWarnCol;
    private Calendar calendar;

    public CalShelfLifeDaysMapFunc(RowMeta rowMeta, boolean handleIsWarnCol) {
        this.rowMeta = rowMeta;
        this.handleIsWarnCol = handleIsWarnCol;
        this.indexs = new int[handleIsWarnCol ? 7 : 5];
        this.indexs[0] = rowMeta.getFieldIndex("producedate");
        this.indexs[1] = rowMeta.getFieldIndex("expirydate");
        this.indexs[2] = rowMeta.getFieldIndex("shelflifedays");
        this.indexs[3] = rowMeta.getFieldIndex("expirydays");
        this.indexs[4] = rowMeta.getFieldIndex("iswarn");
        if (handleIsWarnCol) {
            this.indexs[5] = rowMeta.getFieldIndex("r_warnleadtime");
            this.indexs[6] = rowMeta.getFieldIndex("r_leadtimeunit");
        }
        this.calendar = Calendar.getInstance();
        this.now = RptUtil.getShortDate(new Date());
        this.tommorrow = RptUtil.getShortDate(this.now, 1);
        this.handleIsWarnCol = handleIsWarnCol;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public RowX map(RowX row) {
        String unit;
        Date produceDate = row.getDate(this.indexs[0]);
        Date expiryDate = row.getDate(this.indexs[1]);
        int shelfLifeDays = RptUtil.calBetweenDays(produceDate, expiryDate);
        int expiryDays = RptUtil.calBetweenDays(expiryDate, this.now);
        row.set(this.indexs[2], (Object)shelfLifeDays);
        row.set(this.indexs[3], (Object)expiryDays);
        if (this.handleIsWarnCol && expiryDays <= 0 && (unit = row.getString(this.indexs[6])) != null) {
            int time = -row.getInteger(this.indexs[5]).intValue();
            this.calendar.setTime(expiryDate);
            if ("day".equals(unit)) {
                this.calendar.add(6, time);
            } else if ("month".equals(unit)) {
                this.calendar.add(2, time);
            } else if ("year".equals(unit)) {
                this.calendar.add(1, time);
            } else {
                this.calendar.setTime(this.tommorrow);
            }
            if (this.calendar.getTimeInMillis() < this.tommorrow.getTime()) {
                row.set(this.indexs[4], (Object)"1");
            }
        }
        return row;
    }
}

