/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.algox.shelflife.func;

import java.util.Set;
import kd.bos.algo.RowMeta;
import kd.bos.algox.FilterFunction;
import kd.bos.algox.RowX;
import kd.scmc.im.report.algox.shelflife.ShelfLifeRptParam;

public class LifeDaysFilterFunc
extends FilterFunction {
    private static final long serialVersionUID = -8794960776514696301L;
    private Integer[] shelfLifeRange;
    private Integer[] expiryRange;
    private int[] indexs;

    public LifeDaysFilterFunc(RowMeta rowMeta, ShelfLifeRptParam rptParam) {
        this.shelfLifeRange = rptParam.getShelfLifeRange();
        this.expiryRange = rptParam.getExpiryRange();
        Set<String> expireDisplay = rptParam.getExpireDisplay();
        if (expireDisplay != null) {
            if (expireDisplay.contains("0") && !expireDisplay.contains("1")) {
                Integer zero = 0;
                this.expiryRange[0] = this.expiryRange[0] == null ? zero : (this.expiryRange[0] > 0 ? this.expiryRange[0] : zero);
            } else if (!expireDisplay.contains("0") && expireDisplay.contains("1")) {
                Integer negateOne = -1;
                this.expiryRange[1] = this.expiryRange[1] == null ? negateOne : (this.expiryRange[1] > -1 ? negateOne : this.expiryRange[1]);
            }
        }
        this.indexs = new int[2];
        this.indexs[0] = this.shelfLifeRange[0] != null || this.shelfLifeRange[1] != null ? rowMeta.getFieldIndex("shelflifedays", false) : -1;
        this.indexs[1] = this.expiryRange[0] != null || this.expiryRange[1] != null ? rowMeta.getFieldIndex("expirydays", false) : -1;
    }

    public boolean test(RowX row) {
        return this.checkRange(row, this.indexs[0], this.shelfLifeRange) && this.checkRange(row, this.indexs[1], this.expiryRange);
    }

    private boolean checkRange(RowX row, int index, Integer[] range) {
        if (index < 0) {
            return true;
        }
        int val = row.getInteger(index);
        if (range[0] != null && range[0] > val) {
            return false;
        }
        return range[1] == null || range[1] >= val;
    }
}

