/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.algox.shelflife.trans;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.algox.DataSetX;
import kd.bos.algox.FilterFunction;
import kd.bos.algox.MapFunction;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.scmc.im.report.algox.shelflife.ShelfLifeRptParam;
import kd.scmc.im.report.algox.shelflife.func.CalShelfLifeDaysMapFunc;
import kd.scmc.im.report.algox.shelflife.func.LifeDaysFilterFunc;

public class CalShelfLifeCols
implements IDataXTransform {
    private static final String INV_MT = "bd_materialinventoryinfo";
    private static final String INV_MT_IS_WARN = "enablewarnlead";
    private static final String INV_MT_WARN_DAYS = "warnleadtime";
    public static final String R_ORG = "r_org";
    public static final String R_MATERIAL = "r_masterid";
    public static final String R_WARN_LEAD_TIME = "r_warnleadtime";
    public static final String R_WARN_LEAD_UNIT = "r_leadtimeunit";
    private ReportDataCtx ctx;
    private ShelfLifeRptParam rptParam;
    private static final String[] INV_MT_COLS = new String[]{"#useorg# r_org", "masterid r_masterid", "warnleadtime r_warnleadtime", "leadtimeunit r_leadtimeunit"};

    public CalShelfLifeCols(ReportDataCtx ctx) {
        this.ctx = ctx;
        this.rptParam = (ShelfLifeRptParam)ctx.getParam(ShelfLifeRptParam.class.getName());
    }

    private DataSetX buildMateriaWarnData() {
        List<Long> orgIds = this.rptParam.getOrgs();
        if (orgIds == null || orgIds.isEmpty()) {
            return null;
        }
        QFilter fs = new QFilter(INV_MT_IS_WARN, "=", (Object)"1");
        fs.and(INV_MT_WARN_DAYS, ">", (Object)0);
        ArrayList<OrmInput> inputs = new ArrayList<OrmInput>(orgIds.size());
        RowMeta rowMeta = ORM.create().createRowMeta(INV_MT, "org r_org,masterid r_masterid,warnleadtime r_warnleadtime,leadtimeunit r_leadtimeunit");
        String selectFields = String.join((CharSequence)",", INV_MT_COLS);
        QFilter rangeFs = null;
        for (Long orgId : orgIds) {
            rangeFs = BaseDataServiceHelper.getBaseDataFilter((String)INV_MT, (Long)orgId);
            String tmpSelectFields = selectFields.replace("#useorg#", orgId.toString());
            inputs.add(new OrmInput("CalShelfLifeCols", INV_MT, tmpSelectFields, rangeFs == null ? fs.toArray() : rangeFs.and(fs).toArray(), rowMeta));
        }
        DataSetX result = this.ctx.getCurrentJob().fromInput((Input[])inputs.toArray(new OrmInput[0]));
        return result;
    }

    public DataSetX doTransform(DataSetX srcData) {
        DataSetX warnData;
        boolean handleIsWarnCol;
        RowMeta rowMeta = srcData.getRowMeta();
        boolean bl = handleIsWarnCol = rowMeta.getFieldIndex("org", false) >= 0 && rowMeta.getFieldIndex("material", false) >= 0;
        if (handleIsWarnCol && (warnData = this.buildMateriaWarnData()) != null) {
            srcData = srcData.leftJoin(warnData).on("org", R_ORG).on("material", R_MATERIAL);
        }
        srcData = srcData.addFields(new Field[]{new Field("shelflifedays", (DataType)DataType.IntegerType), new Field("expirydays", (DataType)DataType.IntegerType), new Field("iswarn", (DataType)DataType.StringType)}, new Object[]{0, 0, "0"});
        srcData = srcData.map((MapFunction)new CalShelfLifeDaysMapFunc(srcData.getRowMeta(), handleIsWarnCol));
        srcData = srcData.filter((FilterFunction)new LifeDaysFilterFunc(srcData.getRowMeta(), this.rptParam));
        if (handleIsWarnCol) {
            srcData = srcData.removeFields(new String[]{R_ORG, R_MATERIAL, R_WARN_LEAD_TIME, R_WARN_LEAD_UNIT});
        }
        return srcData;
    }
}

