/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.algox.sum;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bplat.scmc.report.util.ReportUtil;
import kd.scmc.im.business.helper.AuxptyFilterHelper;
import kd.scmc.im.report.algox.detail.OpenDetailParam;
import kd.scmc.im.report.algox.sum.SumRptParam;
import kd.scmc.im.report.algox.util.RptForm;
import kd.scmc.im.report.algox.util.RptUtil;
import org.apache.commons.lang3.time.DateUtils;

public final class SumRptForm
extends AbstractReportFormPlugin
implements BeforeF7SelectListener,
HyperLinkClickListener,
BeforeFilterF7SelectListener {
    private RptForm localRptForm;

    public void hyperLinkClick(HyperLinkClickEvent e) {
        String key = e.getFieldName();
        if ("material".equals(key)) {
            this.showDetailRpt(e);
        }
    }

    private void showDetailRpt(HyperLinkClickEvent e) {
        ReportShowParameter rsp = new ReportShowParameter();
        rsp.setFormId("im_detail_rpt");
        rsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        OpenDetailParam param = this.buildOpenDetailParam(e);
        rsp.setCustomParam(OpenDetailParam.class.getName(), (Object)SerializationUtils.toJsonString((Object)param));
        this.getView().showForm((FormShowParameter)rsp);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.getRptForm().register((Object)this);
        ReportList reportlist = (ReportList)this.getView().getControl("reportlistap");
        reportlist.addHyperClickListener((HyperLinkClickListener)this);
    }

    private RptForm getRptForm() {
        if (this.localRptForm == null) {
            this.localRptForm = new RptForm(this.getView());
        }
        return this.localRptForm;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getRptForm().initPage(this.getRemoveFilterGridCols());
        this.initQueryDate();
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        AuxptyFilterHelper.setAuxEntryEnable((IDataModel)this.getModel(), (IFormView)this.getView());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getRptForm().changeContainLowerGrp();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        this.getRptForm().propertyChanged(e);
    }

    public void beforeF7Select(BeforeF7SelectEvent f7) {
        this.getRptForm().beforeF7Select(f7);
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent f7) {
        this.getRptForm().beforeF7Select(f7, this.getModel());
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        IReportView view = this.getView();
        if (RptUtil.isNull(view, "invorg") || RptUtil.isNull(view, "startdate") || RptUtil.isNull(view, "enddate") || RptUtil.isNull(view, "groupstandard")) {
            return false;
        }
        if (!this.getRptForm().checkDataCtrl()) {
            return false;
        }
        DynamicObject data = this.getModel().getDataEntity();
        Date startDate = data.getDate("startdate");
        Date enddate = data.getDate("enddate");
        if (enddate.before(startDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u5e94\u665a\u4e8e\u5f00\u59cb\u65e5\u671f\u3002", (String)"SumRptForm_0", (String)"scmc-im-report", (Object[])new Object[0]));
            return false;
        }
        this.buildReportParms();
        return true;
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        List<Long> warehouseIds = this.getRptForm().warehouseBeforeQuery(queryParam, this.getModel(), "im_sum_rpt");
        SumRptParam rptParam = (SumRptParam)queryParam.getCustomParam().get(SumRptParam.class.getName());
        rptParam.setWareHouseIds(warehouseIds);
    }

    private OpenDetailParam buildOpenDetailParam(HyperLinkClickEvent e) {
        OpenDetailParam param = new OpenDetailParam();
        RptForm RptForm2 = this.getRptForm();
        param.setOrgId(RptForm2.getOrgIds());
        DynamicObject data = this.getModel().getDataEntity();
        param.setDateFrom(data.getDate("startdate"));
        param.setDateTo(data.getDate("enddate"));
        param.setGroupStandard(data.getDynamicObject("groupstandard").getLong("id"));
        param.setGroupFrom(RptUtil.getBaseDataObjIds(this.getView(), "groupfrom"));
        DynamicObject baseData = data.getDynamicObject("groupto");
        if (baseData != null) {
            param.setGroupTo(baseData.getPkValue());
        }
        param.setMaterialFrom(RptUtil.getBaseDataObjIds(this.getView(), "materialfrom"));
        baseData = data.getDynamicObject("materialto");
        if (baseData != null) {
            param.setMaterialTo(baseData.getPkValue());
        }
        param.setMaterialType(data.getString("materialtype"));
        param.setShowQtys(data.getString("showqtycols"));
        param.setIncludeSubmit(data.getBoolean("include_submit"));
        param.setIncludeUnupdate(data.getBoolean("include_unupdate"));
        param.setIncludeInQty(data.getBoolean("display_in"));
        param.setIncludeOutQty(data.getBoolean("display_out"));
        param.setIncludeInitBalQty(data.getBoolean("display_init_bal"));
        FilterGrid grid = (FilterGrid)this.getControl("commonfs");
        FilterCondition condition = grid.getFilterGridState().getFilterCondition();
        param.setCondition(condition);
        this.reBuildReportParms(param, e);
        return param;
    }

    private void reBuildReportParms(OpenDetailParam param, HyperLinkClickEvent e) {
        DynamicObject material;
        Object id;
        DynamicObject group;
        DynamicObject org;
        ReportList reportList = (ReportList)e.getSource();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(e.getRowIndex());
        String lineType = rowData.getString("linetype");
        Set dimCols = null;
        dimCols = lineType == null || "0".equals(lineType) ? ReportUtil.parseCombColVal((IDataModel)this.getModel(), (String)"showkeycols") : ("1".equals(lineType) ? ReportUtil.parseCombColVal((IDataModel)this.getModel(), (String)"sumkeycols") : Collections.emptySet());
        if (dimCols.remove("org") && (org = rowData.getDynamicObject("org")) != null) {
            List<Long> orgId = param.getOrgId();
            orgId.clear();
            orgId.add(org.getLong("id"));
        }
        if (dimCols.remove("materialgroup") && (group = rowData.getDynamicObject("materialgroup")) != null) {
            List<Object> groupIds = param.getGroupFrom();
            groupIds.clear();
            id = group.getPkValue();
            groupIds.add(id);
            param.setGroupTo(id);
        }
        if (dimCols.remove("material") && (material = rowData.getDynamicObject("material")) != null) {
            List<Object> materialIds = param.getMaterialFrom();
            materialIds.clear();
            id = material.getPkValue();
            materialIds.add(id);
            param.setMaterialTo(id);
        }
        if (dimCols.remove("auxpty")) {
            DynamicObject auxpty = rowData.getDynamicObject("auxpty");
            if (auxpty != null) {
                param.setAuxptyId(auxpty.getLong("id"));
            }
            param.setAuxptyInfos(null);
        } else {
            param.setAuxptyId(null);
            param.setAuxptyInfos(this.getAuxptyInfos());
        }
        FilterGrid grid = (FilterGrid)this.getControl("commonfs");
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)grid.getEntityNumber());
        FilterCondition condition = param.getCondition();
        Object obj = null;
        IDataEntityProperty pro = null;
        SimpleFilterRow filterRow = null;
        String dimColName = null;
        boolean isBaseData = false;
        for (String dimCol : dimCols) {
            filterRow = new SimpleFilterRow();
            filterRow.setLogic("0");
            obj = rowData.get(dimCol);
            pro = type.findProperty(dimCol);
            if (pro instanceof FlexProp) continue;
            isBaseData = pro instanceof BasedataProp;
            String string = dimColName = isBaseData ? dimCol + ".number" : dimCol;
            if (obj == null) {
                filterRow.setFieldName(dimColName);
                filterRow.setCompareType(this.getIsNull(pro));
            } else {
                filterRow.setFieldName(dimColName);
                filterRow.setCompareType(this.getEqual(pro));
                ArrayList<FilterValue> vals = new ArrayList<FilterValue>(1);
                FilterValue fVal = new FilterValue();
                Object val = rowData.get(dimColName);
                if (pro instanceof DateTimeProp && val instanceof Date) {
                    val = ((DateTimeProp)pro).getDateFormat().format((Date)val);
                }
                fVal.setValue(val);
                vals.add(fVal);
                filterRow.setValue(vals);
            }
            condition.getFilterRow().add(filterRow);
        }
    }

    private String getIsNull(IDataEntityProperty pro) {
        if (pro instanceof ItemClassProp) {
            return CompareTypeEnum.ITEMCLASSISNULL.getId();
        }
        if (pro instanceof ItemClassTypeProp) {
            return CompareTypeEnum.COMBOBOXISNULL.getId();
        }
        return CompareTypeEnum.ISNULL.getId();
    }

    private String getEqual(IDataEntityProperty pro) {
        if (pro instanceof ItemClassProp) {
            return CompareTypeEnum.ITEMCLASSEQUALS.getId();
        }
        if (pro instanceof ItemClassTypeProp) {
            return CompareTypeEnum.CHECKBOXEQUAL.getId();
        }
        return CompareTypeEnum.EQUAL.getId();
    }

    private List<Map<String, Object>> getAuxptyInfos() {
        DynamicObjectCollection entry = this.getModel().getEntryEntity("auxentry");
        ArrayList<Map<String, Object>> infos = new ArrayList<Map<String, Object>>(entry.size());
        HashMap<String, Object> info = null;
        DynamicObject auxproperty = null;
        for (DynamicObject row : entry) {
            info = new HashMap<String, Object>(8);
            auxproperty = row.getDynamicObject("auxproperty");
            info.put("auxproperty", auxproperty == null ? null : auxproperty.getPkValue());
            info.put("auxdetailbasebd", row.getString("auxdetailbasebd"));
            info.put("auxdetailbasebdid", row.getString("auxdetailbasebdid"));
            info.put("auxdetailtxt", row.getString("auxdetailtxt"));
            List baseDataIds = RptUtil.getBaseDataIds(row.getDynamicObjectCollection("auxdetailbd"));
            info.put("auxdetailbd", baseDataIds == null ? null : JSON.toJSONString(baseDataIds));
            infos.add(info);
        }
        return infos;
    }

    private SumRptParam buildReportParms() {
        IDataModel model = this.getModel();
        ReportQueryParam param = this.getQueryParam();
        SumRptParam reportParam = new SumRptParam();
        DynamicObject data = model.getDataEntity();
        HashMap<Object, String> receiverMap = new HashMap<Object, String>();
        DynamicObjectCollection receivers = data.getDynamicObjectCollection("showreceiver");
        DynamicObject receiver = null;
        for (DynamicObject baseData : receivers) {
            receiver = baseData.getDynamicObject("fbasedataid");
            receiverMap.put(receiver.getPkValue(), receiver.getString("name"));
        }
        RptForm RptForm2 = this.getRptForm();
        RptForm2.buildRptParam(reportParam);
        reportParam.setReceiverTypeIds(receiverMap);
        Set fixdReceiverTypes = ReportUtil.parseCombColVal((IDataModel)model, (String)"showspecialbill");
        reportParam.setFixdReceiverType(this.parseFixedReceiverTypes(fixdReceiverTypes));
        reportParam.setShowInQty(data.getBoolean("display_in"));
        reportParam.setShowOutQty(data.getBoolean("display_out"));
        boolean displayInitBal = data.getBoolean("display_init_bal");
        reportParam.setShowInitAndBalQty(displayInitBal);
        reportParam.setIncludeSubmitStatus(data.getBoolean("include_submit"));
        reportParam.setIncludeUnUpdateBal(data.getBoolean("include_unupdate"));
        reportParam.setOnlyShowRowCount(data.getBoolean("onlyshowrowcount"));
        Date fromDate = RptUtil.getShortDate(data.getDate("startdate"));
        reportParam.setFromDate(fromDate);
        Date toDate = RptUtil.getShortDate(data.getDate("enddate"), 1);
        reportParam.setToDate(toDate);
        reportParam.setBillFromDate(displayInitBal ? RptUtil.getFirstDateOfMonth(fromDate) : fromDate);
        reportParam.setQtyFilters(ReportUtil.parseCombColVal((IDataModel)model, (String)"qtydisplay"));
        param.getCustomParam().put(SumRptParam.class.getName(), reportParam);
        return reportParam;
    }

    private Map<Object, String> parseFixedReceiverTypes(Set<String> fixdReceiverTypes) {
        HashMap<Object, String> types = new HashMap<Object, String>();
        ComboEdit edit = (ComboEdit)this.getView().getControl("showspecialbill");
        ComboProp pro = (ComboProp)edit.getProperty();
        List items = pro.getComboItems();
        String value = null;
        for (ValueMapItem item : items) {
            value = item.getValue();
            if (!fixdReceiverTypes.contains(value)) continue;
            types.put(Long.valueOf(value), item.getName().getLocaleValue());
        }
        return types;
    }

    private void initQueryDate() {
        IDataModel model = this.getModel();
        Date now = new Date();
        model.setValue("enddate", (Object)now);
        model.setValue("startdate", (Object)DateUtils.addDays((Date)now, (int)-6));
    }

    private Set<String> getRemoveFilterGridCols() {
        HashSet<String> removedPros = new HashSet<String>();
        removedPros.add("biztime");
        removedPros.add("status");
        removedPros.add("isupdatebal");
        removedPros.add("datatype");
        removedPros.add("transceivertype");
        removedPros.add("materialmasterid");
        return removedPros;
    }

    public void loadOtherEntryFilter(DynamicObject scheme) {
        super.loadOtherEntryFilter(scheme);
        this.getRptForm().loadOtherEntryFilter(scheme);
    }

    public void setOtherEntryFilter(FilterInfo filterInfo) {
        this.getRptForm().saveEntryFilter("auxentry");
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        this.getRptForm().closedCallBack(evt);
    }

    public void click(EventObject evt) {
        this.getRptForm().click(evt, (IFormPlugin)this);
    }
}

