/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.algox.sum.func;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.util.TransformUtil;
import kd.scmc.im.report.algox.sum.SumRptParam;
import kd.scmc.im.report.algox.util.RptUtil;

public class MoveQtyColMapFunc
extends MapFunction {
    private static final long serialVersionUID = 7818525601753830755L;
    private Set<Object> receiverIds;
    private RowMeta rowMeta;
    private Map<String, Integer> indexs;
    private SumRptParam params;
    private Set<String> showQtyCols;
    private boolean hasTransceiverType;

    public MoveQtyColMapFunc(RowMeta rowMeta, SumRptParam reportParam, ReportDataCtx ctx) {
        this.rowMeta = rowMeta;
        this.showQtyCols = ctx.getShowQtyCols();
        this.receiverIds = new HashSet<Object>(reportParam.getReceiverType().keySet());
        this.receiverIds.addAll(reportParam.getFixdReceiverType().keySet());
        this.params = reportParam;
        this.buildIndexs();
    }

    private void buildIndexs() {
        int receiverIdCount = this.receiverIds.size();
        int numColCount = this.showQtyCols.size();
        this.indexs = new HashMap<String, Integer>();
        ArrayList<String> cols = new ArrayList<String>(receiverIdCount * numColCount + numColCount * 3 + 3);
        cols.add("biztime");
        cols.add("datatype");
        if (receiverIdCount > 0) {
            cols.add("transceivertype");
            this.hasTransceiverType = true;
        }
        RptUtil.buildQtyCols(cols, this.showQtyCols, this.receiverIds);
        this.indexs = TransformUtil.buildIndexs((RowMeta)this.rowMeta, cols);
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    private void transQtyNegate(RowX row) {
        int index = -1;
        for (String sumNumCol : this.showQtyCols) {
            index = this.indexs.get(sumNumCol);
            row.set(index, (Object)row.getBigDecimal(index).negate());
        }
    }

    public RowX map(RowX row) {
        String type = row.getString(this.indexs.get("datatype").intValue());
        if ("2".equals(type)) {
            return row;
        }
        Date bizDate = row.getDate(this.indexs.get("biztime").intValue());
        boolean isOutQty = "1".equals(type);
        if (bizDate.before(this.params.getFromDate())) {
            if (isOutQty) {
                this.transQtyNegate(row);
            }
        } else {
            this.moveQty(row, isOutQty ? "_out" : "_in");
        }
        return row;
    }

    private void moveQty(RowX row, String suffix) {
        int fromIdx = -1;
        int toIdx = -1;
        BigDecimal qty = null;
        int transceiverTypeIdx = -1;
        Object transceiverTypeId = null;
        for (String sumNumCol : this.showQtyCols) {
            fromIdx = this.indexs.get(sumNumCol);
            qty = row.getBigDecimal(fromIdx);
            toIdx = this.indexs.get(sumNumCol + suffix);
            row.set(toIdx, (Object)qty);
            if (this.hasTransceiverType && this.receiverIds.contains(transceiverTypeId = row.get(transceiverTypeIdx = this.indexs.get("transceivertype").intValue()))) {
                toIdx = this.indexs.get(sumNumCol + transceiverTypeId);
                row.set(toIdx, (Object)qty);
            }
            row.set(fromIdx, (Object)BigDecimal.ZERO);
        }
    }
}

