/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.algox.sum.func;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.algox.FilterFunction;
import kd.bos.algox.RowX;

public class QtyFilterFunc
extends FilterFunction {
    private static final long serialVersionUID = -6878240865339450390L;
    private String[] filters;
    private List<int[]> idxList;

    public QtyFilterFunc(List<int[]> idxList, String[] filters) {
        this.filters = filters;
        this.idxList = idxList;
    }

    public boolean test(RowX rowX) {
        boolean isShow = true;
        for (int i = 0; i < this.filters.length; ++i) {
            switch (this.filters[i]) {
                case "1": 
                case "2": 
                case "3": 
                case "4": 
                case "5": {
                    isShow = isShow && this.notShowZero(rowX, this.idxList.get(i));
                    break;
                }
                case "6": {
                    isShow = isShow && this.onlyShowZero(rowX, this.idxList.get(i));
                    break;
                }
                case "7": {
                    isShow = isShow && this.showNegative(rowX, this.idxList.get(i));
                    break;
                }
            }
            if (isShow) continue;
            return isShow;
        }
        return isShow;
    }

    private boolean notShowZero(RowX rowX, int[] qtyIdxs) {
        boolean isShow = false;
        for (int i : qtyIdxs) {
            boolean bl = isShow = isShow || rowX.getBigDecimal(i).compareTo(BigDecimal.ZERO) != 0;
            if (!isShow) continue;
            return isShow;
        }
        return isShow;
    }

    private boolean onlyShowZero(RowX rowX, int[] qtyIdxs) {
        boolean isShow = true;
        for (int i : qtyIdxs) {
            boolean bl = isShow = isShow && rowX.getBigDecimal(i).compareTo(BigDecimal.ZERO) == 0;
            if (isShow) continue;
            return isShow;
        }
        return isShow;
    }

    private boolean showNegative(RowX rowX, int[] qtyIdxs) {
        boolean isShow = false;
        for (int i : qtyIdxs) {
            boolean bl = isShow = isShow || rowX.getBigDecimal(i).compareTo(BigDecimal.ZERO) < 0;
            if (!isShow) continue;
            return isShow;
        }
        return isShow;
    }
}

