/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.algox.sum.trans;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algox.DataSetX;
import kd.bos.algox.MapFunction;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.scmc.im.report.algox.sum.SumRptParam;
import kd.scmc.im.report.algox.sum.func.MoveQtyColMapFunc;

public class HandleCols4BigTable
implements IDataXTransform {
    private ReportDataCtx ctx;
    private Set<String> showQtyCols;
    private Set<Object> receiverTypeIds;
    private SumRptParam reportParam;

    public HandleCols4BigTable(ReportDataCtx ctx) {
        this.ctx = ctx;
        this.showQtyCols = ctx.getShowQtyCols();
        this.reportParam = (SumRptParam)ctx.getParam(SumRptParam.class.getName());
        HashMap<Object, String> receiverTypes = new HashMap<Object, String>(this.reportParam.getReceiverType());
        receiverTypes.putAll(this.reportParam.getFixdReceiverType());
        this.receiverTypeIds = receiverTypes.keySet();
    }

    public DataSetX doTransform(DataSetX srcData) {
        srcData = this.fillingQtyCols(srcData);
        srcData = srcData.map((MapFunction)new MoveQtyColMapFunc(srcData.getRowMeta(), this.reportParam, this.ctx));
        return srcData;
    }

    private DataSetX fillingQtyCols(DataSetX srcData) {
        int size = this.showQtyCols.size() * (this.receiverTypeIds.size() + 2);
        ArrayList<Field> fields = new ArrayList<Field>(size);
        ArrayList<BigDecimal> vals = new ArrayList<BigDecimal>(size);
        for (String qtyCol : this.showQtyCols) {
            fields.add(new Field(qtyCol + "_in", (DataType)DataType.BigDecimalType));
            vals.add(BigDecimal.ZERO);
            fields.add(new Field(qtyCol + "_out", (DataType)DataType.BigDecimalType));
            vals.add(BigDecimal.ZERO);
            fields.add(new Field(qtyCol + "_bal", (DataType)DataType.BigDecimalType));
            vals.add(BigDecimal.ZERO);
            for (Object typeId : this.receiverTypeIds) {
                fields.add(new Field(qtyCol + typeId, (DataType)DataType.BigDecimalType));
                vals.add(BigDecimal.ZERO);
            }
        }
        return srcData.addFields(fields.toArray(new Field[0]), vals.toArray());
    }

    public String toString() {
        return "HandleCols4BigTable [showQtyCols=" + this.showQtyCols + ", receiverTypeIds=" + this.receiverTypeIds + ", reportParam=" + this.reportParam + "]";
    }
}

