/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.algox.util;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.bplat.scmc.report.common.QueryParam;
import kd.bplat.scmc.report.conf.ReportConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.ReportDataHandle;
import kd.bplat.scmc.report.util.ReportQuery;
import kd.bplat.scmc.report.util.ReportUtil;
import kd.scmc.im.report.algox.sum.SumRptParam;
import kd.scmc.im.report.algox.util.ReqParam;
import kd.scmc.im.report.algox.util.RptUtil;
import kd.scmc.im.utils.DateUtils;

public class ImReportQueryHelper {
    private static final String IM_SUM_RPT = "im_sum_rpt";

    private ImReportQueryHelper() {
    }

    public static DataSet query(ReqParam param) {
        ImReportQueryHelper.validate(param);
        QueryParam queryParam = ImReportQueryHelper.buildSumQueryParam(param);
        ReportDataCtx ctx = ReportQuery.buildReportDataCtx((QueryParam)queryParam);
        return ReportQuery.queryData((ReportDataCtx)ctx);
    }

    private static void validate(ReqParam param) {
        if (param == null || CollectionUtils.isEmpty(param.orgIds)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8f93\u5165\u7684[{0}]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"ImReportQueryHelper_0", (String)"scmc-im-report", (Object[])new Object[]{"orgIds"}));
        }
        if (StringUtils.isEmpty((String)param.beginDate)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8f93\u5165\u7684[{0}]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"ImReportQueryHelper_0", (String)"scmc-im-report", (Object[])new Object[]{"beginDate"}));
        }
        if (StringUtils.isEmpty((String)param.getEndDate())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8f93\u5165\u7684[{0}]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"ImReportQueryHelper_0", (String)"scmc-im-report", (Object[])new Object[]{"endDate"}));
        }
    }

    private static QueryParam buildSumQueryParam(ReqParam param) {
        QueryParam queryParam = new QueryParam();
        DynamicObject confModel = StringUtils.isNotEmpty((String)param.getConfNo()) ? ImReportQueryHelper.loadConfModel(param.getConfNo()) : ReportDataHandle.loadConfModel((String)IM_SUM_RPT);
        queryParam.setConf(confModel);
        queryParam.setCommonFs(param.qFilter);
        ReportConf reportConf = ReportDataHandle.loadReportConf((DynamicObject)confModel);
        Set allQtyCols = ReportUtil.filterBigtableCols((ReportConf)reportConf, colConf -> "B".equals(colConf.getCalType()));
        Set allKeyCols = ReportUtil.filterBigtableCols((ReportConf)reportConf, colConf -> "A".equals(colConf.getCalType()));
        queryParam.setShowKeyCols(allKeyCols);
        queryParam.setShowQtyCols(allQtyCols);
        queryParam.setSumKeyCols(new HashSet());
        queryParam.setShowTotalQty(false);
        SumRptParam sumRptParam = new SumRptParam();
        sumRptParam.setOrgs(param.getOrgIds());
        sumRptParam.setFromDate(DateUtils.parseDate((String)param.getBeginDate()));
        sumRptParam.setToDate(RptUtil.getShortDate(DateUtils.parseDate((String)param.getEndDate()), 1));
        sumRptParam.setBillFromDate(ImReportQueryHelper.getFirstDateOfMonth(sumRptParam.getFromDate()));
        sumRptParam.setReceiverTypeIds(new HashMap<Object, String>());
        sumRptParam.setFixdReceiverType(new HashMap<Object, String>());
        sumRptParam.setMaterialtypes(new HashSet<String>());
        sumRptParam.setOnlyMaterialIdFs(false);
        sumRptParam.setMaterialFs(null);
        sumRptParam.setHeadFilters(new ArrayList<QFilter>());
        sumRptParam.setQtyFilters(new ArrayList<String>());
        sumRptParam.setDefStander(true);
        HashMap<String, Object> customerParam = new HashMap<String, Object>();
        customerParam.put(SumRptParam.class.getName(), sumRptParam);
        customerParam.put("report", IM_SUM_RPT);
        queryParam.setCustomParam(customerParam);
        return queryParam;
    }

    private static Date getFirstDateOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public static DynamicObject loadConfModel(String confNo) {
        QFilter fs = new QFilter("number", "=", (Object)confNo).and("status", "=", (Object)"1");
        Map confInfo = BusinessDataReader.loadFromCache((String)"scmc_report_conf", (QFilter[])fs.toArray());
        if (!confInfo.isEmpty()) {
            DynamicObject[] cfs = confInfo.values().toArray(new DynamicObject[0]);
            return cfs[0];
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u672a\u8bfb\u53d6\u5230\u542f\u7528\u7684\u62a5\u8868\u914d\u7f6e", (String)"ReportDataHandle_1", (String)"mpscmm-mscommon-report", (Object[])new Object[0]));
    }
}

