/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.algox.util.trans;

import kd.bos.algo.Input;
import kd.bos.algo.input.OrmInput;
import kd.bos.algox.DataSetX;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.scmc.im.report.algox.util.RptParam;

public class AddMaterialGroup
implements IDataXTransform {
    private ReportDataCtx ctx;
    private RptParam reportParam;
    private String repoMaterialGroupCol = "materialgroup";
    private String repoMaterialCol = "material";

    public void setRepoMaterialGroupCol(String repoMaterialGroupCol) {
        this.repoMaterialGroupCol = repoMaterialGroupCol;
    }

    public void setRepoMaterialCol(String repoMaterialCol) {
        this.repoMaterialCol = repoMaterialCol;
    }

    public AddMaterialGroup(ReportDataCtx ctx, RptParam reportParam) {
        this.ctx = ctx;
        this.reportParam = reportParam;
    }

    private boolean hasCol(DataSetX srcData, String col) {
        return srcData.getRowMeta().getField(col, false) != null;
    }

    public DataSetX doTransform(DataSetX srcData) {
        if (this.reportParam.isDefStander()) {
            return srcData;
        }
        if (!this.hasCol(srcData, this.repoMaterialCol)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f7f\u7528\u975e\u201c\u7269\u6599\u57fa\u672c\u5206\u7c7b\u6807\u51c6\u201d\u8fc7\u6ee4\u65f6\uff0c\u6c47\u603b\u4f9d\u636e\u4e2d\u5fc5\u987b\u9009\u4e2d\u201c\u7269\u6599\u201d\u3002", (String)"AddMaterialGroup_0", (String)"scmc-im-report", (Object[])new Object[0]));
        }
        boolean hasGroupCol = this.hasCol(srcData, this.repoMaterialGroupCol);
        if (hasGroupCol) {
            srcData = srcData.removeFields(new String[]{this.repoMaterialGroupCol});
        }
        String materialAlias = this.repoMaterialCol + "_left";
        StringBuilder selectCol = new StringBuilder(this.repoMaterialCol);
        selectCol.append(' ').append(materialAlias);
        if (hasGroupCol) {
            selectCol.append(',').append("group").append(' ').append(this.repoMaterialGroupCol);
        }
        OrmInput input = new OrmInput("AddMaterialGroup", "bd_materialgroupdetail", selectCol.toString(), this.reportParam.getMaterialGroupFs().toArray());
        DataSetX groupData = this.ctx.getCurrentJob().fromInput((Input)input);
        srcData = srcData.join(groupData).on(this.repoMaterialCol, materialAlias);
        srcData = srcData.removeFields(new String[]{materialAlias});
        return srcData;
    }

    public String toString() {
        return "AddMaterialGroup [reportParam=" + this.reportParam + "]";
    }
}

