/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.algox.util.trans;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bplat.scmc.report.util.TransformUtil;
import org.apache.commons.lang3.StringUtils;

class ReSetColMapFunc
extends MapFunction {
    private static final long serialVersionUID = -4869483132768872841L;
    private RowMeta rowMeta;
    private int flagColIdx;
    private Map<String, List<String>> colsMap;
    private Map<String, List<Integer>> rmColsIdx;

    public ReSetColMapFunc(RowMeta rowMeta, int flagColIdx, Map<String, List<String>> colsMap) {
        this.rowMeta = rowMeta;
        this.flagColIdx = flagColIdx;
        this.colsMap = colsMap;
        this.rmColsIdx = new HashMap<String, List<Integer>>(8);
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public RowX map(RowX rowX) {
        String rmCols = rowX.getString(this.flagColIdx);
        if (StringUtils.isBlank((CharSequence)rmCols)) {
            return rowX;
        }
        List<Integer> idxs = this.rmColsIdx.get(rmCols);
        if (idxs == null) {
            idxs = this.parseIdx(rmCols);
            this.rmColsIdx.put(rmCols, idxs);
        }
        for (int i : idxs) {
            if (i < 0) continue;
            rowX.set(i, TransformUtil.getDefVal((DataType)this.rowMeta.getDataType(i)));
        }
        return rowX;
    }

    private List<Integer> parseIdx(String rmCols) {
        Map updateInvFieldsMap = (Map)SerializationUtils.fromJsonString((String)rmCols, Map.class);
        List noUpdateFields = (List)updateInvFieldsMap.get("setnull");
        ArrayList<Integer> idxs = new ArrayList<Integer>(noUpdateFields.size());
        List<String> repoCols = null;
        for (String col : noUpdateFields) {
            repoCols = this.colsMap.get(col);
            if (repoCols == null) continue;
            for (String repoCol : repoCols) {
                idxs.add(this.rowMeta.getFieldIndex(repoCol, false));
            }
        }
        return idxs;
    }
}

