/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.analyse.base;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.scmc.im.business.helper.DataChangeHelper;
import kd.scmc.im.report.common.ReportCommonFilterOrChangeOp;

public class BaseAnalyseRptPropChanged {
    protected IFormView view = null;

    public BaseAnalyseRptPropChanged(IFormView view) {
        this.view = view;
    }

    protected void propertyChanged(PropertyChangedArgs e) {
        String key;
        Boolean triggerChangeEventLocal = (Boolean)DataChangeHelper.triggerChangeEventLocal.get();
        if (triggerChangeEventLocal != null && !triggerChangeEventLocal.booleanValue()) {
            return;
        }
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        Object oldValue = valueSet[0].getOldValue();
        switch (key = e.getProperty().getName()) {
            case "orghead": {
                this.handleOrgChangeEvent((DynamicObjectCollection)newValue, (DynamicObjectCollection)oldValue);
                break;
            }
            case "ownertypehead": {
                ReportCommonFilterOrChangeOp.handleOwnerTypeHeadChangeEvent(key, this.view);
                break;
            }
            case "accountownerfrom": 
            case "supplierownerfrom": 
            case "customerownerfrom": 
            case "materialgroupfrom": 
            case "warehousefrom": 
            case "locationfrom": 
            case "projectfrom": 
            case "materialnumberfrom": 
            case "configuredcodefrom": 
            case "tracknumberfrom": {
                this.handleMulBasedataChangeEvent(key);
                break;
            }
            case "materialgroupto": 
            case "warehouseto": 
            case "materialgroupstandard": {
                this.handleValueToNull(key);
                break;
            }
            case "lotnumberfrom": {
                ReportCommonFilterOrChangeOp.handlelotnumberfromChangeEvent(newValue, this.view);
                break;
            }
            case "lotnumberto": {
                ReportCommonFilterOrChangeOp.handlelotnumbertoChangeEvent(newValue, oldValue, this.view);
                break;
            }
        }
    }

    protected void handleOrgChangeEvent(DynamicObjectCollection newValue, DynamicObjectCollection oldValue) {
        ArrayList<Long> listOrgId;
        boolean isChanged = false;
        if (newValue != null && oldValue == null || newValue == null && oldValue != null) {
            isChanged = true;
        } else if (newValue != null && oldValue != null) {
            ArrayList<String> newOrgNums = new ArrayList<String>(10);
            ArrayList<String> oldOrgNums = new ArrayList<String>(10);
            for (DynamicObject newOrg : newValue) {
                String newOrgNum = newOrg.getDynamicObject(1).getString("number");
                newOrgNums.add(newOrgNum);
            }
            for (DynamicObject oldOrg : oldValue) {
                String oldOrgNum = oldOrg.getDynamicObject(1).getString("number");
                oldOrgNums.add(oldOrgNum);
            }
            boolean bl = isChanged = newOrgNums.size() != oldOrgNums.size() || !newOrgNums.containsAll(oldOrgNums);
        }
        if (!isChanged) {
            return;
        }
        IDataModel dataModel = this.getModel();
        if (newValue == null || newValue.size() == 0) {
            listOrgId = new ArrayList<Long>();
            for (DynamicObject dynamicObject : oldValue) {
                listOrgId.add(dynamicObject.getLong("fbasedataid_id"));
                dataModel.setValue("orghead", (Object)listOrgId.toArray());
            }
            return;
        }
        dataModel.beginInit();
        dataModel.createNewData();
        listOrgId = new ArrayList();
        for (DynamicObject dynamicObject : newValue) {
            listOrgId.add(dynamicObject.getLong("fbasedataid_id"));
        }
        dataModel.setValue("orghead", (Object)listOrgId.toArray());
        dataModel.endInit();
        this.view.setEnable(Boolean.TRUE, new String[]{"materialgroupto", "warehouseto", "locationto", "projectto", "materialnumberto", "auxptyto"});
        this.view.updateView();
    }

    protected void handleMulBasedataChangeEvent(String key) {
        String controlledControl = null;
        IDataModel dataModel = this.getModel();
        switch (key) {
            case "accountownerfrom": 
            case "supplierownerfrom": 
            case "customerownerfrom": {
                controlledControl = "ownerto";
                break;
            }
            case "materialgroupfrom": {
                controlledControl = "materialgroupto";
                break;
            }
            case "warehousefrom": {
                controlledControl = "warehouseto";
                break;
            }
            case "locationfrom": {
                controlledControl = "locationto";
                break;
            }
            case "projectfrom": {
                controlledControl = "projectto";
                break;
            }
            case "materialnumberfrom": {
                controlledControl = "materialnumberto";
                break;
            }
            case "auxptyfrom": {
                controlledControl = "auxptyto";
                break;
            }
            case "configuredcodefrom": {
                controlledControl = "configuredcodeto";
                break;
            }
            case "tracknumberfrom": {
                controlledControl = "tracknumberto";
                break;
            }
        }
        if (((DynamicObjectCollection)dataModel.getValue(key)).size() > 1) {
            this.view.setEnable(Boolean.FALSE, new String[]{controlledControl});
        } else {
            this.view.setEnable(Boolean.TRUE, new String[]{controlledControl});
        }
        this.handleValueToNull(key);
    }

    protected void handleValueToNull(String key) {
        IDataModel dataModel = this.getModel();
        switch (key) {
            case "accountownerfrom": 
            case "supplierownerfrom": 
            case "customerownerfrom": {
                dataModel.setValue("ownerto", null);
                break;
            }
            case "materialgroupstandard": {
                dataModel.setValue("materialgroupfrom", null);
                dataModel.setValue("materialgroupto", null);
                dataModel.setValue("materialnumberfrom", null);
                dataModel.setValue("materialnumberto", null);
                break;
            }
            case "materialgroupfrom": {
                dataModel.setValue("materialgroupto", null);
                dataModel.setValue("materialnumberfrom", null);
                dataModel.setValue("materialnumberto", null);
                break;
            }
            case "materialgroupto": {
                dataModel.setValue("materialnumberfrom", null);
                dataModel.setValue("materialnumberto", null);
                break;
            }
            case "materialnumberfrom": {
                DynamicObjectCollection materialNumberFrom = (DynamicObjectCollection)dataModel.getValue("materialnumberfrom");
                dataModel.setValue("materialnumberto", materialNumberFrom.size() == 1 ? ((DynamicObject)materialNumberFrom.get(0)).get("fbasedataid") : null);
                break;
            }
            case "warehousefrom": {
                dataModel.setValue("warehouseto", null);
                dataModel.setValue("locationfrom", null);
                dataModel.setValue("locationto", null);
                break;
            }
            case "warehouseto": {
                dataModel.setValue("locationfrom", null);
                dataModel.setValue("locationto", null);
                break;
            }
            case "locationfrom": {
                dataModel.setValue("locationto", null);
                break;
            }
            case "projectfrom": {
                dataModel.setValue("projectto", null);
                break;
            }
            case "configuredcodefrom": {
                dataModel.setValue("configuredcodeto", null);
                break;
            }
            case "tracknumberfrom": {
                dataModel.setValue("tracknumberto", null);
                break;
            }
            case "auxptyfrom": {
                dataModel.setValue("auxptyfrom", null);
                dataModel.setValue("auxptyto", null);
                break;
            }
        }
    }

    private IDataModel getModel() {
        return this.view.getModel();
    }
}

