/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.analyse.dullmaterial;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.FilterInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.business.balance.BalanceUpdateHandle;
import kd.scmc.im.report.analyse.base.AbstractAnalyseDetailRptQuery;
import kd.scmc.im.report.analyse.billparse.IInvBillAsAccParser;
import kd.scmc.im.report.analyse.billparse.InvBillAsAccParserFactory;
import kd.scmc.im.report.common.ReportCommonFilterOrChangeOp;
import kd.scmc.im.report.helper.AnalyseRptOpHelper;
import kd.scmc.im.utils.DateUtils;

public class DeadlineInvAccBuilder
extends AbstractAnalyseDetailRptQuery {
    private static String[] INV_BALC_DIMENSION_FIELDS = new String[]{"org", "producedate", "expirydate", "warehouse", "location", "ownertype", "owner", "keepertype", "keeper", "invstatus", "invtype", "material", "auxpty", "lotnumber", "project", "unit", "baseunit", "unit2nd"};
    private static String[] ACCREC_FIELDS = new String[]{"org", "producedate", "expirydate", "warehouse", "location", "ownertype", "owner", "keepertype", "keeper", "invstatus", "invtype", "material", "auxpty", "lotnumber", "project", "unit", "baseunit", "unit2nd", "qty", "baseqty", "qty2nd", "enddate"};
    private static String[] BILL_FIELDS = new String[]{"org", "producedate", "expirydate", "warehouse", "location", "ownertype", "owner", "keepertype", "keeper", "invstatus", "invtype", "material", "auxpty", "lotnumber", "project", "unit", "baseunit", "unit2nd", "qty", "baseqty", "qty2nd", "bookdate"};

    public static DataSet buildDeadlineInvAccDataSet(FilterInfo filterInfo) {
        DataSet beforeDeadlineAccSet = DeadlineInvAccBuilder.getBeforeDeadlineAccSet(filterInfo);
        DataSet billDataSet = DeadlineInvAccBuilder.getBillDataSetBeforeEndTime(filterInfo);
        String[] invBalcDimensionField = INV_BALC_DIMENSION_FIELDS;
        if (billDataSet == null) {
            if (beforeDeadlineAccSet != null) {
                beforeDeadlineAccSet = beforeDeadlineAccSet.removeFields(new String[]{"endperiod"}).groupBy(invBalcDimensionField).sum("qty").sum("baseqty").sum("qty2nd").finish();
            }
            return beforeDeadlineAccSet;
        }
        if (beforeDeadlineAccSet == null) {
            return billDataSet.groupBy(invBalcDimensionField).sum("qty").sum("baseqty").sum("qty2nd").finish();
        }
        billDataSet = billDataSet.groupBy(invBalcDimensionField).sum("qty").sum("baseqty").sum("qty2nd").finish();
        DataSet balanceDataSet = beforeDeadlineAccSet.removeFields(new String[]{"endperiod"}).union(billDataSet);
        balanceDataSet = balanceDataSet.groupBy(invBalcDimensionField).sum("qty").sum("baseqty").sum("qty2nd").finish();
        return balanceDataSet;
    }

    private static DataSet getBillDataSetBeforeEndTime(FilterInfo filterInfo) {
        HashMap<String, IInvBillAsAccParser> billToParser = new HashMap<String, IInvBillAsAccParser>();
        DataSet billDataSet = DeadlineInvAccBuilder.parseBillData(filterInfo, billToParser);
        if (billDataSet == null) {
            return null;
        }
        String[] billSelectFields = AnalyseRptOpHelper.getDataSetFieldStrs(billDataSet);
        QFilter invSchemeQFilter = new QFilter("isnotupdate", "=", (Object)Boolean.FALSE);
        DataSet invSchemeDataSet = QueryServiceHelper.queryDataSet((String)DeadlineInvAccBuilder.getAlgoKey(), (String)"im_invscheme", (String)"id as invschemeId,transceivertype.transceiver as transceiver", (QFilter[])invSchemeQFilter.toArray(), (String)"");
        billDataSet = billDataSet.join(invSchemeDataSet, JoinType.LEFT).on("billinvscheme", "invschemeId").select(billSelectFields, new String[]{"transceiver"}).finish();
        DataSet unionBillDataSet = DeadlineInvAccBuilder.handleReceiveSend(billDataSet, billToParser);
        QFilter billQFilter = DeadlineInvAccBuilder.buildBillQFilter(filterInfo);
        unionBillDataSet = unionBillDataSet.filter(billQFilter.toString());
        String[] unionBillFields = AnalyseRptOpHelper.getDataSetFieldStrs(unionBillDataSet);
        QFilter mainQFilter = AnalyseRptOpHelper.getAuditedDataQFilter();
        DataSet materialInvInfo = QueryServiceHelper.queryDataSet((String)DeadlineInvAccBuilder.getAlgoKey(), (String)"bd_materialinventoryinfo", (String)"id as materialinvstgy,masterid as material", (QFilter[])mainQFilter.toArray(), null);
        unionBillDataSet = unionBillDataSet.join(materialInvInfo, JoinType.LEFT).select(AnalyseRptOpHelper.addNewValsToSrcArr(unionBillFields, "material")).on("materialinvstgy", "materialinvstgy").finish().removeFields(new String[]{"materialinvstgy"});
        unionBillDataSet = DeadlineInvAccBuilder.handleOtherFilter(filterInfo, BILL_FIELDS, unionBillDataSet);
        return unionBillDataSet.select(BILL_FIELDS);
    }

    private static DataSet parseBillData(FilterInfo filterInfo, Map<String, IInvBillAsAccParser> billToParser) {
        DataSet billDataSet = null;
        Date endTime = filterInfo.getDate("deadline");
        Date beginDate = DateUtils.getFirstDayOfMonthByDate((Date)endTime);
        Date endDate = DateUtils.getDayEndTime((Date)endTime);
        QFilter timeQFilter = new QFilter("bookdate", ">=", (Object)beginDate).and("bookdate", "<=", (Object)endDate);
        for (String billType : DeadlineInvAccBuilder.getAccModelBillTypes()) {
            IInvBillAsAccParser accRecBillParser = InvBillAsAccParserFactory.buildBillAsAccParser(billType, timeQFilter);
            if (accRecBillParser == null) continue;
            DataSet billDataSetTemp = accRecBillParser.buildBillDataSet();
            if (billDataSet == null) {
                billDataSet = billDataSetTemp;
            } else if (billDataSetTemp != null) {
                billDataSet = billDataSet.union(billDataSetTemp);
            }
            billToParser.put(billType, accRecBillParser);
        }
        return billDataSet;
    }

    private static DataSet handleOtherFilter(FilterInfo filterInfo, String[] billSelectFields, DataSet unionBillDataSet) {
        unionBillDataSet = DeadlineInvAccBuilder.handleMaterialFilter(filterInfo, billSelectFields, unionBillDataSet);
        unionBillDataSet = DeadlineInvAccBuilder.handleProjectFilter(filterInfo, billSelectFields, unionBillDataSet);
        unionBillDataSet = DeadlineInvAccBuilder.handleWarehouseFilter(filterInfo, billSelectFields, unionBillDataSet);
        unionBillDataSet = DeadlineInvAccBuilder.handleLocationFilter(filterInfo, billSelectFields, unionBillDataSet);
        return unionBillDataSet;
    }

    private static DataSet handleLocationFilter(FilterInfo filterInfo, String[] billSelectFields, DataSet unionBillDataSet) {
        QFilter searchLocatFilter = ReportCommonFilterOrChangeOp.getDynamicObjectFromToFilter(filterInfo, "locationNumber", "locationfrom", "locationto");
        if (searchLocatFilter != null) {
            QFilter locatQFilter = AnalyseRptOpHelper.getAuditedDataQFilter();
            DataSet locatDataSet = QueryServiceHelper.queryDataSet((String)DeadlineInvAccBuilder.getAlgoKey(), (String)"bd_location", (String)"id as locationId,number as locationNumber", (QFilter[])locatQFilter.toArray(), (String)"");
            unionBillDataSet = unionBillDataSet.join(locatDataSet, JoinType.INNER).select(billSelectFields, new String[]{"locationId", "locationNumber"}).on("location", "locationId").finish().filter(searchLocatFilter.toString());
        }
        return unionBillDataSet;
    }

    private static DataSet handleWarehouseFilter(FilterInfo filterInfo, String[] billSelectFields, DataSet unionBillDataSet) {
        QFilter searchWhouseFilter = ReportCommonFilterOrChangeOp.getDynamicObjectFromToFilter(filterInfo, "warehouseNumber", "warehousefrom", "warehouseto");
        if (searchWhouseFilter != null) {
            QFilter whouseQFilter = AnalyseRptOpHelper.getAuditedDataQFilter();
            DataSet locatDataSet = QueryServiceHelper.queryDataSet((String)DeadlineInvAccBuilder.getAlgoKey(), (String)"bd_warehouse", (String)"id as warehouseId,number as warehouseNumber", (QFilter[])whouseQFilter.toArray(), (String)"");
            unionBillDataSet = unionBillDataSet.join(locatDataSet, JoinType.INNER).select(billSelectFields, new String[]{"warehouseId", "warehouseNumber"}).on("warehouse", "warehouseId").finish().filter(searchWhouseFilter.toString());
        }
        return unionBillDataSet;
    }

    private static DataSet handleProjectFilter(FilterInfo filterInfo, String[] billSelectFields, DataSet unionBillDataSet) {
        QFilter searchProFilter = ReportCommonFilterOrChangeOp.getDynamicObjectFromToFilter(filterInfo, "projectNumber", "projectfrom", "projectto");
        if (searchProFilter != null) {
            QFilter proQFilter = AnalyseRptOpHelper.getAuditedDataQFilter();
            DataSet projectDataSet = QueryServiceHelper.queryDataSet((String)DeadlineInvAccBuilder.getAlgoKey(), (String)"bd_project", (String)"id as projectId,number as projectNumber", (QFilter[])proQFilter.toArray(), (String)"");
            unionBillDataSet = unionBillDataSet.join(projectDataSet, JoinType.INNER).select(billSelectFields, new String[]{"projectId", "projectNumber"}).on("project", "projectId").finish().filter(searchProFilter.toString());
        }
        return unionBillDataSet;
    }

    private static DataSet handleMaterialFilter(FilterInfo filterInfo, String[] billSelectFields, DataSet unionBillDataSet) {
        QFilter searchMaterFilter = DeadlineInvAccBuilder.getMaterialNumFromToFilter(filterInfo, "number");
        if (searchMaterFilter != null) {
            QFilter materQFilter = AnalyseRptOpHelper.getAuditedDataQFilter();
            DataSet materialDataSet = QueryServiceHelper.queryDataSet((String)DeadlineInvAccBuilder.getAlgoKey(), (String)"bd_material", (String)"id as materialId,number as materialNumber", (QFilter[])materQFilter.toArray(), (String)"");
            unionBillDataSet = unionBillDataSet.join(materialDataSet, JoinType.INNER).select(billSelectFields, new String[]{"materialId", "materialNumber"}).on("material", "materialId").finish().filter(searchMaterFilter.toString());
        }
        return unionBillDataSet;
    }

    private static DataSet handleReceiveSend(DataSet billDataSet, Map<String, IInvBillAsAccParser> billToParser) {
        DataSet unionBillDataSet = null;
        for (Map.Entry<String, IInvBillAsAccParser> billToParserEntry : billToParser.entrySet()) {
            DataSet receSendSepcialBillDSet;
            String billType = billToParserEntry.getKey();
            IInvBillAsAccParser accRecBillParser = billToParserEntry.getValue();
            String[] inInvFields = AnalyseRptOpHelper.collectionToStrArr(accRecBillParser.buildInInvAsAccFields());
            String[] outInvFields = AnalyseRptOpHelper.collectionToStrArr(accRecBillParser.buildOutInvAsAccFields());
            DataSet receiveBillDSet = billDataSet.filter("((billinvscheme != 0 and transceiver = '0') or (billinvscheme = 0 and billtransceiver = '2_sub')) and billType = '" + billType + "'");
            DataSet sendBillDSet = billDataSet.filter("billinvscheme != 0 and transceiver = '1' and billType = '" + billType + "'");
            if (receiveBillDSet != null) {
                DataSet receiveDataDSet = receiveBillDSet.select(inInvFields);
                unionBillDataSet = unionBillDataSet == null ? receiveDataDSet : unionBillDataSet.union(receiveDataDSet);
            }
            if (sendBillDSet != null) {
                DataSet sendDataDSet = sendBillDSet.select(outInvFields);
                unionBillDataSet = unionBillDataSet == null ? sendDataDSet : unionBillDataSet.union(sendDataDSet);
            }
            if ((receSendSepcialBillDSet = billDataSet.filter("(billtransceiver = '2' or transceiver = '2') and billType = '" + billType + "'")) == null) continue;
            DataSet receSepcialBillDSet = receSendSepcialBillDSet.select(inInvFields);
            DataSet sendSepcialBillDSet = receSendSepcialBillDSet.select(outInvFields);
            unionBillDataSet = unionBillDataSet == null ? receSepcialBillDSet : unionBillDataSet.union(receSepcialBillDSet);
            unionBillDataSet = unionBillDataSet.union(sendSepcialBillDSet);
        }
        return unionBillDataSet;
    }

    private static DataSet getBeforeDeadlineAccSet(FilterInfo filterInfo) {
        Date endTime = filterInfo.getDate("deadline");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMM");
        Integer deadLine = Integer.parseInt(simpleDateFormat.format(endTime));
        QFilter invBalcQFilter = new QFilter("period", "<", (Object)deadLine).and("endperiod", ">=", (Object)deadLine);
        if (!BalanceUpdateHandle.isNewPeriodBal()) {
            invBalcQFilter.and("balancetype", "=", (Object)"1");
        }
        invBalcQFilter.and(DeadlineInvAccBuilder.addCommonDataQFilter(filterInfo));
        QFilter lotNumberFilter = ReportCommonFilterOrChangeOp.getTextFromToFilter(filterInfo, "lotnumber", "lotnumberfrom", "lotnumberto");
        if (lotNumberFilter != null) {
            invBalcQFilter.and(lotNumberFilter);
        }
        Set<String> accRecFieldSet = DeadlineInvAccBuilder.getAliasAccRecFields();
        accRecFieldSet.add("endperiod");
        String accRecFields = AnalyseRptOpHelper.collectionToStr(accRecFieldSet);
        String entityInvbalance = "im_invbalance";
        if (BalanceUpdateHandle.isNewPeriodBal()) {
            entityInvbalance = "im_inv_periodbalance";
        }
        DataSet invBalDataSet = QueryServiceHelper.queryDataSet((String)DeadlineInvAccBuilder.getAlgoKey(), (String)entityInvbalance, (String)accRecFields, (QFilter[])invBalcQFilter.toArray(), (String)"");
        return invBalDataSet;
    }

    private static DataSet getBeginningAccDataSet(DataSet invBalcDataSet, DataSet maxEndDateDataSet) {
        DataSet maxEndDateDSet = maxEndDateDataSet.filter("enddate is not null");
        DataSet beginAccDataSet = AnalyseRptOpHelper.addJoinOnCols(invBalcDataSet.join(maxEndDateDSet, JoinType.INNER), INV_BALC_DIMENSION_FIELDS).on("enddate", "enddate").select(ACCREC_FIELDS).finish();
        return beginAccDataSet;
    }

    private static DataSet getNullEndDateAccDataSet(DataSet invBalcDataSet, DataSet maxEndDateDataSet) {
        DataSet nullMaxEndDateDSet = maxEndDateDataSet.filter("enddate is null");
        DataSet beginAccDataSet = AnalyseRptOpHelper.addJoinOnCols(invBalcDataSet.join(nullMaxEndDateDSet, JoinType.INNER), INV_BALC_DIMENSION_FIELDS).on("enddate", "enddate").select(ACCREC_FIELDS).finish();
        return beginAccDataSet;
    }

    private static Set<String> getAccModelBillTypes() {
        QFilter dymAccQFilter = new QFilter("enable", "=", (Object)"1");
        DataSet dymAccdsDSet = QueryServiceHelper.queryDataSet((String)DeadlineInvAccBuilder.getAlgoKey(), (String)"plat_dymaccds", (String)"srcbill.number as billType", (QFilter[])dymAccQFilter.toArray(), (String)"");
        HashSet<String> billTypeSet = new HashSet<String>(10);
        while (dymAccdsDSet.hasNext()) {
            String billType = dymAccdsDSet.next().getString("billType");
            billTypeSet.add(billType);
        }
        return billTypeSet;
    }

    private static String getAlgoKey() {
        return DeadlineInvAccBuilder.class.getName();
    }

    private static QFilter getMaterialNumFromToFilter(FilterInfo filterInfo, String filterColomn) {
        DynamicObjectCollection materialFroms = filterInfo.getDynamicObjectCollection("materialnumberfrom");
        if (materialFroms != null && !materialFroms.isEmpty()) {
            if (materialFroms.size() > 1) {
                ArrayList<String> materialNums = new ArrayList<String>();
                for (DynamicObject materialFrom : materialFroms) {
                    String materialNum = materialFrom.getString(filterColomn);
                    materialNums.add(materialNum);
                }
                return new QFilter("materialNumber", "in", materialNums);
            }
            DynamicObject materialFrom = (DynamicObject)materialFroms.get(0);
            if (materialFrom == null) {
                return null;
            }
            String materialNumFrom = materialFrom.getString(filterColomn);
            QFilter fromFilter = new QFilter("materialNumber", ">=", (Object)materialNumFrom);
            DynamicObject materialTo = filterInfo.getDynamicObject("materialnumberto");
            if (materialTo == null) {
                return fromFilter;
            }
            String materialNumTo = materialTo.getString(filterColomn);
            QFilter toFilter = new QFilter("materialNumber", "<=", (Object)materialNumTo);
            return fromFilter.and(toFilter);
        }
        DynamicObject materialTo = filterInfo.getDynamicObject("materialnumberto");
        if (materialTo == null) {
            return null;
        }
        String materialNumTo = materialTo.getString(filterColomn);
        QFilter toFilter = new QFilter("materialNumber", "<=", (Object)materialNumTo);
        return toFilter;
    }

    private static Set<String> getAliasAccRecFields() {
        LinkedHashSet<String> accRecFields = new LinkedHashSet<String>(21);
        accRecFields.add("org");
        accRecFields.add("producedate");
        accRecFields.add("expirydate");
        accRecFields.add("warehouse");
        accRecFields.add("location");
        accRecFields.add("ownertype");
        accRecFields.add("owner");
        accRecFields.add("keepertype");
        accRecFields.add("keeper");
        accRecFields.add("invstatus");
        accRecFields.add("invtype");
        accRecFields.add("material");
        accRecFields.add("auxpty");
        accRecFields.add("lotnumber");
        accRecFields.add("project");
        accRecFields.add("unit");
        accRecFields.add("baseunit");
        accRecFields.add("unit2nd");
        if (BalanceUpdateHandle.isNewPeriodBal()) {
            accRecFields.add("qty_bal as qty");
            accRecFields.add("baseqty_bal as baseqty");
            accRecFields.add("qty2nd_bal as qty2nd");
        } else {
            accRecFields.add("endqty as qty");
            accRecFields.add("endbaseqty as baseqty");
            accRecFields.add("endqty2nd as qty2nd");
        }
        return accRecFields;
    }
}

