/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.analyse.dullmaterial;

import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.consts.InvAccConst;
import kd.scmc.im.report.analyse.base.AbstractAnalyseDetailRptQuery;
import kd.scmc.im.report.analyse.dullmaterial.DeadlineInvAccBuilder;
import kd.scmc.im.report.analyse.dullmaterial.DullTypeBuilder;
import kd.scmc.im.report.common.AnalyseReportConst;
import kd.scmc.im.report.common.ReportCommonFilterOrChangeOp;
import kd.scmc.im.report.helper.AnalyseRptOpHelper;
import org.apache.commons.lang3.StringUtils;

public class DullMaterialAlysDetailRptQuery
extends AbstractAnalyseDetailRptQuery {
    @Override
    public DataSet query(ReportQueryParam reportQueryParam, Object paramObject) throws Throwable {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        String dullAnalyseobj = filterInfo.getString("dullanalyseobj");
        DataSet dullMaterialDataSet = null;
        if ("0".equals(dullAnalyseobj)) {
            QFilter addInvAccQFilter = this.addInvAccQFilter(filterInfo);
            dullMaterialDataSet = this.getInvAccDataSet(addInvAccQFilter, filterInfo);
        } else {
            dullMaterialDataSet = DeadlineInvAccBuilder.buildDeadlineInvAccDataSet(filterInfo);
        }
        return this.reBuildDataSet(filterInfo, dullMaterialDataSet);
    }

    private QFilter addInvAccQFilter(FilterInfo filterInfo) {
        QFilter dataQFilter = AbstractAnalyseDetailRptQuery.addCommonDataQFilter(filterInfo);
        QFilter lotNumberFilter = ReportCommonFilterOrChangeOp.getTextFromToFilter(filterInfo, "lotnum", "lotnumberfrom", "lotnumberto");
        if (lotNumberFilter != null) {
            dataQFilter.and(lotNumberFilter);
        }
        return dataQFilter;
    }

    private DataSet getInvAccDataSet(QFilter invAccQFilter, FilterInfo filterInfo) {
        DataSet defDataSet = QueryServiceHelper.queryDataSet((String)this.getClassName(), (String)InvAccConst.getBalTb(), (String)this.getInvAccCols(), (QFilter[])invAccQFilter.toArray(), (String)"");
        return defDataSet;
    }

    private String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private DataSet reBuildDataSet(FilterInfo filterInfo, DataSet accInvDataSet) {
        String ownerTypehead;
        QFilter materialGroupNumberFilter;
        DynamicObject materialgroupstandard = filterInfo.getDynamicObject("materialgroupstandard");
        Long standardId = 0L;
        standardId = materialgroupstandard == null ? AnalyseReportConst.INIT_MATERIALGROUPSTANDARD_ID : (Long)materialgroupstandard.getPkValue();
        DataSet classMaterialDataSet = this.getClassifiedMaterialDataSet(filterInfo);
        accInvDataSet = accInvDataSet.leftJoin(classMaterialDataSet).on("material", "material").select(AnalyseRptOpHelper.getDataSetFieldStrs(accInvDataSet, "standard", "group", "groupnumber", "materialnumber")).finish();
        if (!AnalyseReportConst.INIT_MATERIALGROUPSTANDARD_ID.equals(standardId)) {
            accInvDataSet = accInvDataSet.where("standard = " + standardId);
        }
        if ((materialGroupNumberFilter = ReportCommonFilterOrChangeOp.getDynamicObjectFromToFilter(filterInfo, "groupnumber", "materialgroupfrom", "materialgroupto")) != null) {
            accInvDataSet = accInvDataSet.filter(materialGroupNumberFilter.toString());
        }
        if (!StringUtils.isEmpty((CharSequence)(ownerTypehead = filterInfo.getString("ownertypehead")))) {
            accInvDataSet = ReportCommonFilterOrChangeOp.filterOwner(filterInfo, accInvDataSet);
        }
        accInvDataSet = accInvDataSet.select(this.getDullMaterialRptListCols()).where("qty != 0 or qty2nd != 0");
        accInvDataSet = accInvDataSet.groupBy(this.getGroupByFields(filterInfo)).sum("qty").sum("baseqty").sum("qty2nd").finish();
        accInvDataSet = accInvDataSet.where("qty != 0 or qty2nd != 0");
        DataSet billDataSet = DullTypeBuilder.buildDullTypeDataSet(filterInfo);
        String dulltype = filterInfo.getString("dulltype");
        if (billDataSet == null) {
            if ("0".equals(dulltype) || "2".equals(dulltype)) {
                return accInvDataSet;
            }
            return accInvDataSet.filter(AnalyseRptOpHelper.getIdentNotEqQFilter().toString());
        }
        accInvDataSet = accInvDataSet.leftJoin(billDataSet).select(AnalyseRptOpHelper.getDataSetFieldStrs(accInvDataSet, "dullTypeSum")).on("org", "org").on("material", "material").finish();
        String whereExp = null;
        switch (dulltype) {
            case "0": {
                whereExp = "dullTypeSum = 0 or dullTypeSum is null";
                break;
            }
            case "1": {
                whereExp = "dullTypeSum = 1";
                break;
            }
            case "2": {
                whereExp = "dullTypeSum = 1 or (dullTypeSum = 0 or dullTypeSum is null)";
                break;
            }
            default: {
                whereExp = AnalyseRptOpHelper.getIdentEqQFilter().toString();
            }
        }
        accInvDataSet = accInvDataSet.where(whereExp);
        return accInvDataSet;
    }

    @Override
    protected DataSet getClassifiedMaterialDataSet(FilterInfo filterInfo) {
        Object pkValue = null;
        DynamicObject materialgroupstandard = filterInfo.getDynamicObject("materialgroupstandard");
        pkValue = materialgroupstandard == null ? AnalyseReportConst.INIT_MATERIALGROUPSTANDARD_ID : materialgroupstandard.getPkValue();
        DataSet classifiedMaterialDataSet = QueryServiceHelper.queryDataSet((String)"bd_materialgroupdetail", (String)"bd_materialgroupdetail", (String)"group,group.number as groupnumber,material,material.number as materialnumber,standard", (QFilter[])new QFilter("standard", "=", pkValue).toArray(), (String)"group desc");
        return classifiedMaterialDataSet;
    }

    private String getInvAccCols() {
        StringBuilder tabHeadCols = new StringBuilder();
        tabHeadCols.append("org,");
        tabHeadCols.append("warehouse,");
        tabHeadCols.append("location,");
        tabHeadCols.append("ownertype,");
        tabHeadCols.append("owner,");
        tabHeadCols.append("keepertype,");
        tabHeadCols.append("keeper,");
        tabHeadCols.append("invstatus,");
        tabHeadCols.append("invtype,");
        tabHeadCols.append("material,");
        tabHeadCols.append("auxpty,");
        tabHeadCols.append("lotnum as lotnumber,");
        tabHeadCols.append("project,");
        tabHeadCols.append("unit,");
        tabHeadCols.append("qty,");
        tabHeadCols.append("baseunit,");
        tabHeadCols.append("baseqty,");
        tabHeadCols.append("unit2nd,");
        tabHeadCols.append("qty2nd");
        return tabHeadCols.toString();
    }

    private String[] getDullMaterialRptListCols() {
        StringBuilder tabHeadCols = new StringBuilder();
        tabHeadCols.append("invtype,");
        tabHeadCols.append("invstatus,");
        tabHeadCols.append("group,");
        tabHeadCols.append("material,");
        tabHeadCols.append("auxpty,");
        tabHeadCols.append("lotnumber,");
        tabHeadCols.append("unit,");
        tabHeadCols.append("baseunit,");
        tabHeadCols.append("unit2nd,");
        tabHeadCols.append("qty,");
        tabHeadCols.append("baseqty,");
        tabHeadCols.append("qty2nd,");
        tabHeadCols.append("warehouse,");
        tabHeadCols.append("location,");
        tabHeadCols.append("org,");
        tabHeadCols.append("owner,");
        tabHeadCols.append("ownertype,");
        tabHeadCols.append("keeper,");
        tabHeadCols.append("keepertype,");
        tabHeadCols.append("project,");
        tabHeadCols.append("0 as tracknumber");
        return tabHeadCols.toString().split(",");
    }

    private String[] getGroupByFields(FilterInfo filterInfo) {
        String defGroupFields = this.getDefaultGroupByCols();
        String summaryBasis = this.getSummaryBasis(filterInfo);
        if (summaryBasis != null) {
            if (summaryBasis.contains("tracknumber")) {
                summaryBasis = summaryBasis.replace("tracknumber,", "");
            }
            defGroupFields = defGroupFields + summaryBasis;
        }
        return defGroupFields.split(",");
    }

    private String getDefaultGroupByCols() {
        return "invtype,invstatus,group,material,unit,baseunit,unit2nd,org,ownertype,keeper,keepertype";
    }

    private String getSummaryBasis(FilterInfo filterInfo) {
        return filterInfo.getString("summarybasis");
    }
}

