/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.analyse.dullmaterial;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.sbd.utils.StringUtils;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.report.analyse.dullmaterial.DullMaterialBeforeF7Select;
import kd.scmc.im.report.analyse.dullmaterial.DullMaterialPropChanged;
import kd.scmc.im.report.common.AnalyseReportConst;
import kd.scmc.im.report.common.ReportCommonFilterOrChangeOp;
import kd.scmc.im.report.common.ValidateMsgEntity;
import kd.scmc.im.report.helper.AnalyseRptOpHelper;
import kd.scmc.im.report.helper.OwnerTypeViewHelper;
import kd.scmc.im.utils.FormUtils;

public class DullMaterialAlysRptPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    public void preOpenForm(PreOpenFormEventArgs e) {
        AnalyseRptOpHelper.handlePreOpenForm(e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener((BeforeF7SelectListener)this, (String[])new String[]{"orghead", "accountownerfrom", "supplierownerfrom", "customerownerfrom", "ownerto", "materialgroupfrom", "materialgroupto", "materialnumberfrom", "materialnumberto", "warehousefrom", "warehouseto", "locationfrom", "locationto", "projectfrom", "projectto", "materialgroupstandard", "inbilltype", "outbilltype", "inbillinvscheme", "outbillinvscheme", "ivntypehead", "invstatushead", "configuredcodeto", "tracknumberto"});
        this.addClickListeners(new String[]{"lotnumberfrom"});
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        DullMaterialBeforeF7Select beforeF7Select = new DullMaterialBeforeF7Select((IFormView)this.getView());
        beforeF7Select.beforeF7Select(e, "orghead");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DullMaterialPropChanged dullMaterPropChanged = new DullMaterialPropChanged((IFormView)this.getView());
        dullMaterPropChanged.propertyChanged(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.intBillRange();
        HashMap prop = new HashMap(1);
        HashMap<String, Integer> editor = new HashMap<String, Integer>(1);
        editor.put("maxlength", 8000);
        prop.put("item", editor);
        this.getView().updateControlMetadata("lotnumberfrom", prop);
        OwnerTypeViewHelper.setEnableUI(this.getModel(), (IFormView)this.getView());
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        ReportCommonFilterOrChangeOp.initMultiOrg(this.getView(), "orghead");
        this.initStandard();
        this.intBillRange();
        this.setEnableUI();
        this.handleResetButtonEvent();
    }

    public void click(EventObject evt) {
        TextEdit textEdit;
        String key;
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof TextEdit && "lotnumberfrom".equals(key = (textEdit = (TextEdit)source).getKey())) {
            this.showLotnumber(key);
        }
    }

    private void handleResetButtonEvent() {
        this.getView().setEnable(Boolean.TRUE, new String[]{"materialgroupto"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"materialnumberto"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"warehouseto"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"locationto"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"projectto"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"lotnumberto"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"configuredcodeto"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"tracknumberto"});
    }

    private void showLotnumber(String actionId) {
        IReportView view = this.getView();
        Object value = this.getModel().getValue(actionId);
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setTargetKey(actionId);
        parameter.setParentFormId(view.getFormShowParameter().getParentFormId());
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setCustomParam("params", value);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("im_multitext");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnDataObj = closedCallBackEvent.getReturnData();
        if (returnDataObj instanceof Map) {
            Map returnData = (Map)returnDataObj;
            String value = String.valueOf(returnData.get("content"));
            String operateType = String.valueOf(returnData.get("operateType"));
            if ("btnok".equals(operateType)) {
                value = value.replaceAll("\n", ",");
                this.getModel().setValue(actionId, (Object)value);
            }
        }
    }

    private void intBillRange() {
        IDataModel dataModel = this.getModel();
        this.initInBillRange(dataModel);
        this.initOutBillRange(dataModel);
    }

    private void initInBillRange(IDataModel dataModel) {
        DynamicObjectCollection inentryEntity = dataModel.getEntryEntity("inentryentity");
        if (inentryEntity != null && inentryEntity.size() > 0) {
            dataModel.deleteEntryData("inentryentity");
        }
        dataModel.batchCreateNewEntryRow("inentryentity", 6);
        dataModel.setValue("inbilltype", (Object)"im_productinbill", 0);
        dataModel.setValue("inbilltype", (Object)"im_purinbill", 1);
        dataModel.setValue("inbilltype", (Object)"im_otherinbill", 2);
        dataModel.setValue("inbilltype", (Object)"im_transinbill", 3);
        dataModel.setValue("inbilltype", (Object)"im_transdirbill", 4);
        dataModel.setValue("inbilltype", (Object)"im_ospurinbill", 5);
    }

    private void initOutBillRange(IDataModel dataModel) {
        DynamicObjectCollection outentryEntity = dataModel.getEntryEntity("outentryentity");
        if (outentryEntity != null && outentryEntity.size() > 0) {
            dataModel.deleteEntryData("outentryentity");
        }
        dataModel.batchCreateNewEntryRow("outentryentity", 6);
        dataModel.setValue("outbilltype", (Object)"im_saloutbill", 0);
        dataModel.setValue("outbilltype", (Object)"im_materialreqoutbill", 1);
        dataModel.setValue("outbilltype", (Object)"im_otheroutbill", 2);
        dataModel.setValue("outbilltype", (Object)"im_transoutbill", 3);
        dataModel.setValue("outbilltype", (Object)"im_transdirbill", 4);
        dataModel.setValue("outbilltype", (Object)"im_osmaterialreqoutbill", 5);
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        String entryName = e.getEntryProp().getName();
        IDataModel dataModel = this.getModel();
        DynamicObjectCollection inentryEntity = dataModel.getEntryEntity("inentryentity");
        DynamicObjectCollection outentryentity = dataModel.getEntryEntity("outentryentity");
        int selectRows = e.getRowIndexs().length;
        switch (entryName) {
            case "inentryentity": {
                this.checkDeleteBillRangeEntryRow(inentryEntity, selectRows);
                break;
            }
            case "outentryentity": {
                this.checkDeleteBillRangeEntryRow(outentryentity, selectRows);
                break;
            }
        }
    }

    private void checkDeleteBillRangeEntryRow(DynamicObjectCollection entryEntity, int selectRows) {
        if (entryEntity.size() == selectRows) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u8303\u56f4\u5355\u636e\u4f53\u884c\u6570\u4e0d\u80fd\u5c0f\u4e8e1,\u4e0d\u80fd\u6267\u884c\u8be5\u5220\u9664\u64cd\u4f5c\u3002", (String)"DullMaterialAlysRptPlugin_0", (String)"scmc-im-report", (Object[])new Object[0]));
        }
    }

    private boolean verifyQueryParam(FilterInfo filterInfo, ValidateMsgEntity ckMsgEntity) {
        boolean isCkSuccess;
        IReportView view = this.getView();
        DynamicObjectCollection orghead = filterInfo.getDynamicObjectCollection("orghead");
        AnalyseRptOpHelper.verifyOrgMustInput(ckMsgEntity, orghead);
        DynamicObject mgroupstandard = filterInfo.getDynamicObject("materialgroupstandard");
        AnalyseRptOpHelper.verifyMGroupStandardMustInput(ckMsgEntity, mgroupstandard);
        int dulldays = filterInfo.getInt("dulldays");
        this.verifyDullDays(ckMsgEntity, dulldays);
        DynamicObject inbilltype = (DynamicObject)this.getModel().getValue("inbilltype");
        this.verifyInBillTypeMustInput(ckMsgEntity, inbilltype);
        DynamicObject outbilltype = (DynamicObject)this.getModel().getValue("outbilltype");
        this.verifyOutBillTypeMustInput(ckMsgEntity, outbilltype);
        String dullAnalyseobj = filterInfo.getString("dullanalyseobj");
        if ("1".equals(dullAnalyseobj)) {
            Date deadLine = (Date)this.getModel().getValue("deadline");
            this.verifyDeadLineMustInput(ckMsgEntity, deadLine);
        }
        if (!(isCkSuccess = ckMsgEntity.isCheckSuccess())) {
            ckMsgEntity.showCkErrMsgs((IFormView)view);
        }
        return isCkSuccess;
    }

    private void verifyInBillTypeMustInput(ValidateMsgEntity ckMsgEntity, DynamicObject inBillType) {
        if (inBillType == null) {
            ckMsgEntity.addErrorMsg(ResManager.loadKDString((String)"\u5165\u5e93\u5355\u636e\u8303\u56f4\u7684\u5355\u636e\u7c7b\u578b\u5fc5\u987b\u8981\u6709\u503c\u3002", (String)"DullMaterialAlysRptPlugin_1", (String)"scmc-im-report", (Object[])new Object[0]));
        }
    }

    private void verifyDeadLineMustInput(ValidateMsgEntity ckMsgEntity, Date deadLine) {
        if (deadLine == null) {
            ckMsgEntity.addErrorMsg(ResManager.loadKDString((String)"\u622a\u6b62\u65e5\u671f\u5fc5\u987b\u8981\u6709\u503c\u3002", (String)"DullMaterialAlysRptPlugin_2", (String)"scmc-im-report", (Object[])new Object[0]));
        }
    }

    private void verifyOutBillTypeMustInput(ValidateMsgEntity ckMsgEntity, DynamicObject outBillType) {
        if (outBillType == null) {
            ckMsgEntity.addErrorMsg(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u51fa\u5e93\u5355\u636e\u8303\u56f4\u7684\u5355\u636e\u7c7b\u578b\u3002", (String)"DullMaterialAlysRptPlugin_3", (String)"scmc-im-report", (Object[])new Object[0]));
        }
    }

    private void verifyDullDays(ValidateMsgEntity ckMsgEntity, int dulldays) {
        if (dulldays < 0) {
            ckMsgEntity.addErrorMsg(ResManager.loadKDString((String)"\u5446\u6ede\u5929\u6570\u5fc5\u987b\u662f\u5927\u4e8e\u6216\u7b49\u4e8e0\u7684\u6574\u6570\u3002", (String)"DullMaterialAlysRptPlugin_4", (String)"scmc-im-report", (Object[])new Object[0]));
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        FilterInfo filterInfo = queryParam.getFilter();
        ValidateMsgEntity ckMsgEntity = new ValidateMsgEntity();
        return this.verifyQueryParam(filterInfo, ckMsgEntity);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        String billType;
        super.beforeQuery(queryParam);
        IDataModel dataModel = this.getModel();
        FilterInfo filterInfo = queryParam.getFilter();
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        List rptColumns = reportList.getColumns();
        String[] needDefHideCols = this.getNeedDefHideCols(filterInfo);
        if (needDefHideCols.length > 0) {
            AnalyseRptOpHelper.setHiddenColsForRpt((List<AbstractReportColumn>)rptColumns, needDefHideCols);
        }
        DynamicObjectCollection inEntryEntity = dataModel.getEntryEntity("inentryentity");
        DynamicObjectCollection outEntryEntity = dataModel.getEntryEntity("outentryentity");
        HashMap<String, Set<Long>> billTypeToInvSchemes = new HashMap<String, Set<Long>>(16);
        ArrayList<String> billTypes = new ArrayList<String>();
        for (DynamicObject inEntryObj : inEntryEntity) {
            DynamicObject inBillType = inEntryObj.getDynamicObject("inbilltype");
            if (inBillType == null) continue;
            billType = inBillType.getString("id");
            billTypes.add(billType);
        }
        for (DynamicObject outEntryObj : outEntryEntity) {
            DynamicObject outBillType = outEntryObj.getDynamicObject("outbilltype");
            if (outBillType == null) continue;
            billType = outBillType.getString("id");
            billTypes.add(billType);
        }
        QFilter invSchemeFilter = new QFilter("billform", "in", billTypes);
        invSchemeFilter.and("enable", "=", (Object)Boolean.TRUE);
        invSchemeFilter.and("isnotupdate", "=", (Object)Boolean.FALSE);
        DynamicObjectCollection invSchemes = QueryServiceHelper.query((String)"im_invscheme", (String)"id as invschemeId,billform.number as billtype", (QFilter[])invSchemeFilter.toArray());
        if (invSchemes != null && !invSchemes.isEmpty()) {
            for (DynamicObject invScheme : invSchemes) {
                String billtype = invScheme.getString("billtype");
                Long invschemeId = invScheme.getLong("invschemeId");
                if (!billTypeToInvSchemes.containsKey(billtype)) {
                    billTypeToInvSchemes.put(billtype, new HashSet());
                }
                ((Set)billTypeToInvSchemes.get(billtype)).add(invschemeId);
            }
        }
        Map<String, Set<Long>> inbillToInvschemes = this.buildBillTypeToInvschemes(inEntryEntity, billTypeToInvSchemes, "in");
        Map<String, Set<Long>> outbillToInvschemes = this.buildBillTypeToInvschemes(outEntryEntity, billTypeToInvSchemes, "out");
        filterInfo.addFilterItem("inBillToInvschemes", inbillToInvschemes);
        filterInfo.addFilterItem("outBillToInvschemes", outbillToInvschemes);
    }

    private Map<String, Set<Long>> buildBillTypeToInvschemes(DynamicObjectCollection entryEntity, Map<String, Set<Long>> queryBillToInvSchemes, String inOutKey) {
        HashMap<String, Set<Long>> billToInvschemeData = new HashMap<String, Set<Long>>(16);
        for (DynamicObject entryObj : entryEntity) {
            DynamicObject billTypeObj = entryObj.getDynamicObject(inOutKey + "billtype");
            if (billTypeObj == null) continue;
            String billType = billTypeObj.getString("id");
            DynamicObjectCollection billinvschemes = entryObj.getDynamicObjectCollection(inOutKey + "billinvscheme");
            if (billinvschemes == null || billinvschemes.isEmpty()) {
                Set<Long> queryInvSchemes = queryBillToInvSchemes.get(billType);
                if (queryInvSchemes == null || queryInvSchemes.isEmpty()) {
                    billToInvschemeData.put(billType, new HashSet());
                    continue;
                }
                billToInvschemeData.put(billType, queryInvSchemes);
                continue;
            }
            Set invschemeSet = (Set)billToInvschemeData.get(billType);
            if (invschemeSet != null && invschemeSet.isEmpty()) {
                Set<Long> queryInvSchemes = queryBillToInvSchemes.get(billType);
                billToInvschemeData.put(billType, queryInvSchemes);
                continue;
            }
            HashSet<Long> invschemesSet = new HashSet<Long>(16);
            for (DynamicObject invschemeObj : billinvschemes) {
                Long invschemeId = invschemeObj.getDynamicObject(1).getLong("id");
                invschemesSet.add(invschemeId);
            }
            if (!billToInvschemeData.containsKey(billType)) {
                billToInvschemeData.put(billType, new HashSet());
            }
            ((Set)billToInvschemeData.get(billType)).addAll(invschemesSet);
        }
        return billToInvschemeData;
    }

    public void afterSetModelValue(DynamicObject scheme) {
        Object o;
        DynamicObjectCollection projectFrom;
        DynamicObjectCollection locationFrom;
        DynamicObjectCollection warehouseFrom;
        DynamicObjectCollection materiaNumFrom;
        super.afterSetModelValue(scheme);
        IReportView view = this.getView();
        String dullAnalysObj = scheme.getString("dullanalyseobj");
        if ("0".equals(dullAnalysObj)) {
            view.setEnable(Boolean.FALSE, new String[]{"deadline"});
        } else {
            view.setEnable(Boolean.TRUE, new String[]{"deadline"});
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObjectCollection materialGrpFrom = dataEntity.getDynamicObjectCollection("materialgroupfrom");
        if (materialGrpFrom.size() > 1) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"materialgroupto"});
        }
        if ((materiaNumFrom = dataEntity.getDynamicObjectCollection("materialnumberfrom")).size() > 1) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"materialnumberto"});
        }
        if ((warehouseFrom = dataEntity.getDynamicObjectCollection("warehousefrom")).size() > 1) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"warehouseto"});
        }
        if ((locationFrom = dataEntity.getDynamicObjectCollection("locationfrom")).size() > 1) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"locationto"});
        }
        if ((projectFrom = dataEntity.getDynamicObjectCollection("projectfrom")).size() > 1) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"projectto"});
        }
        if ((o = dataEntity.get("lotnumberfrom")) == null || "".equals(o)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"lotnumberto"});
        }
    }

    public void setOtherEntryFilter(FilterInfo filterInfo) {
        super.setOtherEntryFilter(filterInfo);
        IDataModel dataModel = this.getModel();
        DynamicObjectCollection inEntryEntity = dataModel.getEntryEntity("inentryentity");
        DynamicObjectCollection outEntryEntity = dataModel.getEntryEntity("outentryentity");
        this.setBillTypeFilter(dataModel, inEntryEntity, "inbilltype");
        this.setBillTypeFilter(dataModel, outEntryEntity, "outbilltype");
        this.setBillInvSchemesFilter(dataModel, inEntryEntity, "inbillinvscheme");
        this.setBillInvSchemesFilter(dataModel, outEntryEntity, "outbillinvscheme");
    }

    private void setBillInvSchemesFilter(IDataModel dataModel, DynamicObjectCollection entryEntity, String billInvShemeKey) {
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entryObj = (DynamicObject)entryEntity.get(i);
            DynamicObjectCollection billInvSchemes = entryObj.getDynamicObjectCollection(billInvShemeKey);
            LinkedHashSet<Long> billInvSchemeSet = new LinkedHashSet<Long>(16);
            for (DynamicObject billInvScheme : billInvSchemes) {
                Long invSchemeId = billInvScheme.getDynamicObject(1).getLong("id");
                billInvSchemeSet.add(invSchemeId);
            }
            dataModel.setValue(billInvShemeKey, (Object)billInvSchemeSet.toArray(), i);
        }
    }

    private void setBillTypeFilter(IDataModel dataModel, DynamicObjectCollection entryEntity, String billTypeKey) {
        for (int i = 0; i < entryEntity.size(); ++i) {
            String billType;
            DynamicObject entryObj = (DynamicObject)entryEntity.get(i);
            DynamicObject billTypeObj = entryObj.getDynamicObject(billTypeKey);
            if (billTypeObj == null || StringUtils.isEmpty((String)(billType = billTypeObj.getString("id")))) continue;
            dataModel.setValue(billTypeKey, (Object)billType, i);
        }
    }

    public void loadOtherEntryFilter(DynamicObject scheme) {
        super.loadOtherEntryFilter(scheme);
        IDataModel dataModel = this.getModel();
        DynamicObjectCollection inEntryEntity = scheme.getDynamicObjectCollection("inentryentity");
        DynamicObjectCollection outEntryEntity = scheme.getDynamicObjectCollection("outentryentity");
        if (inEntryEntity == null || inEntryEntity.size() == 0 || outEntryEntity == null || outEntryEntity.size() == 0) {
            return;
        }
        dataModel.deleteEntryData("inentryentity");
        dataModel.deleteEntryData("outentryentity");
        dataModel.batchCreateNewEntryRow("inentryentity", inEntryEntity.size());
        dataModel.batchCreateNewEntryRow("outentryentity", outEntryEntity.size());
        this.setBillTypeFilter(dataModel, inEntryEntity, "inbilltype");
        this.setBillTypeFilter(dataModel, outEntryEntity, "outbilltype");
        this.setBillInvSchemesFilter(dataModel, inEntryEntity, "inbillinvscheme");
        this.setBillInvSchemesFilter(dataModel, outEntryEntity, "outbillinvscheme");
    }

    private void initStandard() {
        this.getModel().setValue("materialgroupstandard", (Object)AnalyseReportConst.INIT_MATERIALGROUPSTANDARD_ID);
    }

    private String[] getNeedDefHideCols(FilterInfo filterInfo) {
        HashSet<String> defaultHideCols = new HashSet<String>();
        defaultHideCols.add("auxpty");
        defaultHideCols.add("lotnumber");
        defaultHideCols.add("owner");
        defaultHideCols.add("warehouse");
        defaultHideCols.add("location");
        defaultHideCols.add("project");
        String summaryBasis = filterInfo.getString("summarybasis");
        if (summaryBasis == null) {
            return defaultHideCols.toArray(new String[defaultHideCols.size()]);
        }
        String[] summaryCols = summaryBasis.replaceFirst(",", "").split(",");
        if (summaryCols.length > 0) {
            defaultHideCols.removeAll(AnalyseRptOpHelper.strArrToList(summaryCols));
        }
        defaultHideCols.add("tracknumber");
        return defaultHideCols.toArray(new String[defaultHideCols.size()]);
    }

    private void setEnableUI() {
        this.getView().setEnable(Boolean.FALSE, new String[]{"deadline"});
    }
}

