/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.analyse.dullmaterial;

import java.util.Arrays;
import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.report.analyse.base.BaseAnalyseRptBeforeF7Select;
import kd.scmc.im.report.helper.AnalyseRptOpHelper;

public class DullMaterialBeforeF7Select
extends BaseAnalyseRptBeforeF7Select {
    public DullMaterialBeforeF7Select(IFormView view) {
        super(view);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e, String orgLogo) {
        super.beforeF7Select(e, orgLogo);
        String proKey = e.getProperty().getName();
        int rowIndex = e.getRow();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        switch (proKey) {
            case "inbilltype": 
            case "outbilltype": {
                this.beforeBillTypeEntry(showParameter);
                break;
            }
            case "inbillinvscheme": {
                this.beforeInInvSchemeEntry(showParameter, rowIndex);
                break;
            }
            case "outbillinvscheme": {
                this.beforeOutInvSchemeEntry(showParameter, rowIndex);
                break;
            }
        }
        showParameter.setF7ClickByFilter(false);
    }

    private void beforeBillTypeEntry(ListShowParameter showParameter) {
        QFilter dymAccQFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        DataSet dymAccdsDSet = QueryServiceHelper.queryDataSet((String)this.getClassName(), (String)"plat_dymaccds", (String)"srcbill.number as billNumber", (QFilter[])dymAccQFilter.toArray(), (String)"");
        QFilter mainEntityQFilter = AnalyseRptOpHelper.getIdentEqQFilter();
        mainEntityQFilter.and("billtype", "=", (Object)Boolean.TRUE);
        DataSet mainEntitySet = QueryServiceHelper.queryDataSet((String)this.getClassName(), (String)"bos_entityobject", (String)"id as mainid", (QFilter[])mainEntityQFilter.toArray(), (String)"");
        mainEntitySet = mainEntitySet.join(dymAccdsDSet, JoinType.INNER).on("mainid", "billNumber").select(new String[]{"mainid"}).finish();
        HashSet<String> sets = new HashSet<String>(10);
        while (mainEntitySet.hasNext()) {
            String mainid = mainEntitySet.next().getString("mainid");
            sets.add(mainid);
        }
        showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", sets));
        showParameter.setFormId("bos_listf7");
    }

    private void beforeInInvSchemeEntry(ListShowParameter showParameter, int rowIndex) {
        this.beforeInvSchemeEntry(showParameter, "inbilltype", rowIndex);
    }

    private void beforeOutInvSchemeEntry(ListShowParameter showParameter, int rowIndex) {
        this.beforeInvSchemeEntry(showParameter, "outbilltype", rowIndex);
    }

    private void beforeInvSchemeEntry(ListShowParameter showParameter, String billTypeKey, int rowIndex) {
        DynamicObject inBillType = (DynamicObject)this.view.getModel().getValue(billTypeKey, rowIndex);
        if (inBillType == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u5f55\u5355\u636e\u7c7b\u578b\u3002", (String)"DullMaterialBeforeF7Select_0", (String)"scmc-im-report", (Object[])new Object[0]));
        }
        QFilter qFilter = new QFilter("billform", "=", (Object)inBillType.getString("number"));
        qFilter.and("enable", "=", (Object)Boolean.TRUE);
        qFilter.and("isnotupdate", "=", (Object)Boolean.FALSE);
        showParameter.getListFilterParameter().setQFilters(Arrays.asList(qFilter.toArray()));
        showParameter.setFormId("bos_listf7");
    }

    private String getClassName() {
        return this.getClass().getName();
    }
}

