/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.analyse.dullmaterial;

import java.util.Date;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.scmc.im.business.helper.DataChangeHelper;
import kd.scmc.im.report.analyse.base.BaseAnalyseRptPropChanged;
import kd.scmc.im.utils.DateUtils;

public class DullMaterialPropChanged
extends BaseAnalyseRptPropChanged {
    public DullMaterialPropChanged(IFormView view) {
        super(view);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        String key = e.getProperty().getName();
        int rowIndex = valueSet[0].getRowIndex();
        switch (key) {
            case "dullanalyseobj": {
                this.handleDullalysObjChangeEvent((String)newValue);
                break;
            }
            case "inbilltype": {
                this.handleInBillTypeEntryChangeEvent(rowIndex);
                break;
            }
            case "outbilltype": {
                this.handleOutBillTypeEntryChangeEvent(rowIndex);
                break;
            }
        }
    }

    private void handleDullalysObjChangeEvent(Object newValue) {
        if ("1".equals(newValue)) {
            this.view.getModel().setValue("deadline", (Object)DateUtils.getDate((Date)new Date()));
            this.view.setEnable(Boolean.TRUE, new String[]{"deadline"});
        } else {
            this.view.getModel().setValue("deadline", null);
            this.view.setEnable(Boolean.FALSE, new String[]{"deadline"});
        }
    }

    private void handleInBillTypeEntryChangeEvent(int rowIndex) {
        DataChangeHelper.setValue((IDataModel)this.view.getModel(), (String)"inbillinvscheme", null, (int)rowIndex, (boolean)false);
    }

    private void handleOutBillTypeEntryChangeEvent(int rowIndex) {
        DataChangeHelper.setValue((IDataModel)this.view.getModel(), (String)"outbillinvscheme", null, (int)rowIndex, (boolean)false);
    }
}

