/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.analyse.shelflife;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.business.balance.BalanceUpdateHandle;
import kd.scmc.im.consts.InvAccConst;
import kd.scmc.im.report.analyse.base.AbstractAnalyseDetailRptQuery;
import kd.scmc.im.report.common.ReportCommonFilterOrChangeOp;
import kd.scmc.im.report.helper.ReportGeneralOpHelper;
import org.apache.commons.lang3.StringUtils;

public class ShelfLifeAlysDetailRptQuery
extends AbstractAnalyseDetailRptQuery {
    protected static final Log logger = LogFactory.getLog(ShelfLifeAlysDetailRptQuery.class);
    private static final String[] materialSelect = new String[]{"materialId", "enableshelflifemgr", "enablewarnlead", "warnleadtime", "leadtimeunit"};

    @Override
    public DataSet query(ReportQueryParam reportQueryParam, Object paramObject) throws Throwable {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        QFilter addToDefQFilter = this.addToDefaultQFilter(filterInfo);
        DataSet shelfLifeAlysDataSet = this.getShelfLifeAlysDataSet(addToDefQFilter);
        shelfLifeAlysDataSet = this.reBuildShelfLifeAlysDataSet(filterInfo, shelfLifeAlysDataSet);
        return shelfLifeAlysDataSet;
    }

    private QFilter addToDefaultQFilter(FilterInfo filterInfo) {
        QFilter dataQFilter = this.addDataQFilter(filterInfo);
        QFilter proDateQFilter = this.getProDateQFilter(filterInfo);
        if (proDateQFilter != null) {
            dataQFilter.and(proDateQFilter);
        }
        this.addLotNumberFilter(filterInfo, "lotnum", dataQFilter);
        if (!BalanceUpdateHandle.isNewPeriodBal()) {
            dataQFilter.and(this.getBalcTypeQFilter());
        }
        return dataQFilter;
    }

    private QFilter getBalcTypeQFilter() {
        return new QFilter("balancetype", "!=", (Object)"2");
    }

    private QFilter getProDateQFilter(FilterInfo filterInfo) {
        Date prodateto;
        QFilter prodateQFilter = null;
        QFilter expiryQFilter = null;
        Date prodatefrom = filterInfo.getDate("prodatefrom");
        if (prodatefrom != null) {
            prodateQFilter = new QFilter("producedate", ">=", (Object)ReportGeneralOpHelper.getStartTimeOfToday(prodatefrom));
        }
        if ((prodateto = filterInfo.getDate("prodateto")) != null) {
            expiryQFilter = new QFilter("producedate", "<=", (Object)ReportGeneralOpHelper.getLastTimeOfToday(prodateto));
        }
        if (prodateQFilter == null) {
            return expiryQFilter;
        }
        if (expiryQFilter == null) {
            return prodateQFilter;
        }
        return prodateQFilter.and(expiryQFilter);
    }

    private QFilter addDataQFilter(FilterInfo filterInfo) {
        QFilter tracknumberFilter;
        QFilter configuredCodeFilter;
        QFilter projectFilter;
        QFilter locationFilter;
        QFilter warehouseFilter;
        QFilter materialFilter;
        DynamicObjectCollection invstatusheads;
        DynamicObjectCollection ivntypeheads;
        DynamicObjectCollection orgSet = filterInfo.getDynamicObjectCollection("orghead");
        ArrayList<Long> orgIds = new ArrayList<Long>();
        for (DynamicObject org : orgSet) {
            orgIds.add((Long)org.getPkValue());
        }
        QFilter commDataQFilter = new QFilter("org", "in", orgIds);
        String ownerTypehead = filterInfo.getString("ownertypehead");
        QFilter ownerTypeFilter = null;
        if (ownerTypehead != null && !ownerTypehead.trim().equals("")) {
            ownerTypeFilter = new QFilter("ownertype", "=", (Object)ownerTypehead);
            commDataQFilter.and(ownerTypeFilter);
        }
        if ((ivntypeheads = filterInfo.getDynamicObjectCollection("ivntypehead")) != null && ivntypeheads.size() > 0) {
            HashSet<Object> ivntypeIds = new HashSet<Object>();
            for (Iterator ivntype : ivntypeheads) {
                ivntypeIds.add(ivntype.getPkValue());
            }
            QFilter ivntypeheadFilter = new QFilter("invtype", "in", ivntypeIds);
            commDataQFilter.and(ivntypeheadFilter);
        }
        if ((invstatusheads = filterInfo.getDynamicObjectCollection("invstatushead")) != null && invstatusheads.size() > 0) {
            HashSet<Object> invstatusIds = new HashSet<Object>();
            for (DynamicObject invstatus : invstatusheads) {
                invstatusIds.add(invstatus.getPkValue());
            }
            QFilter invstatusheadFilter = new QFilter("invstatus", "in", invstatusIds);
            commDataQFilter.and(invstatusheadFilter);
        }
        if ((materialFilter = this.getShelfMaterialFromToFilter(filterInfo, "masterid.number", "material.number")) != null) {
            commDataQFilter.and(materialFilter);
        }
        if ((warehouseFilter = ReportCommonFilterOrChangeOp.getDynamicObjectFromToFilter(filterInfo, "warehouse.number", "warehousefrom", "warehouseto")) != null) {
            commDataQFilter.and(warehouseFilter);
        }
        if ((locationFilter = ReportCommonFilterOrChangeOp.getDynamicObjectFromToFilter(filterInfo, "location.number", "locationfrom", "locationto")) != null) {
            commDataQFilter.and(locationFilter);
        }
        if ((projectFilter = ReportCommonFilterOrChangeOp.getDynamicObjectFromToFilter(filterInfo, "project.number", "projectfrom", "projectto")) != null) {
            commDataQFilter.and(projectFilter);
        }
        if ((configuredCodeFilter = ReportCommonFilterOrChangeOp.getDynamicObjectFromToFilter(filterInfo, "configuredcode.number", "configuredcodefrom", "configuredcodeto")) != null) {
            commDataQFilter.and(configuredCodeFilter);
        }
        if ((tracknumberFilter = ReportCommonFilterOrChangeOp.getDynamicObjectFromToFilter(filterInfo, "tracknumber.number", "tracknumberfrom", "tracknumberto")) != null) {
            commDataQFilter.and(tracknumberFilter);
        }
        return commDataQFilter;
    }

    private QFilter getShelfMaterialFromToFilter(FilterInfo filterInfo, String filterName, String queryName) {
        DynamicObjectCollection materialFroms = filterInfo.getDynamicObjectCollection("materialnumberfrom");
        if (materialFroms != null && !materialFroms.isEmpty()) {
            if (materialFroms.size() > 1) {
                ArrayList<Object> materialNums = new ArrayList<Object>();
                for (DynamicObject materialFrom : materialFroms) {
                    Object materialNum = materialFrom.get(filterName);
                    materialNums.add(materialNum);
                }
                return new QFilter(queryName, "in", materialNums);
            }
            DynamicObject materialFrom = (DynamicObject)materialFroms.get(0);
            if (materialFrom == null) {
                return null;
            }
            Object materialNumFrom = materialFrom.get(filterName);
            QFilter fromFilter = new QFilter(queryName, ">=", materialNumFrom);
            DynamicObject materialTo = filterInfo.getDynamicObject("materialnumberto");
            if (materialTo == null) {
                return fromFilter;
            }
            Object materialNumTo = materialTo.get(filterName);
            QFilter toFilter = new QFilter(queryName, "<=", materialNumTo);
            return fromFilter.and(toFilter);
        }
        DynamicObject materialTo = filterInfo.getDynamicObject("materialnumberto");
        if (materialTo == null) {
            return null;
        }
        Object materialNumTo = materialTo.get(filterName);
        QFilter toFilter = new QFilter(queryName, "<=", materialNumTo);
        return toFilter;
    }

    private DataSet getShelfLifeAlysDataSet(QFilter targetFilters) {
        String entityInvbalance = "im_invbalance";
        if (BalanceUpdateHandle.isNewPeriodBal()) {
            entityInvbalance = InvAccConst.getBalTb();
        }
        DataSet defDataSet = QueryServiceHelper.queryDataSet((String)this.getClassName(), (String)entityInvbalance, (String)this.getInvBalanceCols(), (QFilter[])targetFilters.toArray(), (String)"");
        defDataSet = this.addExpiryDaysField(defDataSet);
        defDataSet = this.addShelfLifeDaysField(defDataSet);
        return defDataSet;
    }

    private DataSet addShelfLifeDaysField(DataSet defDataSet) {
        StringBuilder shelfLifeDaysSbf = new StringBuilder();
        shelfLifeDaysSbf.append("case when ");
        shelfLifeDaysSbf.append("producedate is null or expirydate is null ");
        shelfLifeDaysSbf.append("then ");
        shelfLifeDaysSbf.append("0 ");
        shelfLifeDaysSbf.append("else ");
        shelfLifeDaysSbf.append("DATEDIF(TO_DATE(TO_CHAR(producedate,'yyyy-MM-dd'),'yyyy-MM-dd'),TO_DATE(TO_CHAR(expirydate,'yyyy-MM-dd'),'yyyy-MM-dd'),'D') ");
        shelfLifeDaysSbf.append("end");
        defDataSet = defDataSet.addField(shelfLifeDaysSbf.toString(), "shelflifedays");
        return defDataSet;
    }

    private DataSet addExpiryDaysField(DataSet defDataSet) {
        StringBuilder expirydaysSbf = new StringBuilder();
        expirydaysSbf.append("case when ");
        expirydaysSbf.append("expirydate is null ");
        expirydaysSbf.append("then ");
        expirydaysSbf.append("0 ");
        expirydaysSbf.append("else ");
        expirydaysSbf.append("DATEDIF(TO_DATE(TO_CHAR(expirydate,'yyyy-MM-dd'),'yyyy-MM-dd'),TO_DATE(TO_CHAR(Now(),'yyyy-MM-dd'),'yyyy-MM-dd'),'D') ");
        expirydaysSbf.append("end");
        defDataSet = defDataSet.addField(expirydaysSbf.toString(), "expirydays");
        return defDataSet;
    }

    private DataSet setIsPreWarnShow(DataSet srcDataSet) {
        StringBuilder preWarnShowSbf = new StringBuilder();
        preWarnShowSbf.append("case when ");
        preWarnShowSbf.append("enablewarnlead = true and (DATEDIF(Now(),expirydate,'D') >= 0 and DATEDIF(Now(),expirydate,'D') < (warnleadtime * ");
        preWarnShowSbf.append("(case when leadtimeunit = 'day' then 1 when leadtimeunit = 'month' then 30 else 365 end))) ");
        preWarnShowSbf.append("then ");
        preWarnShowSbf.append("'1'");
        preWarnShowSbf.append("else ");
        preWarnShowSbf.append("'2' ");
        preWarnShowSbf.append("end");
        return srcDataSet.addField(preWarnShowSbf.toString(), "isprewarnshow");
    }

    private String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private DataSet reBuildShelfLifeAlysDataSet(FilterInfo filterInfo, DataSet srcDataSet) {
        DataSet classMaterialDataSet = this.getClassifiedMaterialDataSet(filterInfo);
        srcDataSet = srcDataSet.join(classMaterialDataSet, JoinType.INNER).on("material", "material").select(this.getSlfLifeJoinClassMaterCols()).finish();
        String ownerTypehead = filterInfo.getString("ownertypehead");
        if (!StringUtils.isEmpty((CharSequence)ownerTypehead)) {
            srcDataSet = ReportCommonFilterOrChangeOp.filterOwner(filterInfo, srcDataSet);
        }
        int slflifedaysfrom = filterInfo.getInt("shelflifedaysfrom");
        int slflifedaysto = filterInfo.getInt("shelflifedaysto");
        srcDataSet = this.addSlfLifeDaysFromToFilter(srcDataSet, slflifedaysfrom, slflifedaysto);
        String expiredisplayVal = filterInfo.getString("expiredisplay");
        srcDataSet = this.addExpireDisplayFilter(srcDataSet, expiredisplayVal);
        int expirydaysfrom = filterInfo.getInt("expirydaysfrom");
        int expirydaysto = filterInfo.getInt("expirydaysto");
        srcDataSet = this.addExpiryDaysFromToFilter(srcDataSet, expirydaysfrom, expirydaysto);
        srcDataSet = this.getShelfLifeMgrAccData(filterInfo, srcDataSet);
        srcDataSet = srcDataSet.filter("qty != 0 or baseqty != 0 or qty2nd != 0");
        srcDataSet = this.setIsPreWarnShow(srcDataSet);
        srcDataSet = srcDataSet.orderBy(this.getShelfLifeAlysOrderCols());
        return srcDataSet;
    }

    private DataSet getShelfLifeMgrAccData(FilterInfo filterInfo, DataSet srcDataSet) {
        QFilter mainQFilter = new QFilter("status", "=", (Object)"C");
        QFilter materialIdFilter = this.getShelfMaterialFromToFilter(filterInfo, "masterid.id", "masterid");
        if (materialIdFilter != null) {
            mainQFilter = mainQFilter.and(materialIdFilter);
        }
        HashSet<String> selectorSet = new HashSet<String>();
        selectorSet.add("masterid as materialId");
        selectorSet.add("enableshelflifemgr");
        selectorSet.add("enablewarnlead");
        selectorSet.add("warnleadtime");
        selectorSet.add("leadtimeunit");
        DataSet materialInvInfo = QueryServiceHelper.queryDataSet((String)this.getClassName(), (String)"bd_materialinventoryinfo", (String)String.join((CharSequence)",", selectorSet), (QFilter[])mainQFilter.toArray(), null).where("enableshelflifemgr = true").groupBy(materialSelect).finish();
        srcDataSet = srcDataSet.join(materialInvInfo, JoinType.INNER).on("material", "materialId").select(this.getSlfLifeJoinMaterInvStrategyCols()).finish();
        logger.info("select\u5b57\u6bb5\uff1a" + this.getSlfLifeJoinMaterInvStrategyCols());
        return srcDataSet;
    }

    private DataSet addExpiryDaysFromToFilter(DataSet srcDataSet, int expirydaysfrom, int expirydaysto) {
        String fromTofilter = null;
        if (expirydaysfrom != 0 && expirydaysto == 0) {
            fromTofilter = "expirydays >= " + expirydaysfrom;
        } else if (expirydaysto != 0) {
            fromTofilter = expirydaysfrom == 0 ? "expirydays <= " + expirydaysto : "expirydays >= " + expirydaysfrom + " and expirydays <= " + expirydaysto;
        }
        if (fromTofilter == null) {
            return srcDataSet;
        }
        return srcDataSet.filter(fromTofilter);
    }

    private DataSet addExpireDisplayFilter(DataSet srcDataSet, String expiredisplayVal) {
        String[] expiredisplays;
        String expDplayFilter = null;
        if (StringUtils.isNotEmpty((CharSequence)expiredisplayVal) && (expiredisplays = expiredisplayVal.split(",")).length == 2) {
            expDplayFilter = "0".equals(expiredisplays[1]) ? "expirydays >= 0" : "expirydays < 0";
        }
        if (expDplayFilter == null) {
            return srcDataSet;
        }
        return srcDataSet.filter(expDplayFilter);
    }

    private DataSet addSlfLifeDaysFromToFilter(DataSet srcDataSet, int slflifedaysfrom, int slflifedaysto) {
        String fromTofilter = null;
        if (slflifedaysfrom > 0 && slflifedaysto == 0) {
            fromTofilter = "shelflifedays >= " + slflifedaysfrom;
        } else if (slflifedaysto > 0) {
            if (slflifedaysfrom == 0) {
                fromTofilter = "shelflifedays <= " + slflifedaysto;
            } else if (slflifedaysfrom > 0) {
                fromTofilter = "shelflifedays >= " + slflifedaysfrom + " and shelflifedays <= " + slflifedaysto;
            }
        }
        if (fromTofilter == null) {
            return srcDataSet;
        }
        return srcDataSet.filter(fromTofilter);
    }

    private String getInvBalanceCols() {
        StringBuilder invBalancCols = new StringBuilder();
        invBalancCols.append("invtype,invstatus,");
        invBalancCols.append("material,auxpty,lotnum,");
        invBalancCols.append("producedate,expirydate,");
        invBalancCols.append("unit,qty,baseunit,");
        invBalancCols.append("baseqty,unit2nd,");
        invBalancCols.append("qty2nd,warehouse,");
        invBalancCols.append("location,org,owner,ownertype,");
        invBalancCols.append("keeper,keepertype,project,configuredcode,tracknumber");
        return invBalancCols.toString();
    }

    private String[] getSlfLifeJoinClassMaterCols() {
        StringBuilder joinCols = new StringBuilder();
        joinCols.append("invtype,invstatus,group,");
        joinCols.append("material,auxpty,lotnum,");
        joinCols.append("producedate,expirydate,shelflifedays,");
        joinCols.append("expirydays,unit,qty,baseunit,");
        joinCols.append("baseqty,unit2nd,");
        joinCols.append("qty2nd,warehouse,");
        joinCols.append("location,org,owner,ownertype,");
        joinCols.append("keeper,keepertype,project,configuredcode,tracknumber");
        return joinCols.toString().split(",");
    }

    private String[] getShelfLifeAlysOrderCols() {
        return "group,material,org,owner,keeper".split(",");
    }

    private String getJoinOnOrWhereCols() {
        return "enableshelflifemgr,enablewarnlead,warnleadtime,leadtimeunit";
    }

    private String[] getSlfLifeJoinMaterInvStrategyCols() {
        StringBuilder joinCols = new StringBuilder();
        joinCols.append(this.getJoinOnOrWhereCols());
        joinCols.append(',');
        joinCols.append(this.getShelfLifeRptListCols());
        return joinCols.toString().split(",");
    }

    private String getShelfLifeRptListCols() {
        StringBuilder tabHeadCols = new StringBuilder();
        tabHeadCols.append("invtype,invstatus,group,material,auxpty,");
        tabHeadCols.append("lotnum,producedate,expirydate,shelflifedays,");
        tabHeadCols.append("expirydays,unit,qty,baseunit,baseqty,unit2nd,");
        tabHeadCols.append("qty2nd,warehouse,location,org,owner,ownertype,");
        tabHeadCols.append("keeper,keepertype,project,configuredcode,tracknumber");
        return tabHeadCols.toString();
    }
}

