/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.balance;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.im.consts.InvAccConst;
import kd.scmc.im.report.balance.BalanceChecker;
import kd.scmc.im.report.balance.BalanceCheckerReport;

public class BalanceCheckerForm
extends AbstractReportFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void beforeQuery(ReportQueryParam pm) {
        super.beforeQuery(pm);
        FilterInfo filter = pm.getFilter();
        this.checkAndGetSelectCols(filter, "dimcol");
        this.checkAndGetSelectCols(filter, "qtycol");
    }

    private List<String> checkAndGetSelectCols(FilterInfo filter, String colName) {
        List<String> tempCols = BalanceChecker.parseCols(filter, colName);
        if (tempCols.isEmpty()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u201c%s\u201d\u3002", (String)"BalanceCheckerForm_0", (String)"scmc-im-report", (Object[])new Object[0]), this.getModel().getProperty(colName).getDisplayName().getLocaleValue()));
        }
        return tempCols;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initSelectCols();
    }

    private void initSelectCols() {
        BalanceTB tb = BalanceTB.getBalanceTB((String)InvAccConst.getBalTb());
        MainEntityType entity = MetadataServiceHelper.getDataEntityType((String)tb.getName());
        List keyCols = tb.getKeyCols();
        this.setColsSelectCombo("dimcol", keyCols, entity);
        Set occCols = tb.getOccCols();
        this.setColsSelectCombo("qtycol", occCols, entity);
    }

    private void setColsSelectCombo(String controlName, Collection<String> cols, MainEntityType entity) {
        ComboEdit combo = (ComboEdit)this.getControl(controlName);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(cols.size());
        for (String col : cols) {
            items.add(new ComboItem(entity.findProperty(col).getDisplayName(), col));
        }
        combo.setComboItems(items);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "showdataset": {
                this.showDataSet();
                break;
            }
        }
    }

    private void showDataSet() {
        try {
            DataSet data = new BalanceCheckerReport().query(this.getQueryParam(), null);
            data = data.top(10);
            StringBuilder msg = new StringBuilder();
            for (Row row : data) {
                msg.append(row.toString());
                msg.append("\r\n");
            }
            this.getView().showMessage(msg.toString());
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

