/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.balance;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.scmc.im.consts.InvAccConst;
import kd.scmc.im.report.balance.BalanceChecker;
import org.apache.commons.lang3.StringUtils;

public class BalanceCheckerReport
extends AbstractReportListDataPlugin {
    public static final String SUFFIX_FS = "_fs";
    private Set<String> hideCols;

    public DataSet query(ReportQueryParam param, Object arg) throws Throwable {
        FilterInfo filter = param.getFilter();
        List<String> dimCols = BalanceChecker.parseCols(filter, "dimcol");
        List<String> qtyCols = BalanceChecker.parseCols(filter, "qtycol");
        this.cacheHideCols(new HashSet<String>(dimCols), new HashSet<String>(qtyCols));
        List<QFilter> fs = this.parseFs(filter, dimCols);
        DataSet errorData = BalanceChecker.getErrorBalanceData(fs, dimCols, qtyCols);
        return errorData;
    }

    private List<QFilter> parseFs(FilterInfo filter, List<String> dimCols) {
        ArrayList<QFilter> fs = new ArrayList<QFilter>(dimCols.size());
        QFilter f = null;
        for (String dimCol : dimCols) {
            f = this.parseFs(filter, dimCol);
            if (f == null) continue;
            fs.add(f);
        }
        return fs;
    }

    private QFilter parseFs(FilterInfo filter, String dimCol) {
        FilterItemInfo item = filter.getFilterItem(dimCol + SUFFIX_FS);
        if (item == null) {
            return null;
        }
        Object value = item.getValue();
        if (value == null) {
            return null;
        }
        if (value instanceof DynamicObjectCollection) {
            DynamicObjectCollection datas = (DynamicObjectCollection)value;
            if (datas.isEmpty()) {
                return null;
            }
            ArrayList<Object> ids = new ArrayList<Object>(datas.size());
            for (DynamicObject data : datas) {
                ids.add(data.getPkValue());
            }
            if (ids.size() == 1) {
                return new QFilter(dimCol, "=", ids.get(0));
            }
            return new QFilter(dimCol, "in", ids);
        }
        if (value instanceof DynamicObject) {
            return new QFilter(dimCol, "=", ((DynamicObject)value).getPkValue());
        }
        if (value instanceof String && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{(String)value})) {
            return new QFilter(dimCol, "=", value);
        }
        return null;
    }

    private void cacheHideCols(Set<String> dimCols, Set<String> qtyCols) {
        HashSet<String> tempCols = new HashSet<String>();
        BalanceTB tb = BalanceTB.getBalanceTB((String)InvAccConst.getBalTb());
        List keyCols = tb.getKeyCols();
        for (String keyCol : keyCols) {
            if (dimCols.contains(keyCol)) continue;
            tempCols.add(keyCol);
        }
        Set occCols = tb.getOccCols();
        for (String occCol : occCols) {
            if (qtyCols.contains(occCol)) continue;
            tempCols.add("begin_" + occCol);
            tempCols.add("in_" + occCol);
            tempCols.add("out_" + occCol);
            tempCols.add("bal_" + occCol);
            tempCols.add("inv_" + occCol);
        }
        this.hideCols = tempCols;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        List cols = super.getColumns(columns);
        this.setVisible(cols);
        return cols;
    }

    private void setVisible(List<AbstractReportColumn> cols) {
        for (AbstractReportColumn col : cols) {
            if (col instanceof ReportColumn) {
                ReportColumn tempCol = (ReportColumn)col;
                String key = tempCol.getFieldKey();
                tempCol.setHide(this.hideCols.contains(key));
                continue;
            }
            if (!(col instanceof ReportColumnGroup)) continue;
            this.setVisible(((ReportColumnGroup)col).getChildren());
        }
    }
}

