/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.invacc;

import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ItemClassTypeEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.fs.util.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.FormatShowFilterEvent;
import kd.bos.report.events.SortAndFilterEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.im.business.helper.AuxptyFilterHelper;
import kd.scmc.im.business.helper.DataChangeHelper;
import kd.scmc.im.business.helper.LotMainFileHelper;
import kd.scmc.im.report.common.AnalyseReportConst;
import kd.scmc.im.report.common.ReportCommonFilterOrChangeOp;
import kd.scmc.im.report.helper.KeeperTypeViewHelper;
import kd.scmc.im.report.helper.OwnerTypeViewHelper;
import kd.scmc.im.report.invacc.InvAccRptBeforeF7Select;
import kd.scmc.im.report.invacc.InvAccRptPropChanged;
import kd.scmc.im.utils.DateUtils;
import kd.scmc.im.utils.FormUtils;

public class InvAccRptPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener,
BeforeF7SelectListener {
    protected static final String HAS_PERMISSION_AND_STARTED_INV_ORG = "HasPermissionAndStartedInvOrg";
    protected static final String ORGF7 = "ischange";
    public static final String MULTIORGHEADBYOWNER = "multiorgheadbyowner";
    public static final String MULTIORGHEADBYKEEPER = "multiorgheadbykeeper";
    public static final String RADIOGROUPFIELD = "radiogroupfield";
    public static final String RADIOGROUPFIELD_A = "A";
    public static final String RADIOGROUPFIELD_B = "B";
    public static final String RADIOGROUPFIELD_C = "C";
    public static final String IM_MULTITEXT = "im_multitext";
    public static final long DEFAULT_MASTERFILETYPEID = 1401417099242528768L;
    protected static List<String> headSortFieldList = Arrays.asList("material", "materialnames", "materialmodelnum", "group", "warehouse", "location", "invstatus", "invtype", "unit", "qty", "reserveqty", "avbbqty", "baseunit", "baseqty", "reservoeqty", "avbbaseqty", "unit2nd", "qty2nd", "reserveunit2ndqty", "avbbtndqty", "lotnum", "project", "producedate", "expirydate", "org", "ownertype", "owner", "keepertype", "keeper", "materialtype");
    protected final String algo = ((Object)((Object)this)).getClass().getName();
    public static final String CHECKSNMAINFILE = "checksnmainfile";
    public static final String SUPPLEMENTSN = "supplement";
    public static final String PAGE_INVACCSNMAINFILE = "sbs_invaccsnmainfile";
    public static final String PAGE_SNSUPPLEMENT = "sbs_snsupplement";
    public static final String INVACCID = "invaccid";

    private Map<String, Object> getHasPermOrgIds() {
        String userHasPermOrgs = this.getPageCache().get("hasPermOrgIds");
        if (userHasPermOrgs == null) {
            long userId = UserServiceHelper.getCurrentUserId();
            HasPermOrgResult userHasPermOrgIds = PermissionServiceHelper.getUserHasPermOrgs((long)userId);
            HashMap<String, Object> hasPermOrgMap = new HashMap<String, Object>(16);
            if (userHasPermOrgIds == null) {
                hasPermOrgMap.put("hasAllPermOrgs", true);
            } else {
                hasPermOrgMap.put("hasAllPermOrgs", userHasPermOrgIds.hasAllOrgPerm());
                hasPermOrgMap.put("hasPermOrgs", userHasPermOrgIds.getHasPermOrgs());
            }
            userHasPermOrgs = SerializationUtils.serializeToBase64(hasPermOrgMap);
            this.getPageCache().put("hasPermOrgIds", userHasPermOrgs);
        }
        return (Map)SerializationUtils.deSerializeFromBase64((String)userHasPermOrgs);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportlist = (ReportList)this.getView().getControl("reportlistap");
        reportlist.addHyperClickListener((HyperLinkClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"lotnumberfrom", "auxdetailbasebd"});
        FormUtils.addF7Listener((BeforeF7SelectListener)this, (String[])new String[]{"multiorghead", "accountownerfrom", "supplierownerfrom", "customerownerfrom", "ownerto", "accountkeeperfrom", "supplierkeeperfrom", "customerkeeperfrom", "keeperto", "materialgroupstandard", "materialgroupfrom", "materialgroupto", "materialnumberfrom", "materialnumberto", "warehousefrom", "warehouseto", "locationfrom", "locationto", "projectfrom", "projectto", "invstatushead", "ivntypehead", MULTIORGHEADBYOWNER, "auxproperty", "auxdetailbd", "configuredcodeto", "tracknumberto"});
        super.registerListener(e);
        this.addItemClickListeners(new String[]{CHECKSNMAINFILE});
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "checksnmainfile": {
                this.openSnInterface(PAGE_INVACCSNMAINFILE);
                break;
            }
            case "supplement": {
                this.openSnInterface(PAGE_SNSUPPLEMENT);
            }
        }
    }

    public void openSnInterface(String baseDataName) {
        ReportList reportList = (ReportList)this.getView().getControl("reportlistap");
        int[] selectedRows = reportList.getEntryState().getSelectedRows();
        if (selectedRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u540e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"InvAccRptPlugin_5", (String)"scmc-im-report", (Object[])new Object[0]));
            return;
        }
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(selectedRows[0]);
        Long id = rowData.getLong("id");
        DynamicObject material = rowData.getDynamicObject("material");
        if (material == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6548\u884c", (String)"InvAccRptPlugin_8", (String)"scmc-im-report", (Object[])new Object[0]));
            return;
        }
        Long invorg = (Long)rowData.getDynamicObject("org").getPkValue();
        long materialId = (Long)material.getPkValue();
        DynamicObject auxproperty = rowData.getDynamicObject("auxpty");
        long auxpty = auxproperty == null ? 0L : (Long)auxproperty.getPkValue();
        DynamicObject unit = rowData.getDynamicObject("unit");
        long unitId = unit == null ? 0L : (Long)unit.getPkValue();
        DynamicObject warehouse = rowData.getDynamicObject("warehouse");
        long warehouseId = warehouse == null ? 0L : (Long)warehouse.getPkValue();
        DynamicObject location = rowData.getDynamicObject("location");
        long locationId = location == null ? 0L : (Long)location.getPkValue();
        String lotnum = rowData.getString("lotnum");
        long qty = rowData.getLong("baseqty");
        HashMap<String, Object> stringObjectHashMap = new HashMap<String, Object>();
        stringObjectHashMap.put("formId", baseDataName);
        stringObjectHashMap.put("billtype", baseDataName);
        stringObjectHashMap.put(INVACCID, id);
        stringObjectHashMap.put("material", materialId);
        stringObjectHashMap.put("auxpty", auxpty);
        stringObjectHashMap.put("unitid", unitId);
        stringObjectHashMap.put("warehouseid", warehouseId);
        stringObjectHashMap.put("locationid", locationId);
        stringObjectHashMap.put("qty", qty);
        stringObjectHashMap.put("lotnum", lotnum);
        stringObjectHashMap.put("invorg", invorg);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)PAGE_SNSUPPLEMENT, (String)"id", (QFilter[])new QFilter[]{new QFilter(INVACCID, "=", (Object)id)});
        if (PAGE_SNSUPPLEMENT.equals(baseDataName)) {
            BaseShowParameter baseShowParameter = new BaseShowParameter();
            baseShowParameter.setCaption(ResManager.loadKDString((String)"\u8865\u5f55\u5e8f\u5217\u53f7", (String)"InvAccRptPlugin_7", (String)"scmc-im-report", (Object[])new Object[0]));
            baseShowParameter.setFormId(PAGE_SNSUPPLEMENT);
            if (dynamicObject != null) {
                Object pagePkValue = dynamicObject.getPkValue();
                baseShowParameter.setPkId(pagePkValue);
            }
            baseShowParameter.setCustomParams(stringObjectHashMap);
            baseShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm((FormShowParameter)baseShowParameter);
        } else {
            FormShowParameter formShowParameter = FormShowParameter.createFormShowParameter(stringObjectHashMap);
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u5e8f\u5217\u53f7", (String)"InvAccRptPlugin_6", (String)"scmc-im-report", (Object[])new Object[0]));
            IReportView view = this.getView();
            view.showForm(formShowParameter);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        HashMap prop = new HashMap(1);
        HashMap<String, Integer> editor = new HashMap<String, Integer>(1);
        editor.put("maxlength", 8000);
        prop.put("item", editor);
        this.getView().updateControlMetadata("lotnumberfrom", prop);
        OwnerTypeViewHelper.setEnableUI(this.getModel(), (IFormView)this.getView());
        KeeperTypeViewHelper.setEnableUI(this.getModel(), (IFormView)this.getView());
        this.getView().setVisible(Boolean.FALSE, new String[]{MULTIORGHEADBYKEEPER});
        this.getView().setVisible(Boolean.FALSE, new String[]{MULTIORGHEADBYOWNER});
        this.getView().setVisible(Boolean.TRUE, new String[]{"multiorghead"});
        AuxptyFilterHelper.setAuxEntryEnable((IDataModel)this.getModel(), (IFormView)this.getView());
    }

    public void loadOtherEntryFilter(DynamicObject scheme) {
        super.loadOtherEntryFilter(scheme);
        AuxptyFilterHelper.loadOtherEntryFilter((DynamicObject)scheme, (IDataModel)this.getModel(), (IReportView)this.getView());
    }

    public void setOtherEntryFilter(FilterInfo filterInfo) {
        AuxptyFilterHelper.setOtherEntryFilter((IDataModel)this.getModel(), (IReportView)this.getView());
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        BasedataEdit auxproperty = (BasedataEdit)this.getControl("auxproperty");
        auxproperty.setF7BatchFill(false);
        InvAccRptBeforeF7Select invAccRptBeforeF7Select = new InvAccRptBeforeF7Select((IFormView)this.getView());
        if (RADIOGROUPFIELD_A.equals(this.getView().getModel().getValue(RADIOGROUPFIELD))) {
            invAccRptBeforeF7Select.beforeF7Select(e, "multiorghead");
        } else {
            invAccRptBeforeF7Select.beforeF7Select(e, MULTIORGHEADBYOWNER);
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        AuxptyFilterHelper.setAuxEntryEnable((IDataModel)this.getModel(), (IFormView)this.getView());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        InvAccRptPropChanged invAccRptPropChanged = new InvAccRptPropChanged((IFormView)this.getView());
        invAccRptPropChanged.propertyChanged(e);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        queryParam.getFilter().addFilterItem("orgIdsString", this.getView().getFormShowParameter().getCustomParams().get(HAS_PERMISSION_AND_STARTED_INV_ORG));
        AuxptyFilterHelper.addAuxptyFilter((ReportQueryParam)queryParam, (IDataModel)this.getModel());
        Boolean queryZero = (Boolean)this.getModel().getValue("queryzero");
        queryParam.getFilter().addFilterItem("queryzero", (Object)queryZero);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        String formid;
        ReportShowParameter showParameter = (ReportShowParameter)e.getSource();
        Map<Boolean, String> hasPermission = ReportCommonFilterOrChangeOp.checkBillPermission(showParameter, formid = showParameter.getFormId());
        if (hasPermission.containsKey(Boolean.FALSE)) {
            e.setCancel(Boolean.TRUE.booleanValue());
            e.setCancelMessage(hasPermission.get(Boolean.FALSE));
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        ReportCommonFilterOrChangeOp.initMultiOrg(this.getView(), "multiorghead");
        this.initStandard();
        this.handleResetButtonEvent();
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        ReportList reportList = (ReportList)evt.getSource();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(rowIndex);
        String key = (String)reportList.getEntryState().getState().get("fieldKey");
        if ("lotnum".equals(key)) {
            this.showLotForm(rowData);
        } else if ("qty".equals(key)) {
            this.showInvBillDetailRpt(rowData);
        } else {
            DynamicObject object = (DynamicObject)rowData.get(key);
            Object pkValue = object.getPkValue();
            if ("material".equals(key)) {
                this.showMaterialForm(pkValue);
            }
            if ("warehouse".equals(key)) {
                this.showWareHouseForm(pkValue);
            }
        }
    }

    public void afterSetModelValue(DynamicObject scheme) {
        Object o;
        DynamicObjectCollection projectFrom;
        DynamicObjectCollection locationFrom;
        DynamicObjectCollection warehouseFrom;
        DynamicObjectCollection materiaNumFrom;
        if (scheme == null) {
            return;
        }
        this.setOrgByScheme(scheme, "multiorghead");
        this.setOrgByScheme(scheme, MULTIORGHEADBYOWNER);
        DataEntityPropertyCollection dataEntityPropertyCollection = scheme.getDataEntityType().getProperties();
        for (IDataEntityProperty property : dataEntityPropertyCollection) {
            String name = property.getName();
            if (MULTIORGHEADBYOWNER.equals(name) || "multiorghead".equals(name)) continue;
            if (RADIOGROUPFIELD.equals(name)) {
                Object radioValue = scheme.get(RADIOGROUPFIELD);
                this.getModel().setValue(RADIOGROUPFIELD, radioValue);
                this.handleRadioGroupFieldChagneEvent(radioValue);
                continue;
            }
            if ("auxentry".equals(name)) continue;
            DataChangeHelper.setValue((IDataModel)this.getModel(), (String)name, (Object)scheme.get(name), (boolean)false);
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObjectCollection materialGrpFrom = dataEntity.getDynamicObjectCollection("materialgroupfrom");
        if (materialGrpFrom.size() > 1) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"materialgroupto"});
        }
        if ((materiaNumFrom = dataEntity.getDynamicObjectCollection("materialnumberfrom")).size() > 1) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"materialnumberto"});
        }
        if ((warehouseFrom = dataEntity.getDynamicObjectCollection("warehousefrom")).size() > 1) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"warehouseto"});
        }
        if ((locationFrom = dataEntity.getDynamicObjectCollection("locationfrom")).size() > 1) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"locationto"});
        }
        if ((projectFrom = dataEntity.getDynamicObjectCollection("projectfrom")).size() > 1) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"projectto"});
        }
        if ((o = dataEntity.get("lotnumberfrom")) == null || "".equals(o)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"lotnumberto"});
        }
    }

    public void setSortAndFilter(List<SortAndFilterEvent> list) {
        super.setSortAndFilter(list);
        for (SortAndFilterEvent event : list) {
            if (!headSortFieldList.contains(event.getColumnName())) continue;
            event.setSort(true);
            event.setFilter(true);
        }
    }

    private void setOrgByScheme(DynamicObject scheme, String orgKey) {
        Object orgs = scheme.get(orgKey);
        Map<String, Object> hasPermOrgResult = this.getHasPermOrgIds();
        List hasPermOrgIds = (List)hasPermOrgResult.get("hasPermOrgs");
        if (!(orgs instanceof DynamicObjectCollection) || ((Boolean)hasPermOrgResult.get("hasAllPermOrgs")).booleanValue()) {
            this.getModel().setValue(orgKey, orgs);
        } else {
            DynamicObjectCollection orgCollection = (DynamicObjectCollection)orgs;
            Iterator orgIterator = orgCollection.iterator();
            DynamicObject orgCopy = null;
            while (orgIterator.hasNext()) {
                Long pkValue;
                DynamicObject org = (DynamicObject)orgIterator.next();
                if (org == null) {
                    orgIterator.remove();
                    continue;
                }
                if (orgCopy == null) {
                    orgCopy = org;
                }
                if (hasPermOrgIds.contains(pkValue = Long.valueOf(org.getLong("fbasedataid_id")))) continue;
                orgIterator.remove();
            }
            if (orgCollection.isEmpty() && orgCopy != null) {
                QFilter bizOrgFilter = OrgUnitServiceHelper.getBizOrgFilter((String)"05");
                bizOrgFilter.and("id", "in", (Object)hasPermOrgIds);
                Map orgMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (QFilter[])bizOrgFilter.toArray());
                DynamicObject org = (DynamicObject)orgMap.values().iterator().next();
                orgCopy.set("fbasedataid_id", org.getPkValue());
                orgCopy.set("fbasedataid", (Object)org);
                orgCollection.add((Object)orgCopy);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u4e2d\u5b58\u5728\u65e0\u6743\u9650\u7684\u5e93\u5b58\u7ec4\u7ec7\uff0c\u5df2\u4fee\u6539\u4e3a\u6709\u6743\u9650\u7684\u5e93\u5b58\u7ec4\u7ec7\uff0c\u8bf7\u91cd\u65b0\u4fdd\u5b58\u65b9\u6848\u3002", (String)"InvAccRptPlugin_3", (String)"scmc-im-report", (Object[])new Object[0]));
            }
            this.getModel().setValue(orgKey, (Object)orgCollection);
        }
    }

    private void handleRadioGroupFieldChagneEvent(Object radioValue) {
        if (RADIOGROUPFIELD_B.equals(radioValue)) {
            ((ItemClassTypeEdit)this.getView().getControl("ownertypehead")).setMustInput(true);
            this.getView().setVisible(Boolean.TRUE, new String[]{MULTIORGHEADBYOWNER});
            ((MulBasedataEdit)this.getView().getControl("multiorghead")).setMustInput(false);
            ((ItemClassTypeEdit)this.getView().getControl("keepertypehead")).setMustInput(false);
            this.getView().setVisible(Boolean.FALSE, new String[]{"multiorghead"});
            this.getView().setVisible(Boolean.FALSE, new String[]{MULTIORGHEADBYKEEPER});
        } else if (RADIOGROUPFIELD_C.equals(radioValue)) {
            ((ItemClassTypeEdit)this.getView().getControl("keepertypehead")).setMustInput(true);
            this.getView().setVisible(Boolean.TRUE, new String[]{MULTIORGHEADBYKEEPER});
            ((MulBasedataEdit)this.getView().getControl("multiorghead")).setMustInput(false);
            ((ItemClassTypeEdit)this.getView().getControl("ownertypehead")).setMustInput(false);
            this.getView().setVisible(Boolean.FALSE, new String[]{"multiorghead"});
            this.getView().setVisible(Boolean.FALSE, new String[]{MULTIORGHEADBYOWNER});
        } else {
            ((MulBasedataEdit)this.getView().getControl("multiorghead")).setMustInput(true);
            this.getView().setVisible(Boolean.TRUE, new String[]{"multiorghead"});
            ((ItemClassTypeEdit)this.getView().getControl("ownertypehead")).setMustInput(false);
            ((ItemClassTypeEdit)this.getView().getControl("keepertypehead")).setMustInput(false);
            this.getView().setVisible(Boolean.FALSE, new String[]{MULTIORGHEADBYKEEPER});
            this.getView().setVisible(Boolean.FALSE, new String[]{MULTIORGHEADBYOWNER});
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        FilterInfo filter = queryParam.getFilter();
        if (RADIOGROUPFIELD_A.equals(filter.getValue(RADIOGROUPFIELD))) {
            DynamicObjectCollection org = filter.getDynamicObjectCollection("multiorghead");
            if (org == null || org.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"InvAccRptPlugin_1", (String)"scmc-im-report", (Object[])new Object[0]));
                return false;
            }
        } else {
            if (RADIOGROUPFIELD_B.equals(filter.getValue(RADIOGROUPFIELD))) {
                return this.checkOwnerFromTo(filter);
            }
            if (RADIOGROUPFIELD_C.equals(filter.getValue(RADIOGROUPFIELD))) {
                return this.checkKeeperFromTo(filter);
            }
        }
        return true;
    }

    public void formatDisplayFilterField(FormatShowFilterEvent e) {
        ReportCommonFilterOrChangeOp.formatDisplayFilterField(e);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof TextEdit) {
            TextEdit textEdit = (TextEdit)source;
            String key = textEdit.getKey();
            if ("lotnumberfrom".equals(key)) {
                this.showLotnumber(key);
            } else if ("auxdetailbasebd".equals(key)) {
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl("auxentry");
                int[] selectRows = entryGrid.getSelectRows();
                this.getPageCache().put("clickIndex", String.valueOf(selectRows[0]));
                AuxptyFilterHelper.showAuxBaseForm((String)key, (int)selectRows[0], (IFormView)this.getView(), (IDataModel)this.getModel(), (IFormPlugin)this);
            }
        }
    }

    private void showLotnumber(String actionId) {
        IReportView view = this.getView();
        Object value = this.getModel().getValue(actionId);
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setTargetKey(actionId);
        parameter.setParentFormId(view.getFormShowParameter().getParentFormId());
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setCustomParam("params", value);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId(IM_MULTITEXT);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnDataObj = closedCallBackEvent.getReturnData();
        switch (actionId) {
            case "lotnumberfrom": {
                if (!(returnDataObj instanceof Map)) break;
                Map returnData = (Map)returnDataObj;
                String value = String.valueOf(returnData.get("content"));
                String operateType = String.valueOf(returnData.get("operateType"));
                if (!"btnok".equals(operateType)) break;
                value = value.replaceAll("\n", ",");
                this.getModel().setValue(actionId, (Object)value);
                break;
            }
            case "auxdetailbasebd": {
                String clickIndex = this.getPageCache().get("clickIndex");
                AuxptyFilterHelper.handleClosedCallBack((Object)returnDataObj, (IDataModel)this.getModel(), (String)clickIndex);
                break;
            }
        }
    }

    private void handleResetButtonEvent() {
        this.getView().setEnable(Boolean.TRUE, new String[]{"materialgroupto"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"materialnumberto"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"warehouseto"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"locationto"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"projectto"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"lotnumberto"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"configuredcodeto"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"tracknumberto"});
    }

    private void initStandard() {
        this.getModel().setValue("materialgroupstandard", (Object)AnalyseReportConst.INIT_MATERIALGROUPSTANDARD_ID);
    }

    private boolean checkOwnerFromTo(FilterInfo filter) {
        DynamicObject ownerto = filter.getDynamicObject("ownerto");
        if ("bos_org".equals(filter.getString("ownertypehead"))) {
            DynamicObjectCollection accountownerfrom = filter.getDynamicObjectCollection("accountownerfrom");
            if (accountownerfrom != null || ownerto != null) {
                return true;
            }
        } else if ("bd_customer".equals(filter.getString("ownertypehead"))) {
            DynamicObjectCollection customerownerfrom = filter.getDynamicObjectCollection("customerownerfrom");
            if (customerownerfrom != null || ownerto != null) {
                return true;
            }
        } else if ("bd_supplier".equals(filter.getString("ownertypehead"))) {
            DynamicObjectCollection supplierownerfrom = filter.getDynamicObjectCollection("supplierownerfrom");
            if (supplierownerfrom != null || ownerto != null) {
                return true;
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d27\u4e3b\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvAccRptPlugin_2", (String)"scmc-im-report", (Object[])new Object[0]));
            return false;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d27\u4e3b\u4ece\u548c\u8d27\u4e3b\u81f3\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\u3002", (String)"InvAccRptPlugin_0", (String)"scmc-im-report", (Object[])new Object[0]));
        return false;
    }

    private boolean checkKeeperFromTo(FilterInfo filter) {
        DynamicObject keeperto = filter.getDynamicObject("keeperto");
        if ("bos_org".equals(filter.getString("keepertypehead"))) {
            DynamicObjectCollection accountkeeperfrom = filter.getDynamicObjectCollection("accountkeeperfrom");
            if (accountkeeperfrom != null || keeperto != null) {
                return true;
            }
        } else if ("bd_customer".equals(filter.getString("keepertypehead"))) {
            DynamicObjectCollection customerkeeperfrom = filter.getDynamicObjectCollection("customerkeeperfrom");
            if (customerkeeperfrom != null || keeperto != null) {
                return true;
            }
        } else if ("bd_supplier".equals(filter.getString("keepertypehead"))) {
            DynamicObjectCollection supplierkeeperfrom = filter.getDynamicObjectCollection("supplierkeeperfrom");
            if (supplierkeeperfrom != null || keeperto != null) {
                return true;
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fdd\u7ba1\u8005\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvAccRptPlugin_20", (String)"scmc-im-report", (Object[])new Object[0]));
            return false;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fdd\u7ba1\u8005\u4ece\u548c\u4fdd\u7ba1\u8005\u81f3\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\u3002", (String)"InvAccRptPlugin_21", (String)"scmc-im-report", (Object[])new Object[0]));
        return false;
    }

    protected Object getOrgId() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("orgfield");
        if (org == null) {
            return null;
        }
        return org.getPkValue();
    }

    private void showWareHouseForm(Object pkValue) {
        this.createBaseDataView(pkValue, "bd_warehouse");
    }

    private void showMaterialForm(Object pkValue) {
        this.createBaseDataView(pkValue, "bd_material");
    }

    private void showLotForm(DynamicObject rowData) {
        if (LotMainFileHelper.isUseLotMainFile()) {
            String lotnum = rowData.getString("lotnum");
            if (StringUtils.isNotEmpty((String)lotnum)) {
                DynamicObject lot;
                Object materialid = rowData.getDynamicObject("material").getPkValue();
                Object orgid = rowData.getDynamicObject("org").getPkValue();
                int unqCtrl = LotMainFileHelper.getUnqctrl();
                QFilter filter = new QFilter("number", "=", (Object)lotnum).and("material", "=", materialid).and("masterfiletype", "=", (Object)1401417099242528768L);
                if (unqCtrl == 3 || unqCtrl == 4) {
                    filter.and("createorg", "=", orgid);
                }
                if ((lot = QueryServiceHelper.queryOne((String)"bd_lot", (String)"id", (QFilter[])filter.toArray())) != null) {
                    Long lotid = lot.getLong("id");
                    this.createBaseDataView(lotid, "bd_lot");
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u4e0d\u5230\u6279\u53f7\u4e3b\u6863\u3002", (String)"InvAccRptPlugin_9", (String)"scmc-im-report", (Object[])new Object[0]));
                }
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u542f\u7528\u6279\u53f7\u4e3b\u6863\u3002", (String)"InvAccRptPlugin_10", (String)"scmc-im-report", (Object[])new Object[0]));
        }
    }

    private void createBaseDataView(Object pkValue, String entityid) {
        IReportView view = this.getView();
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setPkId(pkValue);
        parameter.getOpenStyle().setTargetKey("tabap");
        parameter.setParentFormId(view.getFormShowParameter().getParentFormId());
        parameter.setStatus(OperationStatus.VIEW);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setAppId(null);
        parameter.setFormId(entityid);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void showInvBillDetailRpt(DynamicObject rowData) {
        ReportShowParameter rsp = new ReportShowParameter();
        this.setInvBillReportFilterValue(rowData);
        rsp.setQueryParam(this.getQueryParam());
        Map customParams = rsp.getCustomParams();
        customParams.put("hyperlinkFromInvAccRpt", "hyperlinkFromInvAccRpt");
        DynamicObject auxpty = rowData.getDynamicObject("auxpty");
        if (auxpty != null) {
            customParams.put("auxpty", rowData.getDynamicObject("auxpty").getPkValue());
        }
        rsp.setFormId("im_invbillreport");
        rsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)rsp);
    }

    public void packageData(PackageDataEvent evt) {
        DynamicObject rowData = evt.getRowData();
        DynamicObject material = rowData.getDynamicObject("material");
        String fieldKey = ((ReportColumn)evt.getSource()).getFieldKey();
        if (material == null && "qty".equals(fieldKey)) {
            evt.getNoLinkKey().add("qty");
        }
    }

    private void setInvBillReportFilterValue(DynamicObject rowData) {
        FilterInfo filterInfo = this.getQueryParam().getFilter();
        DynamicObject orgHyperLink = rowData.getDynamicObject("org");
        if (orgHyperLink != null) {
            filterInfo.addFilterItem("multiorghead", orgHyperLink.getPkValue());
            filterInfo.addFilterItem("orghead", orgHyperLink.getPkValue());
        }
        Date date = new Date();
        filterInfo.addFilterItem("startdate", (Object)DateUtils.addDay((Date)date, (int)-6));
        filterInfo.addFilterItem("enddate", (Object)date);
        this.addOwnerKeeperInfo(rowData, filterInfo, "ownertype", "owner");
        this.addOwnerKeeperInfo(rowData, filterInfo, "keepertype", "keeper");
        this.addBaseDataInfo(rowData, filterInfo, "invtype", "ivntypehead");
        this.addBaseDataInfo(rowData, filterInfo, "invstatus", "invstatushead");
        filterInfo.addFilterItem("materialtypehead", rowData.get("materialtype"));
        this.addDynamicObjectInfo(rowData, filterInfo, "group", "materialgroupfrom", "materialgroupto");
        this.addDynamicObjectInfo(rowData, filterInfo, "material", "materialnumberfrom", "materialnumberto");
        this.addDynamicObjectInfo(rowData, filterInfo, "warehouse", "warehousefrom", "warehouseto");
        this.addDynamicObjectInfo(rowData, filterInfo, "location", "locationfrom", "locationto");
        this.addDynamicObjectInfo(rowData, filterInfo, "project", "projectfrom", "projectto");
        this.addDynamicObjectInfo(rowData, filterInfo, "configuredcode", "configuredcodefrom", "configuredcodeto");
        this.addDynamicObjectInfo(rowData, filterInfo, "tracknumber", "tracknumberfrom", "tracknumberto");
        String lotNumberLink = rowData.getString("lotnum");
        if (lotNumberLink != null && !lotNumberLink.isEmpty()) {
            filterInfo.addFilterItem("lotnumberfrom", (Object)lotNumberLink);
            filterInfo.addFilterItem("lotnumberto", (Object)lotNumberLink);
        }
    }

    private void addDynamicObjectInfo(DynamicObject rowData, FilterInfo filterInfo, String rowDataKey, String rptFromKey, String rptToKey) {
        DynamicObject materialGroupTypeLink = rowData.getDynamicObject(rowDataKey);
        if (materialGroupTypeLink != null) {
            filterInfo.addFilterItem(rptFromKey, (Object)materialGroupTypeLink);
            filterInfo.addFilterItem(rptToKey, (Object)materialGroupTypeLink);
        }
    }

    private void addBaseDataInfo(DynamicObject rowData, FilterInfo filterInfo, String rowDataKey, String rptKey) {
        DynamicObject invTypeLink = rowData.getDynamicObject(rowDataKey);
        if (invTypeLink != null) {
            filterInfo.addFilterItem(rptKey, (Object)invTypeLink);
        }
    }

    private void addOwnerKeeperInfo(DynamicObject rowData, FilterInfo filterInfo, String type, String key) {
        String ownerTypeHeadLink = rowData.getString(type);
        boolean isOwner = "owner".equals(key);
        if (ownerTypeHeadLink != null && !ownerTypeHeadLink.isEmpty()) {
            DynamicObject ownerLink = rowData.getDynamicObject(key);
            filterInfo.addFilterItem(isOwner ? "ownerto" : "keeperto", (Object)ownerLink);
            filterInfo.addFilterItem(isOwner ? "ownertypehead" : "keepertypehead", (Object)ownerTypeHeadLink);
            switch (ownerTypeHeadLink) {
                case "bos_org": {
                    filterInfo.addFilterItem(isOwner ? "accountownerfrom" : "accountkeeperfrom", (Object)ownerLink);
                    break;
                }
                case "bd_supplier": {
                    filterInfo.addFilterItem(isOwner ? "supplierownerfrom" : "supplierkeeperfrom", (Object)ownerLink);
                    break;
                }
                case "bd_customer": {
                    filterInfo.addFilterItem(isOwner ? "customerownerfrom" : "customerkeeperfrom", (Object)ownerLink);
                    break;
                }
            }
        }
    }
}

