/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.invacc;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.datatype.BigDecimalType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.business.helper.AuxptyFilterHelper;
import kd.scmc.im.business.helper.SupplyChainParameterHelper;
import kd.scmc.im.consts.InvAccConst;
import kd.scmc.im.report.common.ReportCommonFilterOrChangeOp;
import kd.scmc.im.report.helper.ReportGeneralOpHelper;
import kd.scmc.sbs.business.reservation.ReserveHelper;

public class InvAccRptQuery
extends AbstractReportListDataPlugin {
    private String algoKey = ((Object)((Object)this)).getClass().getName();
    private static Log logger = LogFactory.getLog(InvAccRptQuery.class);
    protected static final List<String> fieldList = Arrays.asList("warehouse", "invstatus", "invtype", "unit", "baseunit", "org");
    protected static final List<String> idList = Arrays.asList("location", "project", "unit2nd");
    protected static final List<String> qtyFieldList = Arrays.asList("qty", "baseqty", "qty2nd", "avbbtndqty", "reserveunit2ndqty", "avbbaseqty", "reservoeqty", "avbbqty", "reserveqty");
    protected static final String[] defaultOrderOrg = new String[]{"org", "owner"};
    protected static final String[] defaultOrderOwner = new String[]{"org", "owner"};
    private static final String[] RESERVE_SP_FIELDS = new String[]{"case when spbaseqty is null then 0 else spbaseqty end as spbaseqty", "case when spqty is null then 0 else spqty end as spqty", "case when spqty2nd is null then 0 else spqty2nd end as spqty2nd"};
    private static final String FILED_INVID = "invid";

    public DataSet query(ReportQueryParam queryParam, Object arg1) throws Throwable {
        List auxptyFilter;
        FilterInfo filterInfo = queryParam.getFilter();
        List<Object> qFilters = new ArrayList();
        if ("A".equals(filterInfo.getString("radiogroupfield"))) {
            String orgLogo = "multiorghead";
            qFilters = this.buildInvAccPartFilter(queryParam, filterInfo, orgLogo, true);
        } else if ("B".equals(filterInfo.getString("radiogroupfield"))) {
            String orgLogo = "multiorgheadbyowner";
            qFilters = this.buildInvAccPartFilter(queryParam, filterInfo, orgLogo, false);
        } else if ("C".equals(filterInfo.getString("radiogroupfield"))) {
            String orgLogo = "multiorgheadbykeeper";
            qFilters = this.buildInvAccPartFilter(queryParam, filterInfo, orgLogo, false);
        }
        List<QFilter> headFilters = this.buildHeadFilters(queryParam);
        List<QFilter> addNullFilter = this.addNullFilter(headFilters);
        if (addNullFilter.size() != 0) {
            qFilters.addAll(addNullFilter);
        }
        if (null != (auxptyFilter = AuxptyFilterHelper.buildAuxptyFilter((ReportQueryParam)queryParam)) && !auxptyFilter.isEmpty()) {
            qFilters.addAll(auxptyFilter);
        }
        DataSet invAccDataSet = QueryServiceHelper.queryDataSet((String)this.algoKey, (String)InvAccConst.getBalTb(), (String)String.join((CharSequence)",", this.buildSelectorAcc()), (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]), (String)"");
        DataSet materialRelatedDataSet = ReportCommonFilterOrChangeOp.getClassifiedMaterialDataSet(filterInfo, true);
        invAccDataSet = materialRelatedDataSet.leftJoin(invAccDataSet).on("material", "material").select(ReportGeneralOpHelper.addFileds(this.getDataSetFieldArray(invAccDataSet), "group", "groupname", "materialtype")).finish();
        invAccDataSet = invAccDataSet.filter("org is not null");
        invAccDataSet = this.filterMaterialGroup(invAccDataSet, queryParam);
        invAccDataSet = ReportCommonFilterOrChangeOp.filterOwner(filterInfo, invAccDataSet);
        invAccDataSet = ReportCommonFilterOrChangeOp.filterKeeper(filterInfo, invAccDataSet);
        invAccDataSet = ReserveHelper.getAvbbaseqty((DataSet)invAccDataSet);
        invAccDataSet = this.mergeReserveQty(invAccDataSet);
        String sortInfo = queryParam.getSortInfo();
        invAccDataSet = invAccDataSet.orderBy(InvAccRptQuery.orderByMultiorgQuery(filterInfo, sortInfo));
        invAccDataSet = invAccDataSet.union(this.getSumData(invAccDataSet));
        String qtyFilterString = this.getQtyFilter(queryParam);
        if (!"".equals(qtyFilterString)) {
            invAccDataSet = invAccDataSet.filter(qtyFilterString);
        }
        return invAccDataSet;
    }

    private DataSet filterMaterialGroup(DataSet dataSet, ReportQueryParam queryParam) {
        List headFilters = queryParam.getFilter().getHeadFilters();
        for (QFilter filter : headFilters) {
            String property = filter.getProperty();
            if (!"group".equals(property)) continue;
            String cp = filter.getCP();
            if ("is null".equals(cp)) {
                String str = new QFilter(property, "=", (Object)0).toString();
                dataSet = dataSet.filter(str);
                break;
            }
            if ("is not null".equals(cp)) {
                String str = new QFilter(property, "!=", (Object)0).toString();
                dataSet = dataSet.filter(str);
                break;
            }
            property = "groupname";
            filter.__setProperty(property);
            List nests = filter.getNests(true);
            for (QFilter.QFilterNest net : nests) {
                QFilter netFilter = net.getFilter();
                netFilter.__setProperty(property);
            }
            String filterStr = filter.toString();
            if (filterStr == null || "".equals(filterStr.trim())) continue;
            dataSet = dataSet.filter(filterStr);
            break;
        }
        return dataSet;
    }

    private List<QFilter> addNullFilter(List<QFilter> headFilters) {
        ArrayList<QFilter> addNullFilter = new ArrayList<QFilter>(headFilters.size());
        for (QFilter filter : headFilters) {
            String property = filter.getProperty();
            String cp = filter.getCP();
            if (idList.contains(property)) {
                List<Object> dynIds;
                if (cp.equals("is null")) {
                    addNullFilter.add(new QFilter(property, "=", (Object)0));
                    continue;
                }
                if (cp.equals("is not null")) {
                    addNullFilter.add(new QFilter(property, "!=", (Object)0));
                    continue;
                }
                if (cp.contains("like")) {
                    addNullFilter.add(new QFilter(property + ".name", cp, filter.getValue()));
                    continue;
                }
                Object value = filter.getValue();
                if (value instanceof String) {
                    value = ((String)value).replace("%", "");
                }
                QFilter nameFilter = new QFilter("name", "=", value);
                String entityName = this.getEntity(property);
                DynamicObject[] dyns = BusinessDataServiceHelper.load((String)entityName, (String)"id,name", (QFilter[])nameFilter.toArray());
                if (null == dyns || dyns.length == 0 || (dynIds = this.getIds(dyns)).isEmpty()) continue;
                if (dynIds.size() > 1) {
                    if (cp.equals("=")) {
                        cp = "in";
                    } else if (cp.equals("!=")) {
                        cp = "not in";
                    }
                }
                addNullFilter.add(new QFilter(property, cp, dynIds));
                continue;
            }
            addNullFilter.add(filter);
        }
        return addNullFilter;
    }

    private List<Object> getIds(DynamicObject[] dyns) {
        ArrayList<Object> dynIds = new ArrayList<Object>(dyns.length);
        for (DynamicObject dyn : dyns) {
            dynIds.add(dyn.getPkValue());
        }
        return dynIds;
    }

    private String getEntity(String property) {
        String entityName = "";
        switch (property) {
            case "location": {
                entityName = "bd_location";
                break;
            }
            case "project": {
                entityName = "bd_project";
                break;
            }
            case "unit2nd": {
                entityName = "bd_measureunits";
                break;
            }
        }
        return entityName;
    }

    private String getQtyFilter(ReportQueryParam queryParam) {
        List headFilters = queryParam.getFilter().getHeadFilters();
        StringBuilder buf = new StringBuilder();
        int j = 0;
        for (int i = 0; i < headFilters.size(); ++i) {
            QFilter filter = (QFilter)headFilters.get(i);
            String property = filter.getProperty();
            if (!qtyFieldList.contains(property)) continue;
            String CP = filter.getCP();
            Object value = filter.getValue();
            String decimalVal = new BigDecimal(value.toString()).setScale(10).toPlainString();
            String singleFilterString = property + CP + decimalVal;
            if (j > 0) {
                buf.append(" and ");
            }
            buf.append(singleFilterString);
            ++j;
        }
        return buf.toString();
    }

    private List<QFilter> buildHeadFilters(ReportQueryParam queryParam) {
        List headFilters = queryParam.getFilter().getHeadFilters();
        Iterator it = headFilters.iterator();
        while (it.hasNext()) {
            QFilter filter = (QFilter)it.next();
            if (qtyFieldList.contains(filter.getProperty())) {
                it.remove();
            }
            if (!"group".equals(filter.getProperty())) continue;
            it.remove();
        }
        for (QFilter filter : headFilters) {
            this.rebuildFilter(filter);
            List nests = filter.getNests(true);
            for (QFilter.QFilterNest net : nests) {
                QFilter netFilter = net.getFilter();
                this.rebuildFilter(netFilter);
            }
        }
        return headFilters;
    }

    private void rebuildFilter(QFilter filter) {
        String property = filter.getProperty();
        if (fieldList.contains(property)) {
            property = property + ".name";
            filter.__setProperty(property);
        } else if ("producedate".equals(property) || "expirydate".equals(property)) {
            this.dateFormat(filter);
        } else {
            switch (property) {
                case "material": {
                    property = "material.number";
                    break;
                }
                case "materialnames": {
                    property = "material.name";
                    break;
                }
                case "materialmodelnum": {
                    property = "material.modelnum";
                    break;
                }
            }
            filter.__setProperty(property);
        }
    }

    private void dateFormat(QFilter filter) {
        Object dateValue = filter.getValue();
        if (dateValue instanceof String) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                Date date = simpleDateFormat.parse((String)dateValue);
                filter.__setValue((Object)date);
            }
            catch (ParseException e) {
                logger.error("SimpleDateFormat\u8f6c\u6362date\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    private static String[] orderByMultiorgQuery(FilterInfo filterInfo, String sortInfo) {
        String[] orderBy = "A".equals(filterInfo.getString("radiogroupfield")) ? defaultOrderOrg : defaultOrderOwner;
        if (null != sortInfo) {
            List<String> sortInfoList = Arrays.asList(sortInfo.split(" "));
            if (sortInfoList.contains("material")) {
                sortInfo = sortInfo.replace("material", "material.number");
            }
            ArrayList<String> orderByList = new ArrayList<String>(Arrays.asList(orderBy));
            orderByList.add(0, sortInfo);
            orderBy = orderByList.toArray(new String[orderByList.size()]);
        }
        return orderBy;
    }

    protected String[] getDataSetFieldArray(DataSet dataSet) {
        Set<String> fileds = ReportGeneralOpHelper.getDataSetField(dataSet);
        return fileds.toArray(new String[fileds.size()]);
    }

    private DataSet getSumData(DataSet dataSet) {
        Field[] fields = dataSet.getRowMeta().getFields();
        ArrayList<String> sumFieldsList = new ArrayList<String>();
        ArrayList<String> nullFieldsList = new ArrayList<String>();
        ArrayList<String> allFieldsList = new ArrayList<String>(fields.length);
        for (Field field : fields) {
            if (field.getDataType() instanceof BigDecimalType) {
                sumFieldsList.add(field.getAlias());
            } else if (!"summarytype".equals(field.getName()) && !"materialnames".equals(field.getName())) {
                nullFieldsList.add(field.getAlias());
            }
            allFieldsList.add(field.getAlias());
        }
        String[] groupFields = new String[]{};
        GroupbyDataSet gpRs = dataSet.groupBy(groupFields);
        sumFieldsList.forEach(f -> gpRs.sum(f));
        dataSet = gpRs.finish();
        for (String string : nullFieldsList) {
            dataSet = dataSet.addNullField(string);
        }
        dataSet = dataSet.addField(String.format(ResManager.loadKDString((String)"%1$s\u5408\u8ba1%2$s", (String)"InvAccRptQuery_0", (String)"scmc-im-report", (Object[])new Object[0]), "'", "'"), "materialnames");
        dataSet = dataSet.addField(String.format("'%s'", 3), "summarytype");
        dataSet = dataSet.select(allFieldsList.toArray(new String[allFieldsList.size()]));
        return dataSet;
    }

    private List<String> buildSelectorAcc() {
        ArrayList<String> selectorList = new ArrayList<String>();
        Set selectorSet = EntityMetadataCache.getDataEntityType((String)InvAccConst.getBalTb()).getAllFields().keySet();
        selectorList.addAll(selectorSet);
        selectorList.add("'0' as summarytype");
        selectorList.add("id");
        selectorList.add("location.id as flocationid");
        selectorList.add("material.number");
        selectorList.add("material.name as materialnames");
        selectorList.add("warehouse.number");
        selectorList.add("material.modelnum as modelnum");
        selectorList.add("material.modelnum as materialmodelnum");
        if (!selectorList.contains("material")) {
            selectorList.add("material");
        }
        return selectorList;
    }

    protected List<QFilter> buildInvAccPartFilter(ReportQueryParam queryParam, FilterInfo filterInfo, String orgLogo, boolean orgIsMust) {
        QFilter tracknumberFilter;
        QFilter configuredCodeFilter;
        QFilter materialFilter;
        Boolean queryZero;
        QFilter projectFilter;
        QFilter lotnumberFilter;
        QFilter locationFilter;
        QFilter warehouseFilter;
        DynamicObjectCollection invStatusHeads;
        DynamicObjectCollection ivnTypeHeads;
        String keeperTypeHead;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        DynamicObjectCollection org = (DynamicObjectCollection)filterInfo.getValue(orgLogo);
        if (org == null || org.size() == 0 && !orgIsMust) {
            String orgIdsString = (String)filterInfo.getValue("orgIdsString");
            List orgIds = SerializationUtils.fromJsonStringToList((String)orgIdsString, Long.class);
            qFilters.add(new QFilter("org", "in", (Object)orgIds));
        } else {
            ArrayList<Long> orgIds = new ArrayList<Long>();
            for (DynamicObject dynamicObject : org) {
                orgIds.add((Long)dynamicObject.getPkValue());
            }
            qFilters.add(new QFilter("org", "in", orgIds));
        }
        String ownerTypeHead = filterInfo.getString("ownertypehead");
        if (ownerTypeHead != null && !ownerTypeHead.trim().equals("")) {
            QFilter ownerTypeFilter = new QFilter("ownertype", "=", (Object)ownerTypeHead);
            qFilters.add(ownerTypeFilter);
        }
        if ((keeperTypeHead = filterInfo.getString("keepertypehead")) != null && !keeperTypeHead.trim().equals("")) {
            QFilter keeperTypeFilter = new QFilter("keepertype", "=", (Object)keeperTypeHead);
            qFilters.add(keeperTypeFilter);
        }
        if ((ivnTypeHeads = filterInfo.getDynamicObjectCollection("ivntypehead")) != null && ivnTypeHeads.size() > 0) {
            HashSet<Object> ivnTypeIds = new HashSet<Object>();
            for (Iterator ivnType : ivnTypeHeads) {
                ivnTypeIds.add(ivnType.getPkValue());
            }
            QFilter ivnTypeHeadFilter = new QFilter("invtype", "in", ivnTypeIds);
            qFilters.add(ivnTypeHeadFilter);
        }
        if ((invStatusHeads = filterInfo.getDynamicObjectCollection("invstatushead")) != null && invStatusHeads.size() > 0) {
            HashSet<Object> ivnStatusIds = new HashSet<Object>();
            for (DynamicObject invStatus : invStatusHeads) {
                ivnStatusIds.add(invStatus.getPkValue());
            }
            QFilter ivnStatusHeadFilter = new QFilter("invstatus", "in", ivnStatusIds);
            qFilters.add(ivnStatusHeadFilter);
        }
        if ((warehouseFilter = ReportCommonFilterOrChangeOp.getDynamicObjectFromToFilter(filterInfo, "warehouse.number", "warehousefrom", "warehouseto")) != null) {
            qFilters.add(warehouseFilter);
        }
        if ((locationFilter = ReportCommonFilterOrChangeOp.getDynamicObjectFromToFilter(filterInfo, "location.number", "locationfrom", "locationto")) != null) {
            qFilters.add(locationFilter);
        }
        if ((lotnumberFilter = ReportCommonFilterOrChangeOp.getTextFromToFilter(filterInfo, "lotnum", "lotnumberfrom", "lotnumberto")) != null) {
            qFilters.add(lotnumberFilter);
        }
        if ((projectFilter = ReportCommonFilterOrChangeOp.getDynamicObjectFromToFilter(filterInfo, "project.number", "projectfrom", "projectto")) != null) {
            qFilters.add(projectFilter);
        }
        if (!(queryZero = Boolean.valueOf(filterInfo.getBoolean("queryzero"))).booleanValue()) {
            qFilters.add(this.addInvAccNotZeroFilter());
        }
        if (null != (materialFilter = ReportCommonFilterOrChangeOp.getMaterialFromToFilter(filterInfo, "material", true))) {
            qFilters.add(materialFilter);
        }
        if (null != (configuredCodeFilter = ReportCommonFilterOrChangeOp.getDynamicObjectFromToFilter(filterInfo, "configuredcode.number", "configuredcodefrom", "configuredcodeto"))) {
            qFilters.add(configuredCodeFilter);
        }
        if ((tracknumberFilter = ReportCommonFilterOrChangeOp.getDynamicObjectFromToFilter(filterInfo, "tracknumber.number", "tracknumberfrom", "tracknumberto")) != null) {
            qFilters.add(tracknumberFilter);
        }
        return qFilters;
    }

    private QFilter addInvAccNotZeroFilter() {
        QFilter qtyFilter = new QFilter("baseqty", "<>", (Object)0);
        qtyFilter.or(new QFilter("qty", "<>", (Object)0));
        qtyFilter.or(new QFilter("qty2nd", "<>", (Object)0));
        return qtyFilter;
    }

    private DataSet mergeReserveQty(DataSet invAccDataSet) {
        if (!SupplyChainParameterHelper.getScmParam()) {
            return invAccDataSet;
        }
        ArrayList invIdList = new ArrayList();
        DataSet copy = invAccDataSet.copy();
        copy.forEach(item -> invIdList.add(item.getLong("id")));
        if (invIdList.size() == 0) {
            return invAccDataSet;
        }
        QFilter spFilter = new QFilter(FILED_INVID, "in", invIdList);
        DataSet spDataSet = QueryServiceHelper.queryDataSet((String)"InvAccRptQuery.mergeReserveQty", (String)"msmod_reserve_bal_sp", (String)"invid,baseqty as spbaseqty,qty as spqty ,qty2nd as spqty2nd", (QFilter[])spFilter.toArray(), null);
        if (!spDataSet.hasNext()) {
            return invAccDataSet;
        }
        spDataSet = spDataSet.groupBy(new String[]{FILED_INVID}).sum("spbaseqty").sum("spqty").sum("spqty2nd").finish();
        String[] invaccFields = invAccDataSet.getRowMeta().getFieldNames();
        DataSet qty = invAccDataSet.join(spDataSet, JoinType.LEFT).on("id", FILED_INVID).select(invaccFields, RESERVE_SP_FIELDS).finish();
        DataSet select = this.calReverseQty(qty);
        return this.calAvbQty(select);
    }

    private DataSet calAvbQty(DataSet select) {
        String[] invFieldNames = select.getRowMeta().getFieldNames();
        for (int i = 0; i < invFieldNames.length; ++i) {
            if ("avbbaseqty".equals(invFieldNames[i])) {
                invFieldNames[i] = "(baseqty-reservebaseqty) as avbbaseqty";
            }
            if ("avbbqty".equals(invFieldNames[i])) {
                invFieldNames[i] = "(qty-reserveqty) as avbbqty";
            }
            if ("avbbtndqty".equals(invFieldNames[i])) {
                invFieldNames[i] = "(qty2nd-reserveunit2ndqty) as avbbtndqty";
            }
            if (!"reservoeqty".equals(invFieldNames[i])) continue;
            invFieldNames[i] = "reservebaseqty as reservoeqty";
        }
        return select.select(invFieldNames);
    }

    private DataSet calReverseQty(DataSet qty) {
        String[] spFieldNames = qty.getRowMeta().getFieldNames();
        for (int i = 0; i < spFieldNames.length; ++i) {
            if ("reserveqty".equals(spFieldNames[i])) {
                spFieldNames[i] = "(reserveqty + spqty) AS reserveqty";
            }
            if ("reservebaseqty".equals(spFieldNames[i])) {
                spFieldNames[i] = "(spbaseqty + reservebaseqty) AS reservebaseqty";
            }
            if (!"reserveunit2ndqty".equals(spFieldNames[i])) continue;
            spFieldNames[i] = "(spqty2nd + reserveunit2ndqty) AS reserveunit2ndqty";
        }
        return qty.select(spFieldNames);
    }
}

