/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.invbillagereport;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.scmc.im.business.helper.BizTypeHelper;
import kd.scmc.im.report.common.ReportCommonFilterOrChangeOp;

public class InvBillAgeRptBeforeF7Select {
    private IFormView view = null;

    public InvBillAgeRptBeforeF7Select(IFormView view) {
        this.view = view;
    }

    public void beforeF7Select(BeforeF7SelectEvent e, String orgLogo) {
        String key = e.getProperty().getName();
        int rowIndex = e.getRow();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        switch (key) {
            case "orghead": {
                ReportCommonFilterOrChangeOp.beforeF7SelectOrg(showParameter, this.view);
                break;
            }
            case "accountownerfrom": {
                ReportCommonFilterOrChangeOp.beforeF7SelectAccountOwnerFrom(showParameter, orgLogo, true, this.view);
                break;
            }
            case "supplierownerfrom": 
            case "customerownerfrom": {
                ReportCommonFilterOrChangeOp.beforeF7ShowParameterByOrg(showParameter, orgLogo, true, this.view);
                break;
            }
            case "ownerto": 
            case "materialgroupto": 
            case "materialnumberto": 
            case "warehouseto": 
            case "locationto": 
            case "projectto": 
            case "configuredcodeto": {
                ReportCommonFilterOrChangeOp.beforeF7SelectToValidate(showParameter, key, orgLogo, true, this.view);
                break;
            }
            case "materialgroupfrom": {
                ReportCommonFilterOrChangeOp.beforeF7SelectMaterialGroupFrom(showParameter, orgLogo, true, this.view);
                break;
            }
            case "materialnumberfrom": {
                ReportCommonFilterOrChangeOp.beforeF7MaterialNumber(showParameter, orgLogo, true, this.view);
                break;
            }
            case "warehousefrom": {
                ReportCommonFilterOrChangeOp.beforeF7WarehouseFrom(showParameter, orgLogo, true, this.view);
                break;
            }
            case "locationfrom": {
                ReportCommonFilterOrChangeOp.beforeF7Location(showParameter, orgLogo, true, this.view);
                break;
            }
            case "biztypeentry": {
                this.beforeF7BiztypeEntry(showParameter, rowIndex);
                break;
            }
            case "invschemeentry": {
                this.beforeInvschemeEntry(showParameter, rowIndex);
                break;
            }
            case "materialgroupstandard": {
                ReportCommonFilterOrChangeOp.beforeMaterialgroupstandard(showParameter, orgLogo, true, this.view);
                break;
            }
            case "billtypeentry": {
                this.beforeBilltypeentry(showParameter);
                break;
            }
        }
        showParameter.setF7ClickByFilter(false);
    }

    private void beforeBilltypeentry(ListShowParameter showParameter) {
        DataSet dataSet = DB.queryDataSet((String)"bos_billtype", (DBRoute)new DBRoute("sys"), (String)"select FID,FNUMBER from T_BAS_BILLTYPE where fnumber like '%im%' ");
        HashSet<Long> sets = new HashSet<Long>(10);
        while (dataSet.hasNext()) {
            long fid = dataSet.next().getLong("fid");
            sets.add(fid);
        }
        showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", sets));
    }

    private void beforeInvschemeEntry(ListShowParameter showParameter, int rowIndex) {
        DynamicObject billTypeEntity = (DynamicObject)this.getModel().getValue("billtypeentry", rowIndex);
        if (billTypeEntity == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u5f55\u5355\u636e\u7c7b\u578b\u3002", (String)"InvBillAgeRptBeforeF7Select_0", (String)"scmc-im-report", (Object[])new Object[0]));
        }
        DynamicObject bizTypeEntity = (DynamicObject)this.getModel().getValue("biztypeentry", rowIndex);
        if (null == bizTypeEntity) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u5f55\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"InvBillAgeRptBeforeF7Select_1", (String)"scmc-im-report", (Object[])new Object[0]));
        }
        QFilter qFilter = new QFilter("billform", "=", (Object)billTypeEntity.getString("billformid.number"));
        qFilter.and("bitypeentry.biztype", "=", bizTypeEntity.getPkValue());
        qFilter.and("enable", "=", (Object)Boolean.TRUE);
        showParameter.getListFilterParameter().setQFilters(Arrays.asList(qFilter.toArray()));
    }

    private void beforeF7BiztypeEntry(ListShowParameter showParameter, int rowIndex) {
        DynamicObject billTypeEntity = (DynamicObject)this.getModel().getValue("billtypeentry", rowIndex);
        if (billTypeEntity == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u5f55\u5355\u636e\u7c7b\u578b\u3002", (String)"InvBillAgeRptBeforeF7Select_0", (String)"scmc-im-report", (Object[])new Object[0]));
        }
        List bizTypes = BizTypeHelper.getBizTypeByEntityID((String)billTypeEntity.getString("billformid.number"));
        ArrayList<Object> idList = new ArrayList<Object>(bizTypes.size());
        for (DynamicObject bizType : bizTypes) {
            idList.add(bizType.getPkValue());
        }
        QFilter idf = new QFilter("id", "in", idList);
        showParameter.getListFilterParameter().setQFilters(Arrays.asList(idf.toArray()));
    }

    private IDataModel getModel() {
        return this.view.getModel();
    }
}

