/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.invbillagereport;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.scmc.im.business.helper.DataChangeHelper;
import kd.scmc.im.report.common.ReportCommonFilterOrChangeOp;

public class InvBillAgeRptPropChanged {
    private IFormView view = null;

    public InvBillAgeRptPropChanged(IFormView view) {
        this.view = view;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        Boolean triggerChangeEventLocal = (Boolean)DataChangeHelper.triggerChangeEventLocal.get();
        if (triggerChangeEventLocal != null && !triggerChangeEventLocal.booleanValue()) {
            return;
        }
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        Object oldValue = valueSet[0].getOldValue();
        int rowIndex = valueSet[0].getRowIndex();
        switch (key = e.getProperty().getName()) {
            case "ageanalysis": {
                this.handleAgeAnalysisChangeEvent(newValue);
                break;
            }
            case "orghead": {
                ReportCommonFilterOrChangeOp.handleOrgChangeEvent((DynamicObject)newValue, oldValue, this.view);
                break;
            }
            case "ownertypehead": {
                ReportCommonFilterOrChangeOp.handleOwnerTypeHeadChangeEvent(key, this.view);
                break;
            }
            case "accountownerfrom": 
            case "supplierownerfrom": 
            case "customerownerfrom": 
            case "materialgroupfrom": 
            case "warehousefrom": 
            case "locationfrom": 
            case "projectfrom": 
            case "materialnumberfrom": 
            case "configuredcodefrom": 
            case "tracknumberfrom": {
                ReportCommonFilterOrChangeOp.handleMulBasedataChangeEvent(key, this.view);
                break;
            }
            case "materialgroupstandard": 
            case "warehouseto": {
                ReportCommonFilterOrChangeOp.handleValueToNull(key, this.view);
                break;
            }
            case "displayclasssum": {
                this.handleDisplayClassSumChangeEvent(newValue);
                break;
            }
            case "billtypeentry": {
                this.handleBillTypeEntryChangeEvent(rowIndex);
                break;
            }
            case "biztypeentry": {
                this.handleBizTypeEntryChangeEvent(rowIndex);
                break;
            }
            case "intervaldays": {
                this.handleInvAgeGroupChangeEvent(rowIndex, oldValue, newValue);
            }
        }
    }

    private void handleInvAgeGroupChangeEvent(int rowIndex, Object oldValue, Object newValue) {
        if ((Integer)newValue == 0) {
            this.view.showErrorNotification(ResManager.loadKDString((String)"\u95f4\u9694\u5929\u6570\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvBillAgeRptPropChanged_3", (String)"scmc-im-report", (Object[])new Object[0]));
            DataChangeHelper.setValue((IDataModel)this.getModel(), (String)"intervaldays", (Object)oldValue, (boolean)false);
            return;
        }
        String sbFirst = ResManager.loadKDString((String)"0\u5230X\u5929", (String)"InvBillAgeRptPropChanged_0", (String)"scmc-im-report", (Object[])new Object[0]).toLowerCase();
        String secondString = sbFirst.substring(1, 2);
        String fourString = sbFirst.substring(sbFirst.length() - 1);
        if (sbFirst.toLowerCase().contains("to")) {
            StringBuffer sb = new StringBuffer(sbFirst.trim());
            sb.replace(1, 7, " to x ");
            sbFirst = sb.toString();
            secondString = "to";
            fourString = sbFirst.substring(sbFirst.indexOf("x ") + 2);
        }
        String sbSuffix = "";
        DynamicObjectCollection entry2Entity = this.getModel().getEntryEntity("entry2");
        if (entry2Entity == null || entry2Entity.isEmpty()) {
            return;
        }
        int size = entry2Entity.size();
        if (rowIndex == size - 1) {
            if (size == 2 && ((DynamicObject)entry2Entity.get(1)).getInt("intervaldays") != 0) {
                this.view.invokeOperation("newentry");
                entry2Entity = this.getModel().getEntryEntity("entry2");
                size = entry2Entity.size();
            } else if (size != 2) {
                this.view.invokeOperation("newentry");
                entry2Entity = this.getModel().getEntryEntity("entry2");
                size = entry2Entity.size();
            }
        }
        for (int i = 0; i < size; ++i) {
            String lastValue;
            int invagegroup = ((DynamicObject)entry2Entity.get(i)).getInt("intervaldays");
            if (i == 0) {
                sbFirst = sbFirst.replaceAll("x", String.valueOf(invagegroup - 1));
                DataChangeHelper.setValue((IDataModel)this.getModel(), (String)"invagegroup", (Object)sbFirst, (int)i, (boolean)false);
                sbSuffix = sbFirst;
                continue;
            }
            if (i != size - 1) {
                lastValue = sbSuffix.substring(sbSuffix.indexOf(secondString) + secondString.length(), sbSuffix.indexOf(fourString)).trim();
                String tmp = null;
                tmp = "to".equals(secondString) ? Integer.parseInt(lastValue) + 1 + " " + secondString + " " + (Integer.parseInt(lastValue) + invagegroup) + " " + fourString : Integer.parseInt(lastValue) + 1 + secondString + (Integer.parseInt(lastValue) + invagegroup) + fourString;
                DataChangeHelper.setValue((IDataModel)this.getModel(), (String)"invagegroup", (Object)tmp, (int)i, (boolean)false);
                sbSuffix = tmp;
                continue;
            }
            lastValue = sbSuffix.substring(sbSuffix.indexOf(secondString) + secondString.length(), sbSuffix.indexOf(fourString)).trim();
            int totalDay = Integer.parseInt(lastValue) + 1;
            String tmp = String.format(ResManager.loadKDString((String)"%1$s\u5929\u53ca\u4ee5\u4e0a", (String)"InvBillAgeRptPropChanged_1", (String)"scmc-im-report", (Object[])new Object[0]), totalDay);
            DataChangeHelper.setValue((IDataModel)this.getModel(), (String)"invagegroup", (Object)tmp, (int)i, (boolean)false);
            sbSuffix = tmp;
        }
    }

    private void handleBizTypeEntryChangeEvent(int rowIndex) {
        DataChangeHelper.setValue((IDataModel)this.getModel(), (String)"invschemeentry", null, (int)rowIndex, (boolean)false);
    }

    private void handleBillTypeEntryChangeEvent(int rowIndex) {
        DataChangeHelper.setValue((IDataModel)this.getModel(), (String)"biztypeentry", null, (int)rowIndex, (boolean)false);
        DataChangeHelper.setValue((IDataModel)this.getModel(), (String)"invschemeentry", null, (int)rowIndex, (boolean)false);
    }

    private void handleDisplayClassSumChangeEvent(Object newValue) {
        if (((Boolean)newValue).booleanValue()) {
            this.view.setEnable(Boolean.TRUE, new String[]{"displaysum"});
        } else {
            this.view.setEnable(Boolean.FALSE, new String[]{"displaysum"});
            this.getModel().setValue("displaysum", (Object)Boolean.FALSE);
        }
    }

    private void handleAgeAnalysisChangeEvent(Object newValue) {
        if (Integer.parseInt((String)newValue) == 1) {
            this.view.setEnable(Boolean.TRUE, new String[]{"enddate"});
            this.getModel().setValue("enddate", (Object)new Date());
        } else if (Integer.parseInt((String)newValue) == 0) {
            this.getModel().setValue("enddate", null);
            this.view.setEnable(Boolean.FALSE, new String[]{"enddate"});
        }
    }

    private IDataModel getModel() {
        return this.view.getModel();
    }
}

