/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.invbillreport;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.LinkQueryPkIdCollection;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.FormatShowFilterEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.im.business.helper.AuxptyFilterHelper;
import kd.scmc.im.report.common.AnalyseReportConst;
import kd.scmc.im.report.common.ReportCommonFilterOrChangeOp;
import kd.scmc.im.report.helper.KeeperTypeViewHelper;
import kd.scmc.im.report.helper.OwnerTypeViewHelper;
import kd.scmc.im.report.invbillreport.BaseInvBillRptBeforeF7Select;
import kd.scmc.im.report.invbillreport.BaseInvBillRptPropChanged;
import kd.scmc.im.utils.FormUtils;
import org.apache.commons.lang3.time.DateUtils;

public class BaseInvBillRptPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener,
BeforeF7SelectListener {
    public void preOpenForm(PreOpenFormEventArgs e) {
        String formid;
        ReportShowParameter showParameter = (ReportShowParameter)e.getSource();
        Map<Boolean, String> hasPermission = ReportCommonFilterOrChangeOp.checkBillPermission(showParameter, formid = showParameter.getFormId());
        if (hasPermission.containsKey(Boolean.FALSE)) {
            e.setCancel(Boolean.TRUE.booleanValue());
            e.setCancelMessage(hasPermission.get(Boolean.FALSE));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener((BeforeF7SelectListener)this, (String[])new String[]{"orghead", "accountownerfrom", "supplierownerfrom", "customerownerfrom", "ownerto", "accountkeeperfrom", "supplierkeeperfrom", "customerkeeperfrom", "keeperto", "biztypeto", "invschemeto", "materialgroupfrom", "materialgroupto", "materialnumberfrom", "materialnumberto", "warehousefrom", "warehouseto", "locationfrom", "locationto", "projectfrom", "projectto", "materialgroupstandard", "ivntypehead", "invstatushead", "biztypefrom", "biztypeto", "auxproperty", "auxdetailbd", "configuredcodeto", "tracknumberto"});
        this.addClickListeners(new String[]{"lotnumberfrom", "auxdetailbasebd"});
        ReportList reportlist = (ReportList)this.getView().getControl("REPORTLISTAP");
        reportlist.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        HashMap prop = new HashMap(1);
        HashMap<String, Integer> editor = new HashMap<String, Integer>(1);
        editor.put("maxlength", 1000000);
        prop.put("item", editor);
        this.getView().updateControlMetadata("lotnumberfrom", prop);
        OwnerTypeViewHelper.setEnableUI(this.getModel(), (IFormView)this.getView());
        KeeperTypeViewHelper.setEnableUI(this.getModel(), (IFormView)this.getView());
        AuxptyFilterHelper.setAuxEntryEnable((IDataModel)this.getModel(), (IFormView)this.getView());
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        BasedataEdit auxproperty = (BasedataEdit)this.getControl("auxproperty");
        auxproperty.setF7BatchFill(false);
        BaseInvBillRptBeforeF7Select baseInvBillRptBeforeF7Select = new BaseInvBillRptBeforeF7Select((IFormView)this.getView());
        baseInvBillRptBeforeF7Select.beforeF7Select(e, "orghead");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        BaseInvBillRptPropChanged baseInvBillRptPropChanged = new BaseInvBillRptPropChanged((IFormView)this.getView());
        baseInvBillRptPropChanged.propertyChanged(e);
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        AuxptyFilterHelper.setAuxEntryEnable((IDataModel)this.getModel(), (IFormView)this.getView());
    }

    public void afterCreateNewData(EventObject e) {
        ReportCommonFilterOrChangeOp.initOrg(this.getView(), "orghead");
        this.initDate();
        this.initStandard();
        this.handleResetButtonEvent();
    }

    public void loadOtherEntryFilter(DynamicObject scheme) {
        super.loadOtherEntryFilter(scheme);
        AuxptyFilterHelper.loadOtherEntryFilter((DynamicObject)scheme, (IDataModel)this.getModel(), (IReportView)this.getView());
    }

    public void setOtherEntryFilter(FilterInfo filterInfo) {
        AuxptyFilterHelper.setOtherEntryFilter((IDataModel)this.getModel(), (IReportView)this.getView());
    }

    private void handleResetButtonEvent() {
        this.getView().setEnable(Boolean.TRUE, new String[]{"biztypeto"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"invschemeto"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"materialgroupto"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"materialnumberto"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"warehouseto"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"locationto"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"projectto"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"lotnumberto"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"configuredcodeto"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"tracknumberto"});
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        String key = e.getFieldName();
        ReportList reportList = (ReportList)e.getSource();
        IReportListModel reportModel = reportList.getReportModel();
        int rowIndex = e.getRowIndex();
        DynamicObject rowData = reportModel.getRowData(rowIndex);
        switch (key) {
            case "billno": {
                this.showBill(rowData);
                break;
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        return this.verifyDate(queryParam);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof TextEdit) {
            TextEdit textEdit = (TextEdit)source;
            String key = textEdit.getKey();
            if ("lotnumberfrom".equals(key)) {
                this.showLotnumber(key);
            } else if ("auxdetailbasebd".equals(key)) {
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl("auxentry");
                int[] selectRows = entryGrid.getSelectRows();
                this.getPageCache().put("clickIndex", String.valueOf(selectRows[0]));
                AuxptyFilterHelper.showAuxBaseForm((String)key, (int)selectRows[0], (IFormView)this.getView(), (IDataModel)this.getModel(), (IFormPlugin)this);
            }
        }
    }

    private void showLotnumber(String actionId) {
        IReportView view = this.getView();
        Object value = this.getModel().getValue(actionId);
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setTargetKey(actionId);
        parameter.setParentFormId(view.getFormShowParameter().getParentFormId());
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setCustomParam("params", value);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("im_multitext");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnDataObj = closedCallBackEvent.getReturnData();
        switch (actionId) {
            case "lotnumberfrom": {
                if (!(returnDataObj instanceof Map)) break;
                Map returnData = (Map)returnDataObj;
                String value = String.valueOf(returnData.get("content"));
                String operateType = String.valueOf(returnData.get("operateType"));
                if (!"btnok".equals(operateType)) break;
                value = value.replaceAll("\n", ",");
                this.getModel().setValue(actionId, (Object)value);
                break;
            }
            case "auxdetailbasebd": {
                String clickIndex = this.getPageCache().get("clickIndex");
                AuxptyFilterHelper.handleClosedCallBack((Object)returnDataObj, (IDataModel)this.getModel(), (String)clickIndex);
                break;
            }
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        if (this.getView().getFormShowParameter().getCustomParam("hyperlinkFromSumPpt") != null) {
            this.getHyperLinkClickCustomParams(queryParam);
        }
        HashSet<String> hiddenColumn = new HashSet<String>(35);
        FilterInfo filterInfo = queryParam.getFilter();
        if (filterInfo.getBoolean("displayqty")) {
            if (filterInfo.getBoolean("invunit")) {
                hiddenColumn.add("baseunit");
                hiddenColumn.add("bgnbaseqty");
                hiddenColumn.add("inbaseqty");
                hiddenColumn.add("outbaseqty");
                hiddenColumn.add("balancebaseqty");
            } else {
                hiddenColumn.add("unit");
                hiddenColumn.add("bgnqty");
                hiddenColumn.add("inqty");
                hiddenColumn.add("outqty");
                hiddenColumn.add("balanceqty");
            }
        } else {
            hiddenColumn.add("unit");
            hiddenColumn.add("baseunit");
            hiddenColumn.add("bgnbaseqty");
            hiddenColumn.add("inbaseqty");
            hiddenColumn.add("outbaseqty");
            hiddenColumn.add("balancebaseqty");
            hiddenColumn.add("bgnqty");
            hiddenColumn.add("inqty");
            hiddenColumn.add("outqty");
            hiddenColumn.add("balanceqty");
        }
        if (!filterInfo.getBoolean("beginandbalance")) {
            hiddenColumn.add("balanceqty");
            hiddenColumn.add("balancebaseqty");
            hiddenColumn.add("balanceqty2nd");
        }
        if (!filterInfo.getBoolean("displayqty2nd")) {
            hiddenColumn.add("unit2nd");
            hiddenColumn.add("bgnqty2nd");
            hiddenColumn.add("inqty2nd");
            hiddenColumn.add("outqty2nd");
            hiddenColumn.add("balanceqty2nd");
        }
        if (!filterInfo.getBoolean("displayin")) {
            hiddenColumn.add("inqty");
            hiddenColumn.add("inbaseqty");
            hiddenColumn.add("inqty2nd");
        }
        if (!filterInfo.getBoolean("displayout")) {
            hiddenColumn.add("outqty");
            hiddenColumn.add("outbaseqty");
            hiddenColumn.add("outqty2nd");
        }
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        List columns = reportList.getColumns();
        this.setNeedHiddenColumn(columns, hiddenColumn);
        AuxptyFilterHelper.addAuxptyFilter((ReportQueryParam)queryParam, (IDataModel)this.getModel());
    }

    public void formatDisplayFilterField(FormatShowFilterEvent e) {
        super.formatDisplayFilterField(e);
        ReportCommonFilterOrChangeOp.formatDisplayFilterField(e);
    }

    private boolean verifyDate(ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        Date startDate = (Date)filter.getValue("startdate");
        Date enddate = (Date)filter.getValue("enddate");
        if (startDate == null || enddate == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u65e5\u671f\u3002", (String)"BaseInvBillRptPlugin_1", (String)"scmc-im-report", (Object[])new Object[0]));
            return false;
        }
        if (startDate.after(enddate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u5f97\u5927\u4e8e\u7ed3\u675f\u65e5\u671f\u3002", (String)"BaseInvBillRptPlugin_2", (String)"scmc-im-report", (Object[])new Object[0]));
            return false;
        }
        if (enddate.before(startDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u5e94\u665a\u4e8e\u5f00\u59cb\u65e5\u671f\u3002", (String)"BaseInvBillRptPlugin_3", (String)"scmc-im-report", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void initStandard() {
        this.getModel().setValue("materialgroupstandard", (Object)AnalyseReportConst.INIT_MATERIALGROUPSTANDARD_ID);
    }

    private void getHyperLinkClickCustomParams(ReportQueryParam queryParam) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        queryParam.getFilter().addFilterItem("hyperlinkFromSumPpt", formShowParameter.getCustomParam("hyperlinkFromSumPpt"));
        Object material = formShowParameter.getCustomParam("material");
        Object invtype = formShowParameter.getCustomParam("invtype");
        Object lotnumber = formShowParameter.getCustomParam("lotnumber");
        Object owner = formShowParameter.getCustomParam("owner");
        Object warehouse = formShowParameter.getCustomParam("warehouse");
        Object location = formShowParameter.getCustomParam("location");
        Object project = formShowParameter.getCustomParam("project");
        Object auxpty = formShowParameter.getCustomParam("auxpty");
        Object group = formShowParameter.getCustomParam("group");
        Object orgHyperLink = formShowParameter.getCustomParam("orgHyperLink");
        if (material != null) {
            queryParam.getFilter().addFilterItem("material", material);
        }
        if (invtype != null) {
            queryParam.getFilter().addFilterItem("invtype", invtype);
        }
        if (lotnumber != null) {
            queryParam.getFilter().addFilterItem("lotnumber", lotnumber);
        }
        if (owner != null) {
            queryParam.getFilter().addFilterItem("owner", owner);
        }
        if (warehouse != null) {
            queryParam.getFilter().addFilterItem("warehouse", warehouse);
        }
        if (location != null) {
            queryParam.getFilter().addFilterItem("location", location);
        }
        if (project != null) {
            queryParam.getFilter().addFilterItem("project", project);
        }
        if (auxpty != null) {
            queryParam.getFilter().addFilterItem("auxpty", auxpty);
        }
        if (group != null) {
            queryParam.getFilter().addFilterItem("group", group);
        }
        if (orgHyperLink != null) {
            queryParam.getFilter().addFilterItem("orgHyperLink", orgHyperLink);
        }
        queryParam.getFilter().addFilterItem("bgnqty", formShowParameter.getCustomParam("bgnqty"));
        queryParam.getFilter().addFilterItem("bgnbaseqty", formShowParameter.getCustomParam("bgnbaseqty"));
        queryParam.getFilter().addFilterItem("bgnqty2nd", formShowParameter.getCustomParam("bgnqty2nd"));
        queryParam.getFilter().addFilterItem("balanceqty", formShowParameter.getCustomParam("balanceqty"));
        queryParam.getFilter().addFilterItem("balancebaseqty", formShowParameter.getCustomParam("balancebaseqty"));
        queryParam.getFilter().addFilterItem("balanceqty2nd", formShowParameter.getCustomParam("balanceqty2nd"));
    }

    private void initDate() {
        Date date = new Date();
        Date initDate = DateUtils.addDays((Date)date, (int)-6);
        this.getModel().setValue("startdate", (Object)initDate);
        this.getModel().setValue("enddate", (Object)date);
    }

    private void showBill(DynamicObject rowData) {
        FormShowParameter formShowParameter = this.getFormShowParameterByRowData(rowData);
        this.getView().showForm(formShowParameter);
    }

    private FormShowParameter getFormShowParameterByRowData(DynamicObject rowData) {
        DynamicObject org = (DynamicObject)rowData.get("org");
        Object orgId = org.getPkValue();
        String billNo = (String)rowData.get("billno");
        String billType = (String)rowData.getDynamicObject("billtype").get("billformid.number");
        QFilter filter = new QFilter("billno", "=", (Object)billNo);
        filter = "im_transdirbill".equals(billType) ? filter.and(new QFilter("org", "=", orgId).or("outorg", "=", orgId)) : filter.and("org", "=", orgId);
        DynamicObject[] queryEntityByBillNo = BusinessDataServiceHelper.load((String)billType, (String)"id", (QFilter[])filter.toArray());
        if (queryEntityByBillNo.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6839\u636e\u5355\u636e\u7f16\u53f7\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BaseInvBillRptPlugin_0", (String)"scmc-im-report", (Object[])new Object[0]));
        }
        if (queryEntityByBillNo.length == 1) {
            BillShowParameter formShowParameter = new BillShowParameter();
            formShowParameter.setFormId(billType);
            formShowParameter.setPkId(queryEntityByBillNo[0].getPkValue());
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            return formShowParameter;
        }
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId(billType);
        LinkQueryPkIdCollection linkQueryPkIdCollection = new LinkQueryPkIdCollection();
        for (DynamicObject bill : queryEntityByBillNo) {
            linkQueryPkIdCollection.addLinkQueryPkId(bill.getPkValue());
        }
        listShowParameter.setLinkQueryPkIdCollection(linkQueryPkIdCollection);
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        return listShowParameter;
    }

    protected List<ReportColumn> setNeedHiddenColumn(List<AbstractReportColumn> columns, Set<String> hiddenColumn) {
        LinkedList<ReportColumn> needHiddenColumn = new LinkedList<ReportColumn>();
        for (AbstractReportColumn abstractReportColumn : columns) {
            ReportColumn column;
            if (abstractReportColumn instanceof ReportColumn) {
                column = (ReportColumn)abstractReportColumn;
                if (!hiddenColumn.contains(column.getFieldKey())) continue;
                column.setHide(true);
                needHiddenColumn.add(column);
                continue;
            }
            if (!(abstractReportColumn instanceof ReportColumnGroup)) continue;
            column = (ReportColumnGroup)abstractReportColumn;
            List groupColumns = column.getChildren();
            needHiddenColumn.addAll(this.setNeedHiddenColumn(groupColumns, hiddenColumn));
        }
        return needHiddenColumn;
    }
}

